/*
 * Decompiled with CFR 0.152.
 */
package optas.hydro;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.TimeZone;
import optas.data.SimpleEnsemble;
import optas.data.TimeSerie;
import optas.hydro.ParameterGroup;
import optas.tools.ObservableProgress;

public abstract class OptimizationScheme
extends ObservableProgress {
    double[][] weights;
    SimpleEnsemble[] parameter;
    SimpleEnsemble objective;
    TimeSerie ts;
    double threshold = 0.8;
    protected int n;
    protected int T;
    ArrayList<ParameterGroup> solutionGroups = new ArrayList();
    public ArrayList<int[]> dominatedTimeStepsForGroup = new ArrayList();
    SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");

    public ArrayList<ParameterGroup> getSolutionGroups() {
        return this.solutionGroups;
    }

    public void setSolutionGroups(ArrayList<ParameterGroup> groups) {
        this.solutionGroups = groups;
        this.update();
    }

    public void update() {
    }

    public void setData(double[][] weights, SimpleEnsemble[] parameterIDs, SimpleEnsemble objective, TimeSerie ts) {
        this.weights = weights;
        this.parameter = parameterIDs;
        this.objective = objective;
        this.ts = ts;
        this.n = weights.length;
        this.T = weights[0].length;
        this.sdf.setTimeZone(TimeZone.getTimeZone("GMT"));
    }

    public static ArrayList<int[]> calcDominantParameters(double[][] weights, double threshold) {
        int n = weights.length;
        int T = weights[0].length;
        double[][] weightList = new double[n][2];
        ArrayList<int[]> result = new ArrayList<int[]>();
        int[] dominantParameters = new int[n];
        for (int i = 0; i < T; ++i) {
            double sum = 0.0;
            for (int j = 0; j < n; ++j) {
                weightList[j][0] = j;
                weightList[j][1] = weights[j][i];
                sum += weights[j][i];
            }
            if (sum == 0.0) continue;
            Arrays.sort(weightList, new ArrayColumnComparator(1, true));
            double aggregatedWeight = 0.0;
            int c = 0;
            while (aggregatedWeight < threshold) {
                aggregatedWeight += weightList[c][1] / sum;
                dominantParameters[c] = (int)weightList[c][0];
                ++c;
            }
            result.add(Arrays.copyOf(dominantParameters, c));
        }
        return result;
    }

    public int[] getDominatedTimeSteps(int groupIndex) {
        return this.dominatedTimeStepsForGroup.get(groupIndex);
    }

    public String toString() {
        String result = "";
        for (int i = 0; i < this.solutionGroups.size(); ++i) {
            result = result + "+++++GROUP " + i + "++++++++++\n";
            result = result + this.solutionGroups.get(i).toString() + "+++++++++++++++++\n";
            result = result + "-------------TIME---------------\n";
            int[] tSteps = this.dominatedTimeStepsForGroup.get(i);
            for (int t = 0; t < tSteps.length; ++t) {
                result = result + this.ts.getTime(tSteps[t]).getTime() + "\n";
            }
        }
        return result;
    }

    private static class ArrayColumnComparator
    implements Comparator {
        private int col = 0;
        private int order = 1;

        public ArrayColumnComparator(int col, boolean decreasing_order) {
            this.col = col;
            this.order = decreasing_order ? -1 : 1;
        }

        public int compare(Object d1, Object d2) {
            double[] b1 = (double[])d1;
            double[] b2 = (double[])d2;
            if (b1[this.col] < b2[this.col]) {
                return -1 * this.order;
            }
            if (b1[this.col] == b2[this.col]) {
                return 0 * this.order;
            }
            return 1 * this.order;
        }
    }
}

