/*
 * Decompiled with CFR 0.152.
 */
package optas.hydro;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.TreeSet;
import optas.hydro.OptimizationScheme;
import optas.hydro.ParameterGroup;

public class GreedyOptimizationScheme
extends OptimizationScheme {
    double tau = 0.7;
    double minDominatedTimesteps = 0.2;

    @Override
    public String toString() {
        return "Greedy";
    }

    private double[] accumulateWeightsOverParameters(double[][] weights) {
        double[] sum = new double[this.T];
        for (int i = 0; i < this.n; ++i) {
            for (int j = 0; j < this.T; ++j) {
                int n = j;
                sum[n] = sum[n] + weights[i][j];
            }
        }
        return sum;
    }

    @Override
    public void update() {
        double[] weight_cur = new double[this.T];
        this.dominatedTimeStepsForGroup.clear();
        double[] weight_sum = this.accumulateWeightsOverParameters(this.weights);
        for (int i = 0; i < this.solutionGroups.size(); ++i) {
            ArrayList<Integer> timeStepsTmp = new ArrayList<Integer>();
            ParameterGroup p = (ParameterGroup)this.solutionGroups.get(i);
            for (int t = 0; t < this.T; ++t) {
                for (int j = 0; j < p.getSize(); ++j) {
                    int n = t;
                    weight_cur[n] = weight_cur[n] + this.weights[p.get(j)][t];
                }
                if (weight_cur[t] >= this.tau * weight_sum[t] - 1.0E-14) {
                    timeStepsTmp.add(t);
                }
                weight_cur[t] = 0.0;
            }
            int[] timeSteps = new int[timeStepsTmp.size()];
            for (int k = 0; k < timeStepsTmp.size(); ++k) {
                timeSteps[k] = (Integer)timeStepsTmp.get(k);
            }
            this.dominatedTimeStepsForGroup.add(timeSteps);
        }
    }

    public void calcOptimizationScheme() {
        double[] weight_old = new double[this.T];
        double[] weight_sum = this.accumulateWeightsOverParameters(this.weights);
        TreeSet<Integer> usedParameters = new TreeSet<Integer>();
        ParameterGroup allParameters = new ParameterGroup(this.parameter, this.n);
        while (usedParameters.size() < this.n) {
            boolean addMore = true;
            double[] weight_cur = new double[this.T];
            ParameterGroup group = new ParameterGroup(this.parameter, this.n).createEmptyGroup();
            while (addMore) {
                int bestParameter = -1;
                int bestTimeCover = -1;
                double bestDominationWeight = 0.0;
                double[] best_weight_cur = null;
                ArrayList<Integer> bestTimeList = null;
                for (int parameter = 0; parameter < this.n; ++parameter) {
                    if (usedParameters.contains(parameter)) continue;
                    ArrayList<Integer> timeList = new ArrayList<Integer>();
                    double[] weight_cur_tmp = Arrays.copyOf(weight_cur, weight_cur.length);
                    double domination_weight = 0.0;
                    for (int i = 0; i < this.T; ++i) {
                        double delta_weight;
                        int n = i;
                        weight_cur_tmp[n] = weight_cur_tmp[n] + this.weights[parameter][i];
                        if (weight_sum[i] != 0.0) {
                            domination_weight += weight_cur_tmp[i] / weight_sum[i];
                        }
                        if ((delta_weight = weight_sum[i] - weight_old[i]) == 0.0 || !(weight_cur_tmp[i] / delta_weight > this.tau)) continue;
                        timeList.add(i);
                    }
                    if (timeList.size() <= bestTimeCover && (timeList.size() != bestTimeCover || !(domination_weight >= bestDominationWeight))) continue;
                    bestTimeCover = timeList.size();
                    bestParameter = parameter;
                    bestDominationWeight = domination_weight;
                    bestTimeList = timeList;
                    best_weight_cur = Arrays.copyOf(weight_cur_tmp, weight_cur_tmp.length);
                }
                group.add(bestParameter);
                usedParameters.add(bestParameter);
                weight_cur = best_weight_cur;
                if (!((double)bestTimeList.size() / (double)this.T > this.minDominatedTimesteps) && usedParameters.size() < this.n) continue;
                addMore = false;
            }
            for (int i = 0; i < this.T; ++i) {
                int n = i;
                weight_old[n] = weight_old[n] + weight_cur[i];
            }
            this.solutionGroups.add(group);
            allParameters.sub(group);
        }
        this.update();
    }
}

