/*
 * Decompiled with CFR 0.152.
 */
package optas.gui.wizard;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Set;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import optas.data.DataCollection;
import optas.data.EfficiencyEnsemble;
import optas.data.Measurement;
import optas.data.TimeSerie;
import optas.data.TimeSerieEnsemble;
import optas.gui.wizard.HydrographChart;
import optas.gui.wizard.TimeFilterDialog;
import optas.gui.wizard.TimeFilterTableInput;
import optas.tools.PatchedChartPanel;

public class ObjectiveConstructorDialog
extends JDialog {
    DataCollection dc;
    JComboBox methodList = new JComboBox();
    TimeFilterDialog tfd = null;
    EfficiencyEnsemble result = null;
    boolean isApproved = false;
    JComboBox simDataBox = null;
    JComboBox msDataBox = null;
    JTextField name = new JTextField();
    TimeFilterTableInput filterList = null;
    HydrographChart chart = new HydrographChart();

    private Measurement getSelectedMeasurement() {
        Object o = this.msDataBox.getSelectedItem();
        if (o == null) {
            return null;
        }
        Measurement m = (Measurement)this.dc.getDataSet(o.toString());
        return m;
    }

    public ObjectiveConstructorDialog(DataCollection dc) {
        this.dc = dc;
        this.init();
    }

    public static boolean isApplicable(DataCollection dc) {
        return TimeFilterDialog.isApplicable(dc);
    }

    private void init() {
        this.setResizable(false);
        JPanel mainPanel = new JPanel(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        int yCounter = 0;
        c.gridx = 0;
        c.ipadx = 5;
        c.ipady = 5;
        c.insets = new Insets(5, 5, 5, 5);
        c.gridy = yCounter++;
        c.gridwidth = 1;
        c.gridheight = 1;
        c.fill = 1;
        mainPanel.add((Component)new JLabel("Name"), c);
        c.gridx = 1;
        mainPanel.add((Component)this.name, c);
        c.gridx = 0;
        c.gridy = yCounter++;
        mainPanel.add((Component)new JLabel("Efficiency Method"), c);
        c.gridx = 1;
        for (EfficiencyEnsemble.Method m : EfficiencyEnsemble.Method.values()) {
            this.methodList.addItem(m);
        }
        mainPanel.add((Component)this.methodList, c);
        JLabel label1 = new JLabel("Simulation Data");
        c.gridx = 0;
        c.gridy = yCounter++;
        mainPanel.add((Component)label1, c);
        Set<String> tsDataSets = this.dc.getDatasets(TimeSerie.class);
        if (tsDataSets.isEmpty()) {
            JOptionPane.showMessageDialog(mainPanel, "There are no simulated timeserie in the data collection!");
        }
        this.simDataBox = new JComboBox<Object>(tsDataSets.toArray());
        c.gridx = 1;
        mainPanel.add((Component)this.simDataBox, c);
        JLabel label2 = new JLabel("Measurement Data");
        c.gridx = 0;
        c.gridy = yCounter++;
        mainPanel.add((Component)label2, c);
        Set<String> msDataSets = this.dc.getDatasets(Measurement.class);
        if (msDataSets.isEmpty()) {
            JOptionPane.showMessageDialog(mainPanel, "There are no measurements in the data collection!");
        }
        this.msDataBox = new JComboBox<Object>(msDataSets.toArray());
        this.msDataBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Object o = ObjectiveConstructorDialog.this.msDataBox.getSelectedItem();
                if (o != null) {
                    ObjectiveConstructorDialog.this.chart.setHydrograph((TimeSerie)ObjectiveConstructorDialog.this.dc.getDataSet((String)o));
                }
            }
        });
        this.chart.setHydrograph((TimeSerie)this.dc.getDataSet((String)this.msDataBox.getItemAt(0)));
        c.gridx = 1;
        mainPanel.add((Component)this.msDataBox, c);
        c.gridx = 0;
        c.gridy = yCounter;
        c.gridwidth = 2;
        c.gridheight = 8;
        yCounter += 8;
        PatchedChartPanel chartPanel = new PatchedChartPanel(this.chart.getChart(), true);
        mainPanel.add((Component)((Object)chartPanel), c);
        this.filterList = new TimeFilterTableInput(this.getSelectedMeasurement());
        this.filterList.addChangeListener(new TimeFilterTableInput.TimeFilterTableInputListener(){

            @Override
            public void tableChanged(TimeFilterTableInput tfti) {
                ObjectiveConstructorDialog.this.chart.setTimeFilters(ObjectiveConstructorDialog.this.filterList.getTimeFilters());
            }

            @Override
            public void itemChanged(TimeFilterTableInput tfti) {
                ObjectiveConstructorDialog.this.chart.setTimeFilters(ObjectiveConstructorDialog.this.filterList.getTimeFilters());
            }
        });
        c.gridx = 0;
        c.gridy = yCounter;
        c.gridwidth = 2;
        c.gridheight = 5;
        mainPanel.add((Component)((Object)this.filterList), c);
        c.gridx = 0;
        c.gridy = yCounter += 5;
        c.gridwidth = 1;
        c.gridheight = 1;
        JButton exportTimeFilterButton = new JButton("Export Time-Filter");
        exportTimeFilterButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JFileChooser jfc = new JFileChooser();
                int approved = jfc.showSaveDialog(ObjectiveConstructorDialog.this);
                if (approved == 0) {
                    ObjectiveConstructorDialog.this.result = new EfficiencyEnsemble("blubb", (Measurement)ObjectiveConstructorDialog.this.dc.getDataSet((String)ObjectiveConstructorDialog.this.msDataBox.getSelectedItem()), (TimeSerieEnsemble)ObjectiveConstructorDialog.this.dc.getDataSet((String)ObjectiveConstructorDialog.this.simDataBox.getSelectedItem()), (EfficiencyEnsemble.Method)((Object)ObjectiveConstructorDialog.this.methodList.getSelectedItem()), ObjectiveConstructorDialog.this.filterList.getTimeFilters().combine());
                    ObjectiveConstructorDialog.this.result.exportTimeFilter(jfc.getSelectedFile(), ObjectiveConstructorDialog.this.chart.hydrograph.getTimeDomain());
                }
            }
        });
        mainPanel.add((Component)exportTimeFilterButton, c);
        JButton button = new JButton("Ok");
        button.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String strName = ObjectiveConstructorDialog.this.name.getText();
                if (strName.isEmpty()) {
                    JOptionPane.showMessageDialog(ObjectiveConstructorDialog.this.methodList, "Please give the new objective a name");
                    return;
                }
                ObjectiveConstructorDialog.this.result = new EfficiencyEnsemble(strName, (Measurement)ObjectiveConstructorDialog.this.dc.getDataSet((String)ObjectiveConstructorDialog.this.msDataBox.getSelectedItem()), (TimeSerieEnsemble)ObjectiveConstructorDialog.this.dc.getDataSet((String)ObjectiveConstructorDialog.this.simDataBox.getSelectedItem()), (EfficiencyEnsemble.Method)((Object)ObjectiveConstructorDialog.this.methodList.getSelectedItem()), ObjectiveConstructorDialog.this.filterList.getTimeFilters().combine());
                ObjectiveConstructorDialog.this.isApproved = true;
                ObjectiveConstructorDialog.this.setVisible(false);
            }
        });
        c.gridx = 1;
        c.gridy = yCounter++;
        c.gridwidth = 1;
        c.gridheight = 1;
        mainPanel.add((Component)button, c);
        this.getContentPane().add(mainPanel);
        this.pack();
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        int top = (screenSize.height - this.getPreferredSize().height) / 2;
        int left = (screenSize.width - this.getPreferredSize().width) / 2;
        this.setLocation(left, top);
        this.setModal(true);
    }

    public boolean getApproved() {
        return this.isApproved;
    }

    public EfficiencyEnsemble getResult() {
        return this.result;
    }
}

