/*
 * Decompiled with CFR 0.152.
 */
package optas.gui.MCAT5;

import jams.JAMS;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Paint;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Dictionary;
import java.util.Hashtable;
import java.util.Set;
import javax.swing.BorderFactory;
import javax.swing.DefaultListModel;
import javax.swing.GroupLayout;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSlider;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import optas.data.DataSet;
import optas.data.Efficiency;
import optas.data.EfficiencyEnsemble;
import optas.data.Parameter;
import optas.data.SimpleEnsemble;
import optas.gui.MCAT5.MCAT5Plot;
import optas.regression.SimpleNeuralNetwork;
import optas.tools.PatchedChartPanel;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.plot.Plot;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.renderer.LookupPaintScale;
import org.jfree.chart.renderer.PaintScale;
import org.jfree.chart.renderer.xy.XYBlockRenderer;
import org.jfree.chart.renderer.xy.XYItemRenderer;
import org.jfree.data.xy.DefaultXYZDataset;
import org.jfree.data.xy.XYDataset;
import org.jfree.ui.RectangleAnchor;

public class ParameterInterpolation2
extends MCAT5Plot {
    protected XYPlot plot = new XYPlot();
    protected PatchedChartPanel chartPanel = null;
    XYBlockRenderer bg_renderer = new XYBlockRenderer();
    JPanel panel = new JPanel(new BorderLayout());
    JSlider slider = new JSlider();
    EfficiencyEnsemble y;
    SimpleEnsemble[] params;
    SimpleEnsemble param1;
    SimpleEnsemble param2;
    double p1Min;
    double p1Max;
    double p2Min;
    double p2Max;
    int n = 0;
    SimpleNeuralNetwork knn;
    final int RESOLUTION = 100;
    int currentIndex = -1;
    double paramMin;
    double paramMax;
    double[] point;
    final JList list = new JList<String>(new String[]{"test"});
    JLabel blueLabel = new JLabel(" ");
    JLabel minLabel = new JLabel(" ");
    JLabel redLabel = new JLabel(" ");
    JLabel maxLabel = new JLabel(" ");

    public ParameterInterpolation2() {
        this.addRequest(new MCAT5Plot.SimpleRequest(JAMS.i18n((String)"PARAMETER") + "1", Parameter.class));
        this.addRequest(new MCAT5Plot.SimpleRequest(JAMS.i18n((String)"PARAMETER") + "2", Parameter.class));
        this.addRequest(new MCAT5Plot.SimpleRequest(JAMS.i18n((String)"PARAMETER"), Efficiency.class));
        this.init();
    }

    private void init() {
        LookupPaintScale paintScale = new LookupPaintScale(0.0, 1.0, (Paint)new Color(0, 0, 0));
        for (int i = 0; i <= 255; ++i) {
            Color interpolated = new Color(i, 0, 255 - i);
            paintScale.add((double)i / 255.0, (Paint)interpolated);
        }
        this.bg_renderer.setPaintScale((PaintScale)paintScale);
        this.bg_renderer.setBlockWidth(1.0);
        this.bg_renderer.setBlockAnchor(RectangleAnchor.BOTTOM_LEFT);
        this.plot.setRenderer((XYItemRenderer)this.bg_renderer);
        JFreeChart chart = new JFreeChart((Plot)this.plot);
        chart.setTitle("Interpolation");
        this.chartPanel = new PatchedChartPanel(chart, true);
        this.chartPanel.setMinimumDrawWidth(0);
        this.chartPanel.setMinimumDrawHeight(0);
        this.chartPanel.setMaximumDrawWidth(2000);
        this.chartPanel.setMaximumDrawHeight(2000);
        this.panel.add((Component)((Object)this.chartPanel), "Center");
        JPanel adjustmentPanel = new JPanel(new BorderLayout());
        this.slider.setBorder(BorderFactory.createTitledBorder("Parameter Space"));
        this.slider.setMaximum(99);
        this.slider.setMinimum(0);
        this.slider.setMajorTickSpacing(50);
        this.slider.setMinorTickSpacing(50);
        this.slider.setPaintTicks(true);
        this.slider.setPaintLabels(true);
        this.slider.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent evt) {
                ParameterInterpolation2.this.point[ParameterInterpolation2.this.currentIndex] = (ParameterInterpolation2.this.paramMax - ParameterInterpolation2.this.paramMin) * (double)ParameterInterpolation2.this.slider.getValue() / 100.0 + ParameterInterpolation2.this.paramMin;
                ParameterInterpolation2.this.updatePlot();
            }
        });
        adjustmentPanel.add((Component)this.slider, "Center");
        JPanel colorPanel = new JPanel();
        GroupLayout layout = new GroupLayout(colorPanel);
        colorPanel.setLayout(layout);
        layout.setVerticalGroup(layout.createParallelGroup().addGroup(layout.createSequentialGroup().addComponent(this.redLabel).addComponent(this.blueLabel)).addGroup(layout.createSequentialGroup().addComponent(this.minLabel).addComponent(this.maxLabel)));
        layout.setHorizontalGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup().addComponent(this.redLabel).addComponent(this.blueLabel)).addGroup(layout.createParallelGroup().addComponent(this.minLabel).addComponent(this.maxLabel)));
        this.redLabel.setOpaque(true);
        this.blueLabel.setOpaque(true);
        this.redLabel.setBackground(Color.red);
        this.blueLabel.setBackground(Color.blue);
        adjustmentPanel.add((Component)colorPanel, "South");
        this.list.setSelectionMode(1);
        this.list.setLayoutOrientation(0);
        this.list.setVisibleRowCount(-1);
        this.list.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                ParameterInterpolation2.this.currentIndex = ParameterInterpolation2.this.list.getSelectedIndex();
                NumberFormat f = NumberFormat.getInstance();
                if (ParameterInterpolation2.this.currentIndex != -1) {
                    ParameterInterpolation2.this.paramMin = ParameterInterpolation2.this.params[ParameterInterpolation2.this.currentIndex].getMin();
                    ParameterInterpolation2.this.paramMax = ParameterInterpolation2.this.params[ParameterInterpolation2.this.currentIndex].getMax();
                    Hashtable<Integer, JLabel> labels = new Hashtable<Integer, JLabel>();
                    for (int i = 0; i <= 100; i += 20) {
                        ((Dictionary)labels).put(i, new JLabel(f.format((double)i * ((ParameterInterpolation2.this.paramMax - ParameterInterpolation2.this.paramMin) / 100.0) + ParameterInterpolation2.this.paramMin)));
                    }
                    ParameterInterpolation2.this.slider.setLabelTable(labels);
                    ParameterInterpolation2.this.slider.setValue((int)Math.round((ParameterInterpolation2.this.point[ParameterInterpolation2.this.currentIndex] - ParameterInterpolation2.this.paramMin) / (ParameterInterpolation2.this.paramMax - ParameterInterpolation2.this.paramMin) * 100.0));
                    ParameterInterpolation2.this.slider.setEnabled(true);
                    ParameterInterpolation2.this.updatePlot();
                } else {
                    ParameterInterpolation2.this.slider.setEnabled(false);
                }
            }
        });
        JScrollPane listScroller = new JScrollPane(this.list);
        listScroller.setPreferredSize(new Dimension(250, 200));
        JPanel listPanel = new JPanel(new BorderLayout());
        listPanel.add((Component)new JLabel("Parameter"), "North");
        listPanel.add((Component)listScroller, "South");
        adjustmentPanel.add((Component)listPanel, "North");
        this.panel.add((Component)adjustmentPanel, "East");
        this.redraw();
    }

    public void updatePlot() {
        int j;
        int i;
        int K = 100;
        DefaultXYZDataset xyz_dataset = new DefaultXYZDataset();
        int index1 = 0;
        int index2 = 0;
        for (int i2 = 0; i2 < this.n; ++i2) {
            if (this.params[i2].name.equals(this.param1.name)) {
                index1 = i2;
            }
            if (!this.params[i2].name.equals(this.param2.name)) continue;
            index2 = i2;
        }
        double[][] dotMap = new double[3][K * K];
        double[] x = Arrays.copyOf(this.point, this.point.length);
        double yMin = Double.MAX_VALUE;
        double yMax = Double.MIN_VALUE;
        for (i = 0; i < K; ++i) {
            for (j = 0; j < K; ++j) {
                x[index1] = this.p1Min + (double)i * (this.p1Max - this.p1Min) / 100.0;
                x[index2] = this.p2Min + (double)j * (this.p2Max - this.p2Min) / 100.0;
                dotMap[0][i * K + j] = x[index1];
                dotMap[1][i * K + j] = x[index2];
                double[] v = this.knn.getInterpolatedValue(x);
                dotMap[2][i * K + j] = v[0];
                yMax = Math.max(yMax, v[0]);
                yMin = Math.min(yMin, v[0]);
            }
        }
        this.minLabel.setText(Double.toString(yMin));
        this.maxLabel.setText(Double.toString(yMax));
        for (i = 0; i < K; ++i) {
            for (j = 0; j < K; ++j) {
                dotMap[2][i * K + j] = (dotMap[2][i * K + j] - yMin) / (yMax - yMin);
            }
        }
        xyz_dataset.addSeries((Comparable)Integer.valueOf(0), dotMap);
        this.bg_renderer.setBlockHeight((this.p2Max - this.p2Min) / 100.0);
        this.bg_renderer.setBlockWidth((this.p1Max - this.p1Min) / 100.0);
        this.plot.setDataset(0, (XYDataset)xyz_dataset);
    }

    @Override
    public void refresh() throws MCAT5Plot.NoDataException {
        int i;
        if (!this.isRequestFulfilled()) {
            return;
        }
        ArrayList<DataSet>[] p = this.getData(new int[]{0, 1, 2});
        this.param1 = (SimpleEnsemble)p[0].get(0);
        this.param2 = (SimpleEnsemble)p[1].get(0);
        this.p1Min = this.param1.getMin();
        this.p2Min = this.param2.getMin();
        this.p1Max = this.param1.getMax();
        this.p2Max = this.param2.getMax();
        this.y = (EfficiencyEnsemble)p[2].get(0);
        this.plot.setDomainAxis((ValueAxis)new NumberAxis(this.param1.getName()));
        this.plot.setRangeAxis((ValueAxis)new NumberAxis(this.param2.getName()));
        Set<String> xSet = this.getDataSource().getDatasets(Parameter.class);
        this.params = new SimpleEnsemble[xSet.size()];
        int counter = 0;
        for (String name : xSet) {
            this.params[counter++] = this.getDataSource().getSimpleEnsemble(name);
        }
        this.n = this.params.length;
        Object[] listItem = new Object[this.params.length];
        for (int i2 = 0; i2 < this.params.length; ++i2) {
            listItem[i2] = this.params[i2].name;
        }
        DefaultListModel<Object> model = new DefaultListModel<Object>();
        for (i = 0; i < this.n; ++i) {
            model.addElement(listItem[i]);
        }
        this.list.setModel(model);
        this.knn = new SimpleNeuralNetwork();
        this.knn.setComplexityAdjustmentFactor(2);
        this.knn.setData(this.params, this.y);
        this.knn.init();
        this.point = new double[this.n];
        for (i = 0; i < this.n; ++i) {
            this.point[i] = (this.params[i].getMax() + this.params[i].getMin()) * 0.5;
        }
        if (this.plot.getRangeAxis() != null) {
            this.plot.getRangeAxis().setRange(this.p1Min, this.p1Max);
        }
        if (this.plot.getDomainAxis() != null) {
            this.plot.getDomainAxis().setRange(this.p2Min, this.p2Max);
        }
        this.updatePlot();
    }

    @Override
    public JPanel getPanel() {
        return this.panel;
    }
}

