/*
 * Decompiled with CFR 0.152.
 */
package optas.gui.MCAT5;

import jams.JAMS;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Paint;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Dictionary;
import java.util.Hashtable;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSlider;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import optas.data.DataSet;
import optas.data.Measurement;
import optas.data.Parameter;
import optas.data.SimpleEnsemble;
import optas.data.TimeSerie;
import optas.data.TimeSerieEnsemble;
import optas.gui.MCAT5.MCAT5Plot;
import optas.tools.PatchedChartPanel;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.plot.Plot;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.renderer.xy.XYItemRenderer;
import org.jfree.chart.renderer.xy.XYLineAndShapeRenderer;
import org.jfree.data.xy.XYDataset;
import org.jfree.data.xy.XYSeries;
import org.jfree.data.xy.XYSeriesCollection;

public class ParameterInterpolation
extends MCAT5Plot {
    XYPlot plot = new XYPlot();
    PatchedChartPanel chartPanel = null;
    JPanel panel = null;
    JSlider slider = new JSlider();
    TimeSerieEnsemble timeserie;
    SimpleEnsemble[] params;
    double[][] interpolatedTS;
    final int RESOLUTION = 100;
    int currentIndex = -1;
    double paramMin;
    double paramMax;
    double[] point;
    double globalMin = Double.MAX_VALUE;
    double globalMax = Double.MIN_VALUE;

    public ParameterInterpolation() {
        this.addRequest(new MCAT5Plot.SimpleRequest(JAMS.i18n((String)"SIMULATED_TIMESERIE"), TimeSerie.class));
        this.addRequest(new MCAT5Plot.SimpleRequest(JAMS.i18n((String)"PARAMETER"), Parameter.class, 1, 10));
        this.addRequest(new MCAT5Plot.SimpleRequest(JAMS.i18n((String)"OBSERVED_TIMESERIE"), Measurement.class));
        this.init();
    }

    private void init() {
        XYLineAndShapeRenderer renderer = new XYLineAndShapeRenderer();
        renderer.setSeriesPaint(0, (Paint)new Color(0, 0, 255));
        renderer.setSeriesVisibleInLegend(0, Boolean.valueOf(true));
        renderer.setSeriesPaint(1, (Paint)new Color(255, 0, 0));
        renderer.setSeriesVisibleInLegend(1, Boolean.valueOf(true));
        renderer.setBaseShapesVisible(false);
        this.plot.setRenderer((XYItemRenderer)renderer);
        this.plot.setDomainAxis((ValueAxis)new NumberAxis(JAMS.i18n((String)"TIME")));
        this.plot.setRangeAxis((ValueAxis)new NumberAxis(JAMS.i18n((String)"OUTPUT")));
    }

    @Override
    public void refresh() throws MCAT5Plot.NoDataException {
        if (!this.isRequestFulfilled()) {
            return;
        }
        ArrayList<DataSet>[] p = this.getData(new int[]{0, 1, 2});
        this.timeserie = (TimeSerieEnsemble)p[0].get(0);
        ArrayList<DataSet> dataInParam = p[1];
        Measurement obs = (Measurement)p[2].get(0);
        this.params = new SimpleEnsemble[dataInParam.size()];
        int timesteps = this.timeserie.getTimesteps();
        this.interpolatedTS = new double[100][timesteps];
        this.point = new double[this.params.length];
        for (int t = 0; t < timesteps; ++t) {
            for (int j = 0; j < this.timeserie.getSize(); ++j) {
                if (this.timeserie.get(t, j) < this.globalMin) {
                    this.globalMin = this.timeserie.get(t, j);
                }
                if (!(this.timeserie.get(t, j) > this.globalMax)) continue;
                this.globalMax = this.timeserie.get(t, j);
            }
        }
        if (this.plot.getDomainAxis() != null) {
            this.plot.getDomainAxis().setAutoRange(true);
        }
        if (this.plot.getRangeAxis() != null) {
            this.plot.getRangeAxis().setRange(this.globalMin, this.globalMax);
        }
        JFreeChart chart = new JFreeChart((Plot)this.plot);
        chart.setTitle("Interpolation");
        this.chartPanel = new PatchedChartPanel(chart, true);
        this.chartPanel.setMinimumDrawWidth(0);
        this.chartPanel.setMinimumDrawHeight(0);
        this.chartPanel.setMaximumDrawWidth(2000);
        this.chartPanel.setMaximumDrawHeight(2000);
        this.panel = new JPanel(new BorderLayout());
        this.panel.add((Component)((Object)this.chartPanel), "West");
        JPanel adjustmentPanel = new JPanel(new BorderLayout());
        this.slider.setBorder(BorderFactory.createTitledBorder("Parameter Space"));
        this.slider.setMaximum(99);
        this.slider.setMinimum(0);
        this.slider.setMajorTickSpacing(50);
        this.slider.setMinorTickSpacing(50);
        this.slider.setPaintTicks(true);
        this.slider.setPaintLabels(true);
        this.slider.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent evt) {
                ParameterInterpolation.this.point[ParameterInterpolation.this.currentIndex] = (ParameterInterpolation.this.paramMax - ParameterInterpolation.this.paramMin) * (double)ParameterInterpolation.this.slider.getValue() / 100.0 + ParameterInterpolation.this.paramMin;
                ParameterInterpolation.this.redraw();
            }
        });
        adjustmentPanel.add((Component)this.slider, "Center");
        Object[] listItem = new Object[this.params.length];
        for (int i = 0; i < this.params.length; ++i) {
            listItem[i] = this.params[i].name;
        }
        final JList<Object> list = new JList<Object>(listItem);
        list.setSelectionMode(1);
        list.setLayoutOrientation(0);
        list.setVisibleRowCount(-1);
        list.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                ParameterInterpolation.this.currentIndex = list.getSelectedIndex();
                NumberFormat f = NumberFormat.getInstance();
                if (ParameterInterpolation.this.currentIndex != -1) {
                    ParameterInterpolation.this.paramMin = ParameterInterpolation.this.params[ParameterInterpolation.this.currentIndex].getMin();
                    ParameterInterpolation.this.paramMax = ParameterInterpolation.this.params[ParameterInterpolation.this.currentIndex].getMax();
                    Hashtable<Integer, JLabel> labels = new Hashtable<Integer, JLabel>();
                    for (int i = 0; i <= 100; i += 10) {
                        ((Dictionary)labels).put(i, new JLabel(f.format((double)i * ((ParameterInterpolation.this.paramMax - ParameterInterpolation.this.paramMin) / 100.0) + ParameterInterpolation.this.paramMin)));
                    }
                    ParameterInterpolation.this.slider.setLabelTable(labels);
                    ParameterInterpolation.this.slider.setValue((int)Math.round((ParameterInterpolation.this.point[ParameterInterpolation.this.currentIndex] - ParameterInterpolation.this.paramMin) / (ParameterInterpolation.this.paramMax - ParameterInterpolation.this.paramMin) * 100.0));
                    ParameterInterpolation.this.slider.setEnabled(true);
                    ParameterInterpolation.this.doInterpolation(ParameterInterpolation.this.currentIndex);
                    ParameterInterpolation.this.redraw();
                } else {
                    ParameterInterpolation.this.slider.setEnabled(false);
                }
            }
        });
        JScrollPane listScroller = new JScrollPane(list);
        listScroller.setPreferredSize(new Dimension(250, 200));
        JPanel listPanel = new JPanel(new BorderLayout());
        listPanel.add((Component)new JLabel("Parameter"), "North");
        listPanel.add((Component)listScroller, "South");
        adjustmentPanel.add((Component)listPanel, "North");
        this.panel.add((Component)adjustmentPanel, "East");
        XYSeriesCollection series = new XYSeriesCollection();
        XYSeries dataset1 = new XYSeries((Comparable)((Object)JAMS.i18n((String)"HIGH_LIKELIHOOD")));
        XYSeries dataset2 = new XYSeries((Comparable)((Object)JAMS.i18n((String)"HIGH_LIKELIHOOD")));
        for (int j = 0; j < timesteps; ++j) {
            dataset1.add((double)j, obs.getValue(j));
        }
        series.addSeries(dataset1);
        if (this.currentIndex != -1) {
            int k = (int)Math.round((this.point[this.currentIndex] - this.paramMin) / (this.paramMax - this.paramMin) * 100.0);
            for (int j = 0; j < timesteps; ++j) {
                dataset2.add((double)j, this.interpolatedTS[k][j]);
            }
            series.addSeries(dataset2);
        }
        this.plot.setDataset((XYDataset)series);
    }

    public void doInterpolation(int parameter) {
        int r;
        double[][] weights = new double[100][this.timeserie.getSize()];
        double[] sum = new double[100];
        for (r = 0; r < 100; ++r) {
            double p = this.paramMin + (this.paramMax - this.paramMin) * (double)r / 100.0;
            sum[r] = 0.0;
            for (int i = 0; i < this.timeserie.getSize(); ++i) {
                double dist = 0.0;
                for (int j = 0; j < this.params.length; ++j) {
                    if (j != parameter) {
                        dist += (this.params[j].getValue(i) - this.point[j]) * (this.params[j].getValue(i) - this.point[j]);
                        continue;
                    }
                    dist += (this.params[j].getValue(i) - p) * (this.params[j].getValue(i) - p);
                }
                weights[r][i] = 1.0 / Math.sqrt(dist);
                int n = r;
                sum[n] = sum[n] + weights[r][i];
            }
        }
        for (r = 0; r < 100; ++r) {
            int i = 0;
            while (i < this.timeserie.getSize()) {
                double[] dArray = weights[r];
                int n = i++;
                dArray[n] = dArray[n] / sum[r];
            }
            for (int t = 0; t < this.timeserie.getTimesteps(); ++t) {
                this.interpolatedTS[r][t] = 0.0;
                for (int i2 = 0; i2 < this.timeserie.getSize(); ++i2) {
                    double[] dArray = this.interpolatedTS[r];
                    int n = t;
                    dArray[n] = dArray[n] + this.timeserie.get(t, i2) * weights[r][i2];
                }
            }
        }
    }

    @Override
    public JPanel getPanel() {
        return this.panel;
    }
}

