/*
 * Decompiled with CFR 0.152.
 */
package optas.gui.MCAT5;

import jams.JAMS;
import jams.gui.ObserverWorkerDlg;
import jams.gui.WorkerDlg;
import java.awt.Frame;
import java.awt.Window;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Observable;
import java.util.Observer;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import optas.data.DataCollection;
import optas.data.DataSet;
import optas.data.Ensemble;

public abstract class MCAT5Plot
extends Observable {
    final int MAXIMUM_WIDTH = 2000;
    final int MAXIMUM_HEIGHT = 2000;
    private ArrayList<SimpleRequest> request = new ArrayList();
    private ArrayList<Result> ensembles = new ArrayList();
    private DataCollection data = null;
    private ObserverWorkerDlg progress = null;

    public abstract void refresh() throws NoDataException;

    public void setState(String state) {
        this.setChanged();
        this.notifyObservers(state);
    }

    public void redraw() {
        Frame parent;
        Frame frame = parent = JFrame.getFrames().length > 0 ? JFrame.getFrames()[0] : null;
        while (this.progress != null) {
            try {
                Thread.sleep(200L);
            }
            catch (Exception exception) {}
        }
        this.progress = new ObserverWorkerDlg(new WorkerDlg((Window)parent, "Updating plot"));
        this.addObserver((Observer)this.progress);
        this.progress.getWorkerDlg().setInderminate(true);
        this.progress.getWorkerDlg().setTask(new Runnable(){

            @Override
            public void run() {
                try {
                    MCAT5Plot.this.refresh();
                }
                catch (NoDataException e) {
                    JOptionPane.showMessageDialog(MCAT5Plot.this.getPanel(), JAMS.i18n((String)"Failed_to_show_dataset_The_data_is_incommensurate!"));
                }
                catch (Throwable e) {
                    e.printStackTrace();
                }
            }
        });
        this.progress.getWorkerDlg().execute();
        this.deleteObserver((Observer)this.progress);
        this.progress = null;
    }

    public abstract JPanel getPanel();

    protected void addRequest(SimpleRequest r) {
        this.request.add(r);
        this.ensembles.add(new Result());
    }

    public ArrayList<SimpleRequest> getRequiredData() {
        return this.request;
    }

    public void setDataSource(DataCollection collection) {
        this.data = collection;
    }

    public DataCollection getDataSource() {
        return this.data;
    }

    public void reset() {
        for (int i = 0; i < this.ensembles.size(); ++i) {
            this.ensembles.set(i, null);
        }
    }

    public void setData(String name, ArrayList<DataSet> data) {
        for (int i = 0; i < this.request.size(); ++i) {
            if (!name.equals(this.request.get((int)i).name)) continue;
            this.ensembles.set(i, new Result(data));
        }
    }

    public void setData(String name, DataSet data) {
        for (int i = 0; i < this.request.size(); ++i) {
            if (!name.equals(this.request.get((int)i).name)) continue;
            ArrayList<DataSet> a = new ArrayList<DataSet>();
            a.add(data);
            this.ensembles.set(i, new Result(a));
        }
    }

    protected boolean isRequestFulfilled() {
        for (Result r : this.ensembles) {
            if (r.valid) continue;
            return false;
        }
        return true;
    }

    public ArrayList<DataSet>[] compile(int[] list) throws NoDataException {
        Ensemble ensemble;
        HashSet commonIds = new HashSet();
        if (!this.isRequestFulfilled()) {
            return null;
        }
        boolean firstIteration = true;
        for (int i = 0; i < list.length; ++i) {
            Result r = this.ensembles.get(list[i]);
            for (DataSet d : r.data) {
                HashSet<Integer> ids = new HashSet<Integer>();
                if (!(d instanceof Ensemble)) continue;
                ensemble = (Ensemble)d;
                ids.addAll(Arrays.asList(ensemble.getIds()));
                if (firstIteration) {
                    commonIds.addAll(ids);
                    firstIteration = false;
                    continue;
                }
                commonIds.retainAll(ids);
            }
        }
        ArrayList[] set = new ArrayList[list.length];
        for (int i = 0; i < list.length; ++i) {
            Result r = this.ensembles.get(list[i]);
            set[i] = new ArrayList();
            for (DataSet d : r.data) {
                if (d instanceof Ensemble) {
                    Integer[] ids;
                    ensemble = ((Ensemble)d).clone();
                    for (Integer id : ids = ensemble.getIds()) {
                        if (commonIds.contains(id)) continue;
                        ensemble.removeId(id);
                    }
                    if (ensemble.getSize() <= 0) {
                        throw new NoDataException("the selected datasets are incommensurate");
                    }
                    set[i].add(ensemble);
                    continue;
                }
                set[i].add(d);
            }
        }
        return set;
    }

    protected ArrayList<DataSet>[] getData(int[] index) throws NoDataException {
        return this.compile(index);
    }

    public class Result {
        ArrayList<DataSet> data;
        boolean valid;

        public Result() {
            this.data = new ArrayList();
            this.data.add(new DataSet());
            this.valid = false;
        }

        public Result(ArrayList<DataSet> data) {
            this.data = data;
            this.valid = true;
        }
    }

    public class SimpleRequest {
        public String name;
        public Class clazz;
        public int min;
        public int max;

        public SimpleRequest(String name, Class clazz) {
            this.name = name;
            this.clazz = clazz;
            this.min = 1;
            this.max = 1;
        }

        public SimpleRequest(String name, Class clazz, int min, int max) {
            this.name = name;
            this.clazz = clazz;
            this.min = min;
            this.max = max;
        }
    }

    public static class NoDataException
    extends Exception {
        public SimpleRequest r;
        public String error;

        public NoDataException(SimpleRequest r) {
            this.r = r;
        }

        public NoDataException(String r) {
            this.error = r;
        }

        @Override
        public String toString() {
            if (this.r != null) {
                return "no data for " + this.r.clazz;
            }
            return this.error;
        }
    }
}

