/*
 * Decompiled with CFR 0.152.
 */
package optas.gui.MCAT5;

import jams.JAMS;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Paint;
import java.util.ArrayList;
import java.util.Arrays;
import javax.swing.BorderFactory;
import javax.swing.GroupLayout;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.JTextField;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import optas.data.DataSet;
import optas.data.Efficiency;
import optas.data.EfficiencyEnsemble;
import optas.data.Parameter;
import optas.data.SimpleEnsemble;
import optas.gui.MCAT5.MCAT5Plot;
import optas.tools.PatchedChartPanel;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.plot.Plot;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.renderer.xy.StandardXYBarPainter;
import org.jfree.chart.renderer.xy.XYBarPainter;
import org.jfree.chart.renderer.xy.XYBarRenderer;
import org.jfree.chart.renderer.xy.XYItemRenderer;
import org.jfree.chart.renderer.xy.XYLineAndShapeRenderer;
import org.jfree.data.xy.XYBarDataset;
import org.jfree.data.xy.XYDataset;
import org.jfree.data.xy.XYSeries;
import org.jfree.data.xy.XYSeriesCollection;

public class IdentifiabilityPlot
extends MCAT5Plot {
    XYPlot plot = new XYPlot();
    PatchedChartPanel chartPanel = null;
    JPanel mainPanel;
    JTextField groupCount = new JTextField(2);
    int boxCount = 10;

    public IdentifiabilityPlot() {
        this.addRequest(new MCAT5Plot.SimpleRequest(this, JAMS.i18n((String)"PARAMETER"), Parameter.class));
        this.addRequest(new MCAT5Plot.SimpleRequest(this, JAMS.i18n((String)"Efficiency"), Efficiency.class));
        this.init();
    }

    private void init() {
        JFreeChart chart = new JFreeChart((Plot)this.plot);
        chart.removeLegend();
        chart.setTitle(JAMS.i18n((String)"IDENTIFYABLITY_PLOT"));
        this.chartPanel = new PatchedChartPanel(chart, true);
        this.chartPanel.setMinimumDrawWidth(0);
        this.chartPanel.setMinimumDrawHeight(0);
        this.chartPanel.setMaximumDrawWidth(2000);
        this.chartPanel.setMaximumDrawHeight(2000);
        chart.getPlot().setBackgroundPaint((Paint)Color.white);
        XYLineAndShapeRenderer gradient_renderer = new XYLineAndShapeRenderer();
        gradient_renderer.setSeriesPaint(0, (Paint)Color.BLACK);
        gradient_renderer.setBaseShapesVisible(false);
        this.plot.setRenderer(0, (XYItemRenderer)gradient_renderer);
        JPanel sliderPanel = new JPanel(new FlowLayout(2));
        sliderPanel.setMaximumSize(new Dimension(250, 60));
        sliderPanel.setPreferredSize(new Dimension(250, 60));
        sliderPanel.setMinimumSize(new Dimension(250, 60));
        JSlider slider = new JSlider();
        slider.setMinimum(2);
        slider.setMaximum(30);
        slider.setValue(this.boxCount);
        this.groupCount.setText(Integer.toString(this.boxCount));
        this.groupCount.setEnabled(false);
        slider.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                JSlider slider = (JSlider)e.getSource();
                IdentifiabilityPlot.this.boxCount = slider.getValue();
                IdentifiabilityPlot.this.groupCount.setText(Integer.toString(IdentifiabilityPlot.this.boxCount));
                IdentifiabilityPlot.this.redraw();
            }
        });
        sliderPanel.setBorder(BorderFactory.createTitledBorder(JAMS.i18n((String)"number_of_groups")));
        sliderPanel.add(slider);
        sliderPanel.add(this.groupCount);
        this.groupCount.setMaximumSize(new Dimension(60, 60));
        this.mainPanel = new JPanel();
        GroupLayout layout = new GroupLayout(this.mainPanel);
        this.mainPanel.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent((Component)((Object)this.chartPanel)).addComponent(sliderPanel));
        layout.setVerticalGroup(layout.createSequentialGroup().addComponent((Component)((Object)this.chartPanel)).addComponent(sliderPanel));
        this.redraw();
    }

    @Override
    public void refresh() throws MCAT5Plot.NoDataException {
        int i;
        if (!this.isRequestFulfilled()) {
            return;
        }
        ArrayList<DataSet>[] p = this.getData(new int[]{0, 1});
        SimpleEnsemble p1 = (SimpleEnsemble)p[0].get(0);
        EfficiencyEnsemble p2 = (EfficiencyEnsemble)p[1].get(0);
        this.plot.setDomainAxis((ValueAxis)new NumberAxis(p1.getName()));
        this.plot.setRangeAxis((ValueAxis)new NumberAxis(JAMS.i18n((String)"CUMULATIVE_DISTRIBUTION")));
        XYSeries[] dataset_box = new XYSeries[this.boxCount];
        XYSeries dataset = new XYSeries((Comparable)((Object)JAMS.i18n((String)"CUMULATIVE_DISTRIBUTION")));
        for (int i2 = 0; i2 < this.boxCount; ++i2) {
            dataset_box[i2] = new XYSeries((Comparable)Integer.valueOf(i2));
        }
        XYBarRenderer renderer = new XYBarRenderer(0.33 / (double)this.boxCount);
        renderer.setShadowVisible(false);
        renderer.setBarPainter((XYBarPainter)new StandardXYBarPainter());
        Integer[] sortedIds = p2.sort();
        double threshold = (double)p1.getSize() * 0.1;
        double[] best = new double[(int)threshold];
        double[] boxes = new double[this.boxCount];
        for (int i3 = 0; i3 < (int)threshold; ++i3) {
            best[i3] = p1.getValue(sortedIds[i3]);
        }
        Arrays.sort(best);
        double value = 0.0;
        double min = best[0];
        double max = best[best.length - 1];
        for (i = 0; i < (int)threshold; ++i) {
            int index;
            dataset.add(best[i], value);
            value += 1.0 / threshold;
            int n = index = (int)((best[i] - min) / (max - min) * (double)boxes.length - 1.0E-4);
            boxes[n] = boxes[n] + 1.0 / threshold;
        }
        for (i = 0; i < this.boxCount; ++i) {
            dataset_box[i].add((max - min) / (double)(boxes.length - 1) * (double)i + min, boxes[i]);
        }
        XYSeriesCollection XYBarSerie = new XYSeriesCollection();
        for (int i4 = 0; i4 < this.boxCount; ++i4) {
            int color = (int)((1.0 - boxes[i4]) * 255.0);
            XYBarSerie.addSeries(dataset_box[i4]);
            renderer.setSeriesPaint(i4, (Paint)new Color(color, color, color));
        }
        this.plot.setRenderer(1, (XYItemRenderer)renderer);
        this.plot.setDataset(1, (XYDataset)new XYBarDataset((XYDataset)XYBarSerie, (max - min) / (double)this.boxCount));
        this.plot.setDataset(0, (XYDataset)new XYSeriesCollection(dataset));
        if (this.plot.getRangeAxis() != null) {
            this.plot.getRangeAxis().setAutoRange(true);
        }
        if (this.plot.getDomainAxis() != null) {
            this.plot.getDomainAxis().setAutoRange(true);
        }
    }

    @Override
    public JPanel getPanel() {
        return this.mainPanel;
    }
}

