/*
 * Decompiled with CFR 0.152.
 */
package optas.gui.MCAT5;

public class Efficiencies {
    public static double[] CalculateLikelihood(double[] measure) {
        int i;
        int i2;
        int n = measure.length;
        double[] likelihood = new double[n];
        double Lmin = Double.POSITIVE_INFINITY;
        for (i2 = 0; i2 < n; ++i2) {
            likelihood[i2] = measure[i2];
            if (!(likelihood[i2] < Lmin)) continue;
            Lmin = likelihood[i2];
        }
        if (Lmin < 0.0) {
            i2 = 0;
            while (i2 < n) {
                int n2 = i2++;
                likelihood[n2] = likelihood[n2] - Lmin;
            }
        }
        double sum = 0.0;
        for (i = 0; i < n; ++i) {
            sum += likelihood[i];
        }
        i = 0;
        while (i < n) {
            int n3 = i++;
            likelihood[n3] = likelihood[n3] / sum;
        }
        return likelihood;
    }

    public static double[] CalculateR2(double[] xData, double[] yData) {
        int i;
        double sumYValue = 0.0;
        double meanYValue = 0.0;
        double sumXValue = 0.0;
        double meanXValue = 0.0;
        double sumX = 0.0;
        double sumY = 0.0;
        double prod = 0.0;
        int nstat = xData.length;
        double[] regCoef = new double[3];
        for (i = 0; i < nstat; ++i) {
            sumYValue += yData[i];
            sumXValue += xData[i];
        }
        meanYValue = sumYValue / (double)nstat;
        meanXValue = sumXValue / (double)nstat;
        for (i = 0; i < nstat; ++i) {
            sumX += Math.pow(xData[i] - meanXValue, 2.0);
            sumY += Math.pow(yData[i] - meanYValue, 2.0);
            prod += (xData[i] - meanXValue) * (yData[i] - meanYValue);
        }
        regCoef[0] = meanYValue - regCoef[1] * meanXValue;
        regCoef[1] = prod / sumX;
        regCoef[2] = Math.pow(prod / Math.sqrt(sumX * sumY), 2.0);
        return regCoef;
    }

    public static double[] ArrayLog(double[] input) {
        double[] output = new double[input.length];
        for (int i = 0; i < output.length; ++i) {
            output[i] = input[i] > 0.0 ? Math.log(input[i]) : -1.0;
        }
        return output;
    }

    public static double CalculateE(double[] obs, double[] sim, int pow) {
        int i;
        double a = 0.0;
        double b = 0.0;
        double mw = 0.0;
        for (i = 0; i < obs.length; ++i) {
            mw += obs[i];
        }
        mw /= (double)obs.length;
        for (i = 0; i < obs.length; ++i) {
            a += Math.pow(Math.abs(obs[i] - sim[i]), pow);
            b += Math.pow(Math.abs(obs[i] - mw), pow);
        }
        if (b == 0.0) {
            b = 0.001;
        }
        return 1.0 - a / b;
    }

    public static double CalculateIndexOfAgreement(double[] validation, double[] prediction, int pow) {
        int td_size = prediction.length;
        int vd_size = validation.length;
        int steps = 0;
        double sum_td = 0.0;
        double sum_vd = 0.0;
        if (td_size != vd_size) {
            return Double.NEGATIVE_INFINITY;
        }
        steps = td_size;
        for (int i = 0; i < steps; ++i) {
            sum_td += prediction[i];
            sum_vd += validation[i];
        }
        double mean_td = sum_td / (double)steps;
        double mean_vd = sum_vd / (double)steps;
        double td_vd = 0.0;
        double vd_mean = 0.0;
        for (int i = 0; i < steps; ++i) {
            td_vd += Math.pow(Math.abs(validation[i] - prediction[i]), pow);
            vd_mean += Math.pow(Math.abs(validation[i] - mean_vd), pow);
        }
        double abs_sqDevi = 0.0;
        for (int i = 0; i < steps; ++i) {
            abs_sqDevi += Math.pow(Math.abs(prediction[i] - mean_vd) + Math.abs(validation[i] - mean_vd), pow);
        }
        double ioa = 1.0 - td_vd / abs_sqDevi;
        return ioa;
    }

    public static double CalculateDSGrad(double[] prediction, double[] validation) {
        int dsLength = prediction.length;
        double[] cumPred = new double[dsLength];
        double[] cumVali = new double[dsLength];
        double cp = 0.0;
        double cv = 0.0;
        for (int i = 0; i < dsLength; ++i) {
            cumPred[i] = cp += prediction[i];
            cumVali[i] = cv += validation[i];
        }
        return Efficiencies.CalculateR2(cumVali, cumPred)[1];
    }

    public static double CalculateAbsVolError(double[] validation, double[] prediction) {
        double volError = 0.0;
        for (int i = 0; i < prediction.length; ++i) {
            volError += prediction[i] - validation[i];
        }
        return Math.abs(volError);
    }

    public static double CalculateRMSE(double[] validation, double[] prediction) {
        double rmse = 0.0;
        for (int i = 0; i < prediction.length; ++i) {
            rmse += (prediction[i] - validation[i]) * (prediction[i] - validation[i]);
        }
        return Math.sqrt(rmse);
    }

    public static double CalculatePBIAS(double[] validation, double[] prediction) {
        double sumObs = 0.0;
        double sumDif = 0.0;
        for (int i = 0; i < prediction.length; ++i) {
            sumDif += prediction[i] - validation[i];
            sumObs += validation[i];
        }
        return sumDif / sumObs * 100.0;
    }
}

