/*
 * Decompiled with CFR 0.152.
 */
package optas.efficiencies;

import optas.efficiencies.EfficiencyCalculator;

public class CorrelationError
extends EfficiencyCalculator {
    double pow = 2.0;

    public CorrelationError() {
    }

    public CorrelationError(double pow) {
        this.pow = pow;
    }

    @Override
    public double calc(double[] m, double[] s) {
        double meanx = 0.0;
        double meany = 0.0;
        for (int i = 0; i < m.length; ++i) {
            meanx += m[i];
            meany += s[i];
        }
        meanx /= (double)m.length;
        meany /= (double)m.length;
        double sumx = 0.0;
        double sumy = 0.0;
        double prod = 0.0;
        for (int i = 0; i < m.length; ++i) {
            sumx += Math.pow(m[i] - meanx, 2.0);
            sumy += Math.pow(s[i] - meany, 2.0);
            prod += (m[i] - meanx) * (s[i] - meany);
        }
        double r2 = Math.pow(prod / Math.sqrt(sumx * sumy), 2.0);
        return r2;
    }

    @Override
    public double calcNormative(double[] t1, double[] t2) {
        return 1.0 - Math.abs(this.calc(t1, t2));
    }
}

