/*
 * Decompiled with CFR 0.152.
 */
package optas.datamining.kernels;

import optas.datamining.kernels.Kernel;

public class SimplePeriodic
extends Kernel {
    public SimplePeriodic(int inputDim) {
        this.inputDim = inputDim;
        this.parameterCount = 3;
        this.KernelParameterCount = 3;
    }

    @Override
    public String[] getParameterNames() {
        super.getParameterNames();
        this.KernelParameterNames[0] = "l";
        this.KernelParameterNames[1] = "period";
        this.KernelParameterNames[2] = "sigma";
        return this.KernelParameterNames;
    }

    public double SqrDistance2(double[] x, double[] y) {
        double sum = 0.0;
        for (int i = 0; i < x.length; ++i) {
            double tmp = x[i] - y[i];
            sum += tmp * tmp;
        }
        return sum;
    }

    @Override
    public double kernel(double[] x, double[] y, int index1, int index2) {
        double r = this.SqrDistance2(x, y) / 2.0 * this.theta[0];
        double sin = Math.sin(Math.PI * Math.sqrt(this.SqrDistance2(x, y)));
        double noise = 0.0;
        if (index1 == index2) {
            noise = this.theta[2] * this.theta[2];
        }
        return Math.exp(-r - 2.0 * sin * sin / this.theta[1]) + noise;
    }

    @Override
    public double dkernel(double[] x, double[] y, int d) {
        return 0.0;
    }
}

