/*
 * Decompiled with CFR 0.152.
 */
package optas.data;

import jams.JAMS;
import jams.data.Attribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashSet;
import java.util.TreeMap;
import optas.data.TimeFilter;
import optas.data.TimeSerie;
import optas.hydro.calculations.BaseFlow;
import optas.hydro.calculations.HydrographEvent;

public class TimeFilterFactory {
    public static TimeFilter getYearlyFilter(int[] year, boolean hydrologicYear) {
        return new YearlyTimeFilter(year, hydrologicYear);
    }

    public static TimeFilter getMonthlyFilter(int[] months) {
        return new MonthlyTimeFilter(months);
    }

    public static TimeFilter getRangeFilter(Attribute.TimeInterval range) {
        return new RangeTimeFilter(range);
    }

    public static TimeFilter getYearlyRangeTimeFilter(int dayStart, int dayEnd) {
        return new YearlyRangeTimeFilter(dayStart, dayEnd);
    }

    public static EventFilter getEventFilter(TimeSerie m, EventFilter.EventType type, int windowSize) {
        return new EventFilter(m, type, windowSize);
    }

    public static TimeFilter getBaseFlowTimeFilter(TimeSerie m, BaseFlowTimeFilter.Method method, double threshold) {
        return new BaseFlowTimeFilter(m, method, threshold);
    }

    public static TimeFilter getCombinedTimeFilter(TimeFilter[] filter) {
        return new CombinedTimeFilter(filter);
    }

    public static TimeFilter getSelectiveTimeFilter(Date[] dates) {
        return new SelectiveTimeFilter(dates);
    }

    public static class BaseFlowTimeFilter
    extends TimeFilter {
        TimeSerie m;
        Method method;
        double threshold;
        TreeMap<Date, Boolean> map = new TreeMap();

        private BaseFlowTimeFilter(TimeSerie m, Method method, double threshold) {
            this.m = m;
            this.method = method;
            switch (method) {
                case Fixed: {
                    for (int i = 0; i < m.getTimesteps(); ++i) {
                        Date d = m.getTime(i);
                        if (m.getValue(i) <= threshold) {
                            this.map.put(d, Boolean.TRUE);
                            continue;
                        }
                        this.map.put(d, Boolean.FALSE);
                    }
                    break;
                }
                case HYSEPLocalMinimum: {
                    double[] result = BaseFlow.groundwaterWindowMethod(m);
                    for (int i = 0; i < m.getTimesteps(); ++i) {
                        Date d = m.getTime(i);
                        if (Math.abs(m.getValue(i) - result[i]) <= threshold) {
                            this.map.put(d, Boolean.TRUE);
                            continue;
                        }
                        this.map.put(d, Boolean.FALSE);
                    }
                    break;
                }
            }
        }

        @Override
        public boolean isFiltered(Date date) {
            return this.map.floorEntry(date).getValue() == false;
        }

        public TimeSerie getTimeSerie() {
            return this.m;
        }

        public Method getMethod() {
            return this.method;
        }

        public double getThreshold() {
            return this.threshold;
        }

        public String toString() {
            return JAMS.i18n((String)"Baseflowfilter_of") + " " + this.m.name + "(" + (Object)((Object)this.method) + "t=" + this.threshold + ")";
        }

        public static enum Method {
            Fixed,
            HYSEPLocalMinimum;

        }
    }

    public static class EventFilter
    extends TimeFilter {
        public static int DEFAULT_WINDOWSIZE = 10;
        TimeSerie m;
        int windowSize = DEFAULT_WINDOWSIZE;
        EventType type;
        TreeMap<Date, Boolean> map = new TreeMap();
        double qualityThreshold = 0.0;
        ArrayList<HydrographEvent> list = null;

        private EventFilter(TimeSerie m, EventType type, int windowSize) {
            this.m = m;
            this.type = type;
            this.list = HydrographEvent.findEvents(m, windowSize);
            this.updateFilter();
            this.windowSize = windowSize;
        }

        private void updateFilter() {
            if (this.list == null) {
                return;
            }
            for (int i = 0; i < this.m.getTimesteps(); ++i) {
                Date d = this.m.getTime(i);
                this.map.put(d, Boolean.TRUE);
            }
            for (HydrographEvent evt : this.list) {
                Date d;
                if (evt.getQuality() < this.qualityThreshold) continue;
                if (this.type == EventType.RaisingEdge) {
                    for (int i = evt.getRaisingEdge().startIndex; i < evt.getRaisingEdge().endIndex; ++i) {
                        d = this.m.getTime(i);
                        this.map.put(d, Boolean.FALSE);
                    }
                    continue;
                }
                if (this.type == EventType.Recession) {
                    for (int i = evt.getFallingEdge().startIndex; i < evt.getFallingEdge().endIndex; ++i) {
                        d = this.m.getTime(i);
                        this.map.put(d, Boolean.FALSE);
                    }
                    continue;
                }
                if (this.type != EventType.Peak) continue;
                Date d2 = this.m.getTime(evt.getPeak().index);
                this.map.put(d2, Boolean.FALSE);
            }
        }

        public Date getFirstDate() {
            return this.map.firstKey();
        }

        public Date getLastDate() {
            return this.map.lastKey();
        }

        @Override
        public boolean isFiltered(Date date) {
            return this.map.floorEntry(date).getValue();
        }

        public EventType getFilteredEventType() {
            return this.type;
        }

        public TimeSerie getTimeSerie() {
            return this.m;
        }

        public int getWindowSize() {
            return this.windowSize;
        }

        public double getQualityThreshold() {
            return this.qualityThreshold;
        }

        public void setQualityThreshold(double qualityThreshold) {
            this.qualityThreshold = qualityThreshold;
            this.updateFilter();
        }

        public double getMinQuality() {
            double minQuality = Double.MAX_VALUE;
            double maxQuality = Double.MIN_VALUE;
            for (HydrographEvent evt : this.list) {
                minQuality = Math.min(minQuality, evt.getQuality());
                maxQuality = Math.max(maxQuality, evt.getQuality());
            }
            return minQuality;
        }

        public double getMaxQuality() {
            double maxQuality = Double.MIN_VALUE;
            for (HydrographEvent evt : this.list) {
                maxQuality = Math.max(maxQuality, evt.getQuality());
            }
            return maxQuality;
        }

        public String toString() {
            return JAMS.i18n((String)"Hydrograph_event_filter_with_window_size:") + " " + this.windowSize + " " + JAMS.i18n((String)"filtered_for:") + " " + (Object)((Object)this.type);
        }

        public static enum EventType {
            Peak,
            Recession,
            RaisingEdge;

        }
    }

    public static class CombinedTimeFilter
    extends TimeFilter {
        TimeFilter[] filter = null;

        CombinedTimeFilter(TimeFilter[] filter) {
            this.filter = filter;
        }

        @Override
        public boolean isFiltered(Date date) {
            boolean isFiltered = true;
            for (TimeFilter f : this.filter) {
                if (!f.isEnabled) continue;
                boolean value = f.isFiltered(date);
                if (f.isInverted) {
                    boolean bl = value = !value;
                }
                if (f.isAdditive) {
                    isFiltered |= value;
                    continue;
                }
                isFiltered &= value;
            }
            return isFiltered;
        }

        public String toString() {
            String s = JAMS.i18n((String)"combined_filter") + "\n";
            for (TimeFilter f : this.filter) {
                s = s + f + "\n";
            }
            return s;
        }
    }

    public static class YearlyRangeTimeFilter
    extends TimeFilter {
        int startDay;
        int endDay;

        private YearlyRangeTimeFilter(int startDay, int endDay) {
            this.startDay = startDay;
            this.endDay = endDay;
        }

        @Override
        public boolean isFiltered(Date date) {
            int day = date.getDay();
            return day >= this.startDay && day <= this.endDay;
        }

        public String toString() {
            String s = JAMS.i18n((String)"from_day") + " " + this.startDay + " " + JAMS.i18n((String)"to") + " " + this.endDay;
            return s;
        }
    }

    public static class SelectiveTimeFilter
    extends TimeFilter {
        HashSet<Long> set = new HashSet();

        private SelectiveTimeFilter(Date[] nonFilteredDates) {
            for (Date d : nonFilteredDates) {
                this.set.add(d.getTime());
            }
        }

        @Override
        public boolean isFiltered(Date date) {
            return !this.set.contains(date.getTime());
        }
    }

    public static class RangeTimeFilter
    extends TimeFilter {
        Attribute.TimeInterval range;

        private RangeTimeFilter(Attribute.TimeInterval range) {
            this.range = range;
        }

        public Attribute.TimeInterval getRange() {
            return this.range;
        }

        @Override
        public boolean isFiltered(Date date) {
            return date.before(this.range.getStart().getTime()) || date.after(this.range.getEnd().getTime());
        }

        public String toString() {
            String s = JAMS.i18n((String)"from") + " " + this.range.getStart().toString() + " " + JAMS.i18n((String)"to") + " " + this.range.getEnd().toString();
            return s;
        }
    }

    public static class MonthlyTimeFilter
    extends TimeFilter {
        boolean[] months = new boolean[12];

        private MonthlyTimeFilter(int[] months) {
            for (int i = 0; i < 12; ++i) {
                this.months[i] = false;
            }
            for (int m : months) {
                this.months[m] = true;
            }
        }

        @Override
        public boolean isFiltered(Date date) {
            return !this.months[date.getMonth()];
        }

        public int[] getMonths() {
            int c = 0;
            for (int i = 0; i < 12; ++i) {
                if (!this.months[i]) continue;
                ++c;
            }
            int[] index = new int[c];
            c = 0;
            for (int i = 0; i < 12; ++i) {
                if (!this.months[i]) continue;
                index[c++] = i;
            }
            return index;
        }

        public String toString() {
            return JAMS.i18n((String)"Months") + ": " + Arrays.toString(this.getMonths());
        }
    }

    public static class YearlyTimeFilter
    extends TimeFilter {
        boolean[] years = new boolean[3000];
        boolean hydrologicYear;

        private YearlyTimeFilter(int[] years, boolean hydrologicYear) {
            for (int y : years) {
                this.years[y] = true;
            }
            this.hydrologicYear = hydrologicYear;
        }

        public int[] getYears() {
            int counter = 0;
            for (int i = 0; i < this.years.length; ++i) {
                if (!this.years[i]) continue;
                ++counter;
            }
            int[] list = new int[counter];
            counter = 0;
            for (int i = 0; i < this.years.length; ++i) {
                if (!this.years[i]) continue;
                list[counter++] = i;
            }
            return list;
        }

        public boolean isHydrologicYear() {
            return this.hydrologicYear;
        }

        @Override
        public boolean isFiltered(Date date) {
            GregorianCalendar calendar = new GregorianCalendar();
            calendar.setTime(date);
            int year = calendar.get(1);
            if (this.hydrologicYear && calendar.get(2) >= 10) {
                ++year;
            }
            return !this.years[year];
        }

        public String toString() {
            return JAMS.i18n((String)"Years") + ": " + Arrays.toString(this.getYears());
        }
    }
}

