/*
 * Decompiled with CFR 0.152.
 */
package optas.SA;

import Jama.Matrix;
import java.util.ArrayList;
import optas.SA.SensitivityAnalyzer;
import optas.optimizer.management.SampleFactory;

public class LinearRegression
extends SensitivityAnalyzer {
    @Override
    public void calculate() {
        int k;
        super.calculate();
        Matrix M = new Matrix(this.sampleSize, this.n + 1);
        Matrix Y = new Matrix(this.sampleSize, 1);
        ArrayList<SampleFactory.Sample> x = this.getRandomSampling();
        for (int i = 0; i < this.sampleSize; ++i) {
            SampleFactory.Sample s0 = x.get(i);
            for (int j = 0; j < this.n; ++j) {
                M.set(i, j, s0.x[j]);
            }
            M.set(i, this.n, 1.0);
            Y.set(i, 0, s0.F()[0]);
        }
        Matrix X = M.transpose().times(M).solve(M.transpose().times(Y));
        double sum = 0.0;
        for (k = 0; k < this.n; ++k) {
            sum += Math.abs(X.get(k, 0));
            this.sensitivityIndex[k] = Math.abs(X.get(k, 0));
        }
        k = 0;
        while (k < this.n) {
            int n = k++;
            this.sensitivityIndex[n] = this.sensitivityIndex[n] / sum;
        }
    }
}

