/*
 * Decompiled with CFR 0.152.
 */
package org.unijena.j2k.regionalisation;

import jams.JAMS;
import jams.data.ArrayPool;
import jams.data.Attribute;
import jams.model.JAMSComponent;
import jams.model.JAMSComponentDescription;
import jams.model.JAMSVarDescription;
import jams.model.VersionComments;
import java.io.IOException;

@JAMSComponentDescription(title="Regionalisation", author="Peter Krause", version="1.2_0", description="Calculate local (regionalised) input values based on the inverse distance weighting procedure.")
@VersionComments(entries={@VersionComments.Entry(version="1.0_0", comment="Initial version"), @VersionComments.Entry(version="1.1_0", comment="Added option to output actual weights for individual stations in order to find out which stations were used in each time step and for each modelling unit."), @VersionComments.Entry(version="1.2_0", comment="Changed weight output such that all weights are provided. Changed datatype from Double[] to DoubleArray.")})
public class Regionalisation_OLD
extends JAMSComponent {
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="Array of data values for current time step")
    public Attribute.DoubleArray dataArray;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="Regression coefficients")
    public Attribute.DoubleArray regCoeff;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="Array of station elevations")
    public Attribute.DoubleArray statElevation;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="Array of station's weights")
    public Attribute.DoubleArray statWeights;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="Array position of weights")
    public Attribute.IntegerArray statOrder;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.WRITE, description="regionalised data value")
    public Attribute.Double dataValue;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="Attribute name elevation")
    public Attribute.Double entityElevation;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="Number of IDW stations")
    public Attribute.Integer nidw;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="Apply elevation correction to measured data")
    public Attribute.Boolean elevationCorrection;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="Minimum r\u00b2 value for elevation correction application")
    public Attribute.Double rsqThreshold;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="Absolute possible minimum value for data set", defaultValue="-Infinity")
    public Attribute.Double fixedMinimum;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="Absolute possible maximum value for data set", defaultValue="Infinity")
    public Attribute.Double fixedMaximum;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="Ignore invalid datasets?", defaultValue="false")
    public Attribute.Boolean ignoreInvalid;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.WRITE, description="Weights of individual stations (first element equals first station in list)")
    public Attribute.Double[] actualWeights;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.WRITE, description="Weighted average elevation of source stations")
    public Attribute.Double averageSourceElevation;
    boolean invalidDatasetReported = false;
    ArrayPool<double[]> memPool = new ArrayPool(Double.TYPE);
    ArrayPool<int[]> imemPool = new ArrayPool(Integer.TYPE);

    public void run() throws IOException {
        int i;
        double[] regCoeff = this.regCoeff.getValue();
        double gradient = regCoeff[1];
        double rsq = regCoeff[2];
        double[] sourceElevations = this.statElevation.getValue();
        double[] sourceData = this.dataArray.getValue();
        double[] sourceWeights = this.statWeights.getValue();
        double targetElevation = this.entityElevation.getValue();
        int[] wA = this.statOrder.getValue();
        double value = 0.0;
        double deltaElev = 0.0;
        int nIDW = this.nidw.getValue();
        double[] data = (double[])this.memPool.alloc(nIDW);
        double[] weights = (double[])this.memPool.alloc(nIDW);
        double[] elev = (double[])this.memPool.alloc(nIDW);
        int[] station = (int[])this.imemPool.alloc(nIDW);
        if (this.actualWeights != null) {
            for (Attribute.Double w : this.actualWeights) {
                w.setValue(0.0);
            }
        }
        int counter = 0;
        int element = 0;
        boolean valid = false;
        while (counter < nIDW) {
            int t = wA[element];
            if (sourceData[t] == JAMS.getMissingDataValue()) {
                if (++element < wA.length) continue;
                break;
            }
            valid = true;
            station[counter] = t;
            data[counter] = sourceData[t];
            weights[counter] = sourceWeights[t];
            elev[counter] = sourceElevations[t];
            ++counter;
            if (++element < wA.length) continue;
            break;
        }
        double weightsum = 0.0;
        for (i = 0; i < counter; ++i) {
            weightsum += weights[i];
        }
        for (i = 0; i < counter; ++i) {
            weights[i] = weights[i] / weightsum;
        }
        if (valid) {
            for (i = 0; i < counter; ++i) {
                if (this.actualWeights != null) {
                    this.actualWeights[station[i]].setValue(weights[i]);
                }
                if (this.elevationCorrection.getValue() && rsq >= this.rsqThreshold.getValue()) {
                    deltaElev = targetElevation - elev[i];
                    double tVal = (deltaElev * gradient + data[i]) * weights[i];
                    value += tVal;
                    continue;
                }
                value += data[i] * weights[i];
            }
            value = Math.max(value, this.fixedMinimum.getValue());
            value = Math.min(value, this.fixedMaximum.getValue());
            if (this.averageSourceElevation != null) {
                double avgElev = 0.0;
                for (int i2 = 0; i2 < counter; ++i2) {
                    avgElev += elev[i2] * weights[i2];
                }
                this.averageSourceElevation.setValue(avgElev);
            }
        } else {
            if (!this.invalidDatasetReported) {
                if (!this.ignoreInvalid.getValue()) {
                    this.getModel().getRuntime().sendHalt("Invalid dataset found while regionalizing data in component " + this.getInstanceName() + ".\nThis might occur if all of the provided values are missing data values.");
                }
                this.invalidDatasetReported = true;
            }
            value = JAMS.getMissingDataValue();
        }
        this.dataValue.setValue(value);
        data = (double[])this.memPool.free((Object)data);
        weights = (double[])this.memPool.free((Object)weights);
        elev = (double[])this.memPool.free((Object)elev);
    }
}

