/*
 * Decompiled with CFR 0.152.
 */
package org.unijena.j2k.regionalisation;

import jams.JAMS;
import jams.data.ArrayPool;
import jams.data.Attribute;
import jams.model.JAMSComponent;
import jams.model.JAMSVarDescription;
import jams.workspace.DataSetDefinition;
import jams.workspace.stores.InputDataStore;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import org.unijena.j2k.statistics.IDW;

public class Regionalisation_
extends JAMSComponent {
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="Array of data values for current time step")
    public Attribute.DoubleArray dataArray;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="Regression coefficients")
    public Attribute.DoubleArray regCoeff;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="Array of station elevations")
    public Attribute.DoubleArray statElevation;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READWRITE, description="Array of station's weights")
    public Attribute.DoubleArray statWeights;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READWRITE, description="Array position of weights")
    public Attribute.IntegerArray statOrder;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.WRITE, description="regionalised data value")
    public Attribute.Double dataValue;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="Attribute name elevation")
    public Attribute.Double entityElevation;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="Number of IDW stations")
    public Attribute.Integer nidw;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="Apply elevation correction to measured data")
    public Attribute.Boolean elevationCorrection;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="Minimum r\u00b2 value for elevation correction application")
    public Attribute.Double rsqThreshold;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="Absolute possible minimum value for data set")
    public Attribute.Double fixedMinimum;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="entity x-coordinate")
    public Attribute.Double entityX;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="entity y-coordinate")
    public Attribute.Double entityY;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="Power of IDW function")
    public Attribute.Double pidw;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="Weights for Thiessen polygons", defaultValue="false")
    public Attribute.Boolean equalWeights;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="Calculation with geographical coordinates lat, long", defaultValue="false")
    public Attribute.Boolean latLong;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="ID of the datastore to read station coordinates from")
    public Attribute.String dataStoreID;
    private double[] statX;
    private double[] statY;
    InputDataStore store = null;
    IDW idw = new IDW();
    boolean invalidDatasetReported = false;
    ArrayPool<double[]> memPool = new ArrayPool(Double.TYPE);

    public void init() {
        boolean isLatLon;
        if (this.dataStoreID != null) {
            this.store = this.getModel().getWorkspace().getInputDataStore(this.dataStoreID.getValue());
        }
        if (this.store == null) {
            this.getModel().getRuntime().sendHalt("Error accessing datastore \"" + this.dataStoreID + "\" from " + this.getInstanceName() + ": Datastore could not be found!");
            return;
        }
        DataSetDefinition dsDef = this.store.getDataSetDefinition();
        ArrayList xList = dsDef.getAttributeValues("X");
        ArrayList yList = dsDef.getAttributeValues("Y");
        if (xList == null || yList == null) {
            this.getModel().getRuntime().sendHalt("Error accessing datastore \"" + this.dataStoreID + "\" from " + this.getInstanceName() + ": x or y coordinates are not set!");
        }
        if (xList.size() != yList.size()) {
            this.getModel().getRuntime().sendHalt("Error accessing datastore \"" + this.dataStoreID + "\" from " + this.getInstanceName() + ": Number of x and y coordinates differ!");
            return;
        }
        this.statX = this.listToDoubleArray(xList);
        this.statY = this.listToDoubleArray(yList);
        boolean bl = isLatLon = this.latLong != null && this.latLong.getValue();
        if (isLatLon) {
            this.idw.init(this.statX, this.statY, null, (int)this.pidw.getValue(), IDW.Projection.LATLON);
        } else {
            this.idw.init(this.statX, this.statY, null, (int)this.pidw.getValue(), IDW.Projection.ANY);
        }
    }

    public void initAll() {
        double[] weights = this.statWeights.getValue();
        int[] wA = this.statOrder.getValue();
        int n = this.statX.length;
        if (weights == null || weights.length != n) {
            weights = new double[n];
        }
        if (wA == null || wA.length != n) {
            wA = new int[n];
        }
        if (this.equalWeights == null || !this.equalWeights.getValue()) {
            this.idw.getIDW(this.entityX.getValue(), this.entityY.getValue(), null, 1);
            System.arraycopy(this.idw.getWeights(), 0, weights, 0, n);
            System.arraycopy(this.idw.getWeightOrder(), 0, wA, 0, n);
        } else if (this.equalWeights.getValue()) {
            for (int i = 0; i < n; ++i) {
                weights[i] = 1.0 / (double)n;
                wA[i] = i;
            }
        }
        this.statWeights.setValue(weights);
        this.statOrder.setValue(wA);
    }

    public void run() throws IOException {
        int i;
        double[] regCoeff = this.regCoeff.getValue();
        double gradient = regCoeff[1];
        double rsq = regCoeff[2];
        double[] sourceElevations = this.statElevation.getValue();
        double[] sourceData = this.dataArray.getValue();
        double[] sourceWeights = this.statWeights.getValue();
        double targetElevation = this.entityElevation.getValue();
        int[] wA = this.statOrder.getValue();
        double value = 0.0;
        double deltaElev = 0.0;
        int nIDW = this.nidw.getValue();
        double[] data = (double[])this.memPool.alloc(nIDW);
        double[] weights = (double[])this.memPool.alloc(nIDW);
        double[] elev = (double[])this.memPool.alloc(nIDW);
        int counter = 0;
        int element = 0;
        boolean valid = false;
        while (counter < nIDW) {
            int t = wA[element];
            if (sourceData[t] == JAMS.getMissingDataValue()) {
                if (++element < wA.length) continue;
                break;
            }
            valid = true;
            data[counter] = sourceData[t];
            weights[counter] = sourceWeights[t];
            elev[counter] = sourceElevations[t];
            ++counter;
            if (++element < wA.length) continue;
            break;
        }
        double weightsum = 0.0;
        for (i = 0; i < counter; ++i) {
            weightsum += weights[i];
        }
        for (i = 0; i < counter; ++i) {
            weights[i] = weights[i] / weightsum;
        }
        if (valid) {
            for (i = 0; i < counter; ++i) {
                if (rsq >= this.rsqThreshold.getValue() && this.elevationCorrection.getValue()) {
                    deltaElev = targetElevation - elev[i];
                    double tVal = (deltaElev * gradient + data[i]) * weights[i];
                    if (tVal < this.fixedMinimum.getValue()) {
                        tVal = this.fixedMinimum.getValue();
                    }
                    value += tVal;
                    continue;
                }
                value += data[i] * weights[i];
            }
        } else {
            if (!this.invalidDatasetReported) {
                this.getModel().getRuntime().sendHalt("Invalid dataset found while regionalizing data in component " + this.getInstanceName() + ".\nThis might occur if all of the provided values are missing data values.");
                this.invalidDatasetReported = true;
            }
            value = JAMS.getMissingDataValue();
        }
        this.dataValue.setValue(value);
        data = (double[])this.memPool.free((Object)data);
        weights = (double[])this.memPool.free((Object)weights);
        elev = (double[])this.memPool.free((Object)elev);
    }

    public void cleanup() {
        Arrays.fill(this.statWeights.getValue(), 0.0);
        if (this.store != null) {
            try {
                this.store.close();
            }
            catch (IOException ioe) {
                ioe.printStackTrace();
            }
        }
    }

    private double[] listToDoubleArray(ArrayList<Object> list) {
        double[] result = new double[list.size()];
        int i = 0;
        for (Object o : list) {
            result[i] = (Double)o;
            ++i;
        }
        return result;
    }
}

