/*
 * Decompiled with CFR 0.152.
 */
package org.unijena.j2k.inputData;

import jams.JAMS;
import jams.data.Attribute;
import jams.io.GenericDataWriter;
import jams.model.JAMSComponent;
import jams.model.JAMSComponentDescription;
import jams.model.JAMSVarDescription;
import jams.runtime.RuntimeException;

@JAMSComponentDescription(title="RainCorrectionRichterMonthly", author="Peter Krause", description="Corrects measured precipitation values with correctionfactors according to Richter 1995, table X, page Y")
public class RainCorrectionRichterMonthly
extends JAMSComponent {
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="time")
    public Attribute.Calendar time;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="the uncorrected precip values")
    public Attribute.DoubleArray inPrecip;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.WRITE, description="the corrected precip values")
    public Attribute.DoubleArray corrPrecip;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="the geographical zone according to Richter 1995")
    public Attribute.Integer precipZone;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="precipitation adjustment factor")
    public Attribute.Double precipAdj;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="Output file name")
    public Attribute.String outFileName;
    double[] richter3_b = new double[]{0.233, 0.245, 0.203, 0.151, 0.111, 0.098, 0.1, 0.095, 0.115, 0.127, 0.168, 0.198};
    double[] richter3_c = new double[]{0.173, 0.179, 0.155, 0.127, 0.101, 0.088, 0.091, 0.085, 0.102, 0.11, 0.133, 0.15};
    double[] richter5_b = new double[]{0.233, 0.245, 0.203, 0.151, 0.111, 0.098, 0.1, 0.095, 0.115, 0.127, 0.168, 0.198};
    double[] richter5_c = new double[]{0.173, 0.179, 0.155, 0.127, 0.101, 0.088, 0.091, 0.085, 0.102, 0.11, 0.133, 0.15};
    double adj = 1.0;
    private GenericDataWriter writer;
    private boolean headerWritten;

    public void init() {
        this.adj = this.precipAdj.getValue();
        if (this.adj == 0.0) {
            this.adj = 1.0;
        }
        if (this.outFileName != null) {
            this.writer = new GenericDataWriter(this.outFileName.getValue());
        }
    }

    public void run() {
        int i;
        double[] corrFactor = null;
        if (this.outFileName != null) {
            int nstat = this.inPrecip.getValue().length;
            if (!this.headerWritten) {
                this.writer.addColumn("date/time");
                for (int i2 = 0; i2 < nstat; ++i2) {
                    this.writer.addColumn("stat" + (i2 + 1));
                }
                this.writer.writeHeader();
                this.headerWritten = true;
            }
        }
        if (this.precipZone.getValue() == 3) {
            corrFactor = this.richter3_c;
        }
        double[] precip = this.inPrecip.getValue();
        double[] rcorr = new double[precip.length];
        int month = this.time.get(2);
        for (i = 0; i < rcorr.length; ++i) {
            rcorr[i] = precip[i] == JAMS.getMissingDataValue() ? JAMS.getMissingDataValue() : precip[i] + precip[i] * (corrFactor[month] * this.adj);
        }
        this.corrPrecip.setValue(rcorr);
        if (this.outFileName != null) {
            this.writer.addData((Object)this.time);
            for (i = 0; i < rcorr.length; ++i) {
                this.writer.addData((Object)rcorr[i]);
            }
            try {
                this.writer.writeData();
            }
            catch (RuntimeException jre) {
                this.getModel().getRuntime().handle((Throwable)jre);
            }
        }
    }

    public void cleanup() {
        if (this.outFileName != null) {
            this.writer.write("#eof");
            this.writer.close();
        }
    }
}

