/*
 * Decompiled with CFR 0.152.
 */
package org.unijena.j2k.inputData;

import jams.JAMS;
import jams.data.Attribute;
import jams.model.JAMSComponent;
import jams.model.JAMSComponentDescription;
import jams.model.JAMSVarDescription;

@JAMSComponentDescription(title="BaseflowSeparationEckhardt", author="Peter Krause", description="this program estimates groundwater contributions from streamflow records.Program for baseflow separation. References:Eckhardt, K., 2005. How to construct recursive digitalfilters for baseflow separation. Hydrological Processes 19,507-515.Eckhardt, K., 2008. A comparison of baseflow indices, whichwere calculated with seven different baseflow separationmethods. Journal of Hydrology 352, 168-173.This JAVA implementation is based on the original FORTRAN source code providedby Klaus Eckhard.")
public class BaseflowSeparationEckhardt
extends JAMSComponent {
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="the measured streamflow values")
    public Attribute.DoubleArray strflow;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.WRITE, description="the surface runoff values")
    public Attribute.DoubleArray surfq;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.WRITE, description="the baseflow values")
    public Attribute.DoubleArray baseq;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.WRITE, description="the baseflow index for the entire time series")
    public Attribute.Double bfi;

    public void init() {
    }

    public void run() {
        double[] a = this.strflow.getValue();
        double[] b = new double[a.length + 1];
        System.arraycopy(a, 0, b, 0, a.length);
        b[b.length - 1] = 0.0;
        double[] strflw = b;
        int nrecs = strflw.length;
        double bfimax = 0.0;
        double[] surfq = new double[nrecs];
        double[] baseq = new double[nrecs];
        boolean[] eval = new boolean[nrecs];
        int ndry = 0;
        for (int i = 0; i < nrecs; ++i) {
            eval[i] = false;
            if (!(strflw[i] >= 0.0) || !(strflw[i] < 0.001)) continue;
            ++ndry;
        }
        double rel = (double)ndry / (double)nrecs;
        bfimax = rel < 0.1 ? 0.8 : 0.5;
        for (int i = 3; i < nrecs; ++i) {
            if (!(strflw[i - 3] > 0.0) || !(strflw[i - 2] > 0.0) || !(strflw[i - 1] > 0.0) || !(strflw[i] > 0.0) || !(strflw[i + 1] > 0.0) || !(strflw[i + 2] > 0.0) || !(strflw[i - 3] > strflw[i - 2]) || !(strflw[i - 2] > strflw[i - 1]) || !(strflw[i - 1] > strflw[i]) || !(strflw[i] > strflw[i + 1]) || !(strflw[i + 1] > strflw[i + 2])) continue;
            eval[i] = true;
        }
        double recConst = this.calcRecConstant(strflw, eval);
        double bsum = 0.0;
        double strsum = 0.0;
        baseq[0] = 0.9 * bfimax * strflw[0];
        for (int i = 1; i < nrecs; ++i) {
            if (strflw[i] == JAMS.getMissingDataValue()) continue;
            strsum += strflw[i];
            if (strflw[i] > 0.0) {
                if (baseq[i - 1] <= 0.0) {
                    baseq[i] = 0.9 * bfimax * strflw[i];
                } else {
                    baseq[i] = ((1.0 - bfimax) * recConst * baseq[i - 1] + (1.0 - recConst) * bfimax * strflw[i]) / (1.0 - recConst * bfimax);
                    if (baseq[i] > strflw[i]) {
                        baseq[i] = strflw[i];
                    }
                    bsum += baseq[i];
                }
            }
            surfq[i] = strflw[i] - baseq[i];
        }
        double bfi = bsum / strsum;
        System.out.println("BFI of time series: " + bfi);
        this.surfq.setValue(surfq);
        this.baseq.setValue(baseq);
        this.bfi.setValue(bfi);
    }

    public void cleanup() {
    }

    private double calcRecConstant(double[] strflw, boolean[] eval) {
        double recConst = 0.0;
        boolean stop = false;
        for (int i = 0; i < 1000; ++i) {
            recConst = 1.0 - (double)i * 0.001;
            for (int j = 2; j < strflw.length - 1; ++j) {
                double test = 1.02 * recConst * strflw[i];
                if (!eval[i] || !(strflw[i + 1] > test)) continue;
                stop = true;
                break;
            }
            if (stop) break;
        }
        return recConst;
    }
}

