/*
 * Decompiled with CFR 0.152.
 */
package org.unijena.j2k.efficiencies;

import jams.JAMS;
import jams.data.Attribute;
import jams.model.JAMSComponent;
import jams.model.JAMSComponentDescription;
import jams.model.JAMSVarDescription;
import jams.model.VersionComments;
import java.util.Locale;
import java.util.Vector;
import org.unijena.j2k.efficiencies.DoubleSumAnalysis;
import org.unijena.j2k.efficiencies.IndexOfAgreement;
import org.unijena.j2k.efficiencies.NashSutcliffe;
import org.unijena.j2k.efficiencies.PredictionErrors;
import org.unijena.j2k.efficiencies.VolumeError;
import org.unijena.j2k.statistics.Regression;

@JAMSComponentDescription(title="StandardEfficiencyCalculator", author="Peter Krause", description="Calculates various efficiency measures", version="1.0_1", date="2018-11-01")
@VersionComments(entries={@VersionComments.Entry(version="1.0_0", date="2010-10-29", comment="Initial version"), @VersionComments.Entry(version="1.0_1", date="2018-11-01", comment="Fixed bug with in calculation of log-based efficiencies")})
public class StandardEfficiencyCalculator
extends JAMSComponent {
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="the current modelling time step")
    public Attribute.Calendar time;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="The model time interval")
    public Attribute.TimeInterval modelTimeInterval;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="The efficiency time interval, a subset of modelTimeInterval")
    public Attribute.TimeInterval effTimeInterval;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="comma separated list of months (1-12) which should be evaluated, can be left out if not needed")
    public Attribute.IntegerArray effMonthList;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="a comma separated list of integer values indicating which efficiency criteria should be computed")
    public Attribute.IntegerArray effMethod;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="Prediction value")
    public Attribute.Double prediction;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="Validation value")
    public Attribute.Double validation;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.WRITE, description="Nash-Sutcliffe-efficiency with power 1.0", unit="n/a", lowerBound=-Infinity, upperBound=1.0)
    public Attribute.Double e1;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.WRITE, description="Nash-Sutcliffe-efficiency with power 2.0", unit="n/a", lowerBound=Infinity, upperBound=1.0)
    public Attribute.Double e2;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.WRITE, description="Nash-Sutcliffe-efficiency from logarithmic values with power 1.0", unit="n/a", lowerBound=-Infinity, upperBound=1.0)
    public Attribute.Double le1;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.WRITE, description="Nash-Sutcliffe-efficiency  from logarithmic values with power 2.0", unit="n/a", lowerBound=-Infinity, upperBound=1.0)
    public Attribute.Double le2;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.WRITE, description="Willmot's index of agreement with power 1.0", unit="n/a", lowerBound=0.0, upperBound=1.0)
    public Attribute.Double ioa1;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.WRITE, description="Willmot's index of agreement with power 2.0", unit="n/a", lowerBound=0.0, upperBound=1.0)
    public Attribute.Double ioa2;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.WRITE, description="coefficient of determination r^2", unit="n/a", lowerBound=0.0, upperBound=1.0)
    public Attribute.Double rsq;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.WRITE, description="gradient of linear regression", unit="n/a", lowerBound=0.0, upperBound=Infinity)
    public Attribute.Double grad;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.WRITE, description="weighted rsq", unit="n/a", lowerBound=0.0, upperBound=1.0)
    public Attribute.Double wrsq;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.WRITE, description="gradient of double sum regression", unit="n/a", lowerBound=0.0, upperBound=Infinity)
    public Attribute.Double dsGrad;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.WRITE, description="absolute volume error", unit="same as values", lowerBound=0.0, upperBound=Infinity)
    public Attribute.Double absVolErr;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.WRITE, description="root mean square error", unit="same as values", lowerBound=0.0, upperBound=Infinity)
    public Attribute.Double rmse;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.WRITE, description="percent bias", unit="%", lowerBound=-Infinity, upperBound=Infinity)
    public Attribute.Double pbias;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.WRITE, description="absolute percent bias", unit="%", lowerBound=0.0, upperBound=Infinity)
    public Attribute.Double apbias;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.WRITE, description="full set of predicted values")
    public Attribute.DoubleArray predictionValues;
    private final int E1 = 1;
    private final int E2 = 2;
    private final int LOG_E1 = 3;
    private final int LOG_E2 = 4;
    private final int IOA_1 = 5;
    private final int IOA_2 = 6;
    private final int R2 = 7;
    private final int WR2 = 8;
    private final int DSGRAD = 9;
    private final int ABSVOLERROR = 10;
    private final int RMSE = 11;
    private final int PBIAS = 12;
    private final int APBIAS = 13;
    private double[] valData;
    private double[] preData;
    private int counter = 0;
    private int interValStart = 0;
    private int interValEnd = 0;
    private int effTsteps = 0;
    private boolean monthly = false;
    private int monthCount = 0;

    public void init() {
        this.counter = 0;
        this.monthCount = 0;
        Attribute.Calendar model_sd = this.modelTimeInterval.getStart().clone();
        Attribute.Calendar model_ed = this.modelTimeInterval.getEnd().clone();
        long sdMod = model_sd.getTimeInMillis();
        long model_tsteps = 0L;
        model_tsteps = this.modelTimeInterval.getNumberOfTimesteps();
        Attribute.Calendar eff_sd = this.effTimeInterval.getStart().clone();
        Attribute.Calendar eff_ed = this.effTimeInterval.getEnd().clone();
        int eff_tres = this.effTimeInterval.getTimeUnit();
        long sdEff = eff_sd.getTimeInMillis();
        if (eff_sd.before(model_sd)) {
            this.effTimeInterval.setStart(model_sd);
            this.getModel().getRuntime().println("effStartdate was set equal to model startdate", 1);
        }
        if (model_ed.before(eff_ed)) {
            this.effTimeInterval.setEnd(model_ed);
            this.getModel().getRuntime().println("effEnddate was set equal to model enddate", 1);
        }
        if (eff_ed.before(model_sd)) {
            this.effTimeInterval.setEnd(model_ed);
            this.getModel().getRuntime().println("effEnddate was set equal to model enddate", 1);
        }
        this.effTsteps = (int)this.effTimeInterval.getNumberOfTimesteps();
        this.getModel().getRuntime().println("effStartdate:\t" + eff_sd.toString(), 2);
        this.getModel().getRuntime().println("effEnddate:\t" + eff_ed.toString(), 2);
        this.valData = new double[(int)model_tsteps];
        this.preData = new double[(int)model_tsteps];
        this.counter = 0;
        if (eff_tres == 6) {
            this.interValStart = (int)((sdEff - sdMod) / 86400000L);
            this.interValEnd = this.interValStart + this.effTsteps;
        } else if (eff_tres == 11) {
            this.interValStart = (int)((sdEff - sdMod) / 3600000L);
            this.interValEnd = this.interValStart + this.effTsteps;
        } else if (eff_tres == 2) {
            Attribute.Calendar modStart = this.modelTimeInterval.getStart().clone();
            Attribute.Calendar effStart = this.effTimeInterval.getStart().clone();
            int startStep = 0;
            while (modStart.before(effStart)) {
                ++startStep;
                modStart.add(2, 1);
            }
            this.interValStart = startStep;
            this.interValEnd = this.interValStart + this.effTsteps;
        } else if (eff_tres == 1) {
            Attribute.Calendar modStart = this.modelTimeInterval.getStart().clone();
            Attribute.Calendar effStart = this.effTimeInterval.getStart().clone();
            int startStep = 0;
            while (modStart.before(effStart)) {
                ++startStep;
                modStart.add(1, 1);
            }
            this.interValStart = startStep;
            this.interValEnd = this.interValStart + this.effTsteps;
        }
        if (this.effMonthList != null && this.effMonthList.getValue().length > 0) {
            this.monthly = true;
        }
    }

    public void run() {
        if (this.monthly) {
            int month = this.time.get(2) + 1;
            for (int i = 0; i < this.effMonthList.getValue().length; ++i) {
                if (month != this.effMonthList.getValue()[i]) continue;
                this.valData[this.counter] = this.validation.getValue();
                this.preData[this.counter] = this.prediction.getValue();
                ++this.counter;
                ++this.monthCount;
            }
        } else {
            this.valData[this.counter] = this.validation.getValue();
            this.preData[this.counter] = this.prediction.getValue();
            ++this.counter;
        }
    }

    public void cleanup() {
        int i;
        this.getModel().getRuntime().println("", 1);
        this.getModel().getRuntime().println("********************************************************************", 1);
        this.getModel().getRuntime().println("Instance:                " + this.getInstanceName(), 1);
        this.getModel().getRuntime().println("Efficiencies for period: " + this.effTimeInterval.toString(), 1);
        this.getModel().getRuntime().println("********************************************************************", 1);
        Vector<Double> valVector = new Vector<Double>();
        Vector<Double> preVector = new Vector<Double>();
        this.predictionValues.setValue(this.preData);
        for (int i2 = this.interValStart; i2 < this.interValEnd; ++i2) {
            if (this.valData[i2] == JAMS.getMissingDataValue() || this.preData[i2] == JAMS.getMissingDataValue()) continue;
            valVector.add(this.valData[i2]);
            preVector.add(this.preData[i2]);
        }
        int dataCount = valVector.size();
        if (this.monthly) {
            dataCount = this.monthCount;
        }
        double[] valData_1 = new double[dataCount];
        double[] preData_1 = new double[dataCount];
        for (i = 0; i < dataCount; ++i) {
            valData_1[i] = (Double)valVector.get(i);
            preData_1[i] = (Double)preVector.get(i);
        }
        for (i = 0; i < this.effMethod.getValue().length; ++i) {
            if (this.effMethod.getValue()[i] == this.E1) {
                double e1 = NashSutcliffe.efficiency(preData_1, valData_1, 1.0);
                this.e1.setValue(e1);
                this.getModel().getRuntime().println(String.format(Locale.US, "e1:      %.5f", e1), 1);
                continue;
            }
            if (this.effMethod.getValue()[i] == this.E2) {
                double e2 = NashSutcliffe.efficiency(preData_1, valData_1, 2.0);
                this.e2.setValue(e2);
                this.getModel().getRuntime().println(String.format(Locale.US, "e2:      %.5f", e2), 1);
                continue;
            }
            if (this.effMethod.getValue()[i] == this.LOG_E1) {
                double le1 = NashSutcliffe.logEfficiency(preData_1, valData_1, 1.0);
                this.le1.setValue(le1);
                this.getModel().getRuntime().println(String.format(Locale.US, "log_e1:  %.5f", le1), 1);
                continue;
            }
            if (this.effMethod.getValue()[i] == this.LOG_E2) {
                double le2 = NashSutcliffe.logEfficiency(preData_1, valData_1, 2.0);
                this.le2.setValue(le2);
                this.getModel().getRuntime().println(String.format(Locale.US, "log_e2:  %.5f", le2), 1);
                continue;
            }
            if (this.effMethod.getValue()[i] == this.IOA_1) {
                double ioa1 = IndexOfAgreement.calc_IOA(preData_1, valData_1, 1.0, this.getModel());
                this.ioa1.setValue(ioa1);
                this.getModel().getRuntime().println(String.format(Locale.US, "ioa1:    %.5f", ioa1), 1);
                continue;
            }
            if (this.effMethod.getValue()[i] == this.IOA_2) {
                double ioa2 = IndexOfAgreement.calc_IOA(preData_1, valData_1, 2.0, this.getModel());
                this.ioa2.setValue(ioa2);
                this.getModel().getRuntime().println(String.format(Locale.US, "ioa2:    %.5f", ioa2), 1);
                continue;
            }
            if (this.effMethod.getValue()[i] == this.R2) {
                double[] rCoeff = Regression.calcLinReg(valData_1, preData_1);
                this.getModel().getRuntime().println(String.format(Locale.US, "rsq:     %.5f", rCoeff[2]), 1);
                this.getModel().getRuntime().println(String.format(Locale.US, "grad:    %.5f", rCoeff[1]), 1);
                this.rsq.setValue(rCoeff[2]);
                this.grad.setValue(rCoeff[1]);
                continue;
            }
            if (this.effMethod.getValue()[i] == this.WR2) {
                double[] rCoeff = Regression.calcLinReg(valData_1, preData_1);
                double wr = rCoeff[1] <= 1.0 ? Math.abs(rCoeff[1]) * rCoeff[2] : Math.pow(Math.abs(rCoeff[1]), -1.0) * rCoeff[2];
                this.wrsq.setValue(wr);
                this.getModel().getRuntime().println(String.format(Locale.US, "wrsq:    %.5f", wr), 1);
                continue;
            }
            if (this.effMethod.getValue()[i] == this.DSGRAD) {
                double dsGrad = DoubleSumAnalysis.dsGrad(valData_1, preData_1);
                this.dsGrad.setValue(dsGrad);
                this.getModel().getRuntime().println(String.format(Locale.US, "dsGrad:  %.5f", dsGrad), 1);
                continue;
            }
            if (this.effMethod.getValue()[i] == this.ABSVOLERROR) {
                double volErr = VolumeError.absVolumeError(valData_1, preData_1);
                this.absVolErr.setValue(volErr);
                this.getModel().getRuntime().println(String.format(Locale.US, "AVE:     %.5f", volErr), 1);
                continue;
            }
            if (this.effMethod.getValue()[i] == this.RMSE) {
                double rmse = PredictionErrors.rootMeanSquareError(valData_1, preData_1);
                this.rmse.setValue(rmse);
                this.getModel().getRuntime().println(String.format(Locale.US, "RMSE:    %.5f", rmse), 1);
                continue;
            }
            if (this.effMethod.getValue()[i] == this.PBIAS) {
                double pbias = VolumeError.pbias(valData_1, preData_1);
                this.pbias.setValue(pbias);
                this.getModel().getRuntime().println(String.format(Locale.US, "PBIAS:   %.5f", pbias), 1);
                continue;
            }
            if (this.effMethod.getValue()[i] != this.APBIAS) continue;
            double apbias = VolumeError.pbias2(valData_1, preData_1);
            this.apbias.setValue(apbias);
            this.getModel().getRuntime().println(String.format(Locale.US, "APBIAS:  %.5f", apbias), 1);
        }
        this.getModel().getRuntime().println("********************************************************************", 1);
        this.getModel().getRuntime().println("", 1);
    }
}

