/*
 * Decompiled with CFR 0.152.
 */
package org.unijena.j2k.routing;

import jams.data.Attribute;
import jams.model.JAMSComponent;
import jams.model.JAMSComponentDescription;
import jams.model.JAMSVarDescription;

@JAMSComponentDescription(title="J2KGlacier2ReachRouting", author="Peter Krause", description="Passes the melt of a glacier HRU to a correspondingreach as component RD1")
public class J2KGlacier2ReachRouting
extends JAMSComponent {
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="Collection of reach objects")
    public Attribute.EntityCollection reaches;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READWRITE, description="HRU statevar glacier melt outflow")
    public Attribute.Double glacierRunoff;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READWRITE, description="HRU RD1 from upper HRUs")
    public Attribute.Double inRD1;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READWRITE, description="the receiving reach")
    public Attribute.Entity toReach;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READWRITE, description="the receiving glacier HRU")
    public Attribute.Entity toPoly;

    public void run() {
        double gm = this.glacierRunoff.getValue();
        if (!this.toPoly.isEmpty()) {
            double RD1inside = this.inRD1.getValue();
            double RD1in = this.toPoly.getDouble("inRD1");
            RD1in = RD1in + gm + RD1inside;
            this.inRD1.setValue(0.0);
            this.toPoly.setDouble("inRD1", RD1in);
        } else if (!this.toReach.isEmpty()) {
            double RD1inside = this.inRD1.getValue();
            double RD1in = this.toReach.getDouble("inRD1");
            RD1in = RD1in + gm + RD1inside;
            this.inRD1.setValue(0.0);
            this.toReach.setDouble("inRD1", RD1in);
        }
    }
}

