/*
 * Decompiled with CFR 0.152.
 */
package org.unijena.j2k.regionalisation;

import jams.data.Attribute;
import jams.model.JAMSComponent;
import jams.model.JAMSComponentDescription;
import jams.model.JAMSVarDescription;
import jams.workspace.DataSetDefinition;
import jams.workspace.stores.InputDataStore;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import org.unijena.j2k.statistics.IDW;

@JAMSComponentDescription(title="IDWWeightCalculator", author="Peter Krause and Sven Kralisch", date="2008-12-07", version="1.0_0", description="Get stations coordinates from DataStore and calculate inverse distance weights for the regionalisation procedure. Based on org.unijena.j2k.regionalization.CalcIDWeights.")
public class IDWWeightCalculator
extends JAMSComponent {
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="entity x-coordinate")
    public Attribute.Double entityX;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="entity y-coordinate")
    public Attribute.Double entityY;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="Power of IDW function")
    public Attribute.Double pidw;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.WRITE, description="weights for IDW part of regionalisation")
    public Attribute.DoubleArray statWeights;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.WRITE, description="position array to determine best weights")
    public Attribute.IntegerArray statOrder;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="Weights for Thiessen polygons", defaultValue="false")
    public Attribute.Boolean equalWeights;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="Calculation with geographical coordinates lat, long", defaultValue="false")
    public Attribute.Boolean latLong;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="ID of the datastore to read station coordinates from")
    public Attribute.String dataStoreID;
    private double[] statX;
    private double[] statY;
    InputDataStore store = null;
    IDW idw = new IDW();

    public void init() {
        boolean isLatLon;
        if (this.dataStoreID != null) {
            this.store = this.getModel().getWorkspace().getInputDataStore(this.dataStoreID.getValue());
        }
        if (this.store == null) {
            this.getModel().getRuntime().sendHalt("Error accessing datastore \"" + this.dataStoreID + "\" from " + this.getInstanceName() + ": Datastore could not be found!");
            return;
        }
        DataSetDefinition dsDef = this.store.getDataSetDefinition();
        ArrayList xList = dsDef.getAttributeValues("X");
        ArrayList yList = dsDef.getAttributeValues("Y");
        if (xList == null || yList == null) {
            this.getModel().getRuntime().sendHalt("Error accessing datastore \"" + this.dataStoreID + "\" from " + this.getInstanceName() + ": x or y coordinates are not set!");
        }
        if (xList.size() != yList.size()) {
            this.getModel().getRuntime().sendHalt("Error accessing datastore \"" + this.dataStoreID + "\" from " + this.getInstanceName() + ": Number of x and y coordinates differ!");
            return;
        }
        this.statX = this.listToDoubleArray(xList);
        this.statY = this.listToDoubleArray(yList);
        boolean bl = isLatLon = this.latLong != null && this.latLong.getValue();
        if (isLatLon) {
            this.idw.init(this.statX, this.statY, null, this.pidw.getValue(), IDW.Projection.LATLON);
        } else {
            this.idw.init(this.statX, this.statY, null, this.pidw.getValue(), IDW.Projection.ANY);
        }
    }

    public void run() {
        double[] weights = this.statWeights.getValue();
        int[] wA = this.statOrder.getValue();
        int n = this.statX.length;
        if (weights == null || weights.length != n) {
            weights = new double[n];
        }
        if (wA == null || wA.length != n) {
            wA = new int[n];
        }
        if (this.equalWeights == null || !this.equalWeights.getValue()) {
            this.idw.getIDW(this.entityX.getValue(), this.entityY.getValue(), null, 1);
            System.arraycopy(this.idw.getWeights(), 0, weights, 0, n);
            System.arraycopy(this.idw.getWeightOrder(), 0, wA, 0, n);
        } else if (this.equalWeights.getValue()) {
            for (int i = 0; i < n; ++i) {
                weights[i] = 1.0 / (double)n;
                wA[i] = i;
            }
        }
        this.statWeights.setValue(weights);
        this.statOrder.setValue(wA);
    }

    public void cleanup() {
        Arrays.fill(this.statWeights.getValue(), 0.0);
        if (this.store != null) {
            try {
                this.store.close();
            }
            catch (IOException ioe) {
                ioe.printStackTrace();
            }
        }
    }

    private double[] listToDoubleArray(ArrayList<Object> list) {
        double[] result = new double[list.size()];
        int i = 0;
        for (Object o : list) {
            result[i] = (Double)o;
            ++i;
        }
        return result;
    }
}

