/*
 * Decompiled with CFR 0.152.
 */
package org.unijena.j2k.lake;

import jams.data.Attribute;
import jams.model.JAMSComponent;
import jams.model.JAMSComponentDescription;
import jams.model.JAMSVarDescription;

@JAMSComponentDescription(title="J2KProcessLake", author="Peter Krause", description="A module for integration of lakes")
public class J2KProcessLake
extends JAMSComponent {
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="HRU attribute name area")
    public Attribute.Double area;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READWRITE, description="state variable rain")
    public Attribute.Double precip;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="state variable potET")
    public Attribute.Double potET;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READWRITE, description="state variable actET")
    public Attribute.Double actET;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READWRITE, description="state variable lake storage")
    public Attribute.Double lakeStorage;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READWRITE, description="state variable lake storage")
    public Attribute.Double lakeChange;

    public void init() {
        this.lakeStorage.setValue(0.0);
    }

    public void run() {
        double ls = this.lakeStorage.getValue();
        double run_precip = this.precip.getValue() * this.area.getValue();
        ls += run_precip;
        this.actET.setValue(this.potET.getValue());
        this.precip.setValue(run_precip);
        this.lakeStorage.setValue(ls -= this.potET.getValue());
        this.lakeChange.setValue(run_precip - this.potET.getValue());
    }

    public void cleanup() {
        this.lakeStorage.setValue(0.0);
    }
}

