/*
 * Decompiled with CFR 0.152.
 */
package org.unijena.j2k.io;

import jams.data.Attribute;
import jams.model.JAMSComponent;
import jams.model.JAMSComponentDescription;
import jams.model.JAMSVarDescription;
import jams.tools.FileTools;
import java.util.HashMap;
import org.unijena.j2k.J2KFunctions;

@JAMSComponentDescription(title="StandardSoilParaReader", author="Sven Kralisch", date="2005-11-10", version="1.0_0", description="Reads soil information and links them to model entities")
public class StandardSoilParaReader
extends JAMSComponent {
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="Soil types parameter file name")
    public Attribute.String stFileName;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="List of hru objects")
    public Attribute.EntityCollection hrus;

    public void init() {
        Attribute.EntityCollection soilTypes = this.getModel().getRuntime().getDataFactory().createEntityCollection();
        soilTypes.setEntities(J2KFunctions.readParas(FileTools.createAbsoluteFileName((String)this.getModel().getWorkspaceDirectory().getPath(), (String)this.stFileName.getValue()), this.getModel()));
        HashMap<Double, Attribute.Entity> stMap = new HashMap<Double, Attribute.Entity>();
        for (Attribute.Entity st : soilTypes.getEntities()) {
            stMap.put(st.getDouble("SID"), st);
        }
        for (Attribute.Entity e : this.hrus.getEntities()) {
            Attribute.Entity st;
            st = (Attribute.Entity)stMap.get(e.getDouble("soilID"));
            e.setObject("soilType", (Object)st);
            if (st == null) {
                this.getModel().getRuntime().println("SoilType " + e.getDouble("soilID") + " is not defined in soil parameter table");
                continue;
            }
            Object[] attrs = st.getKeys();
            for (int i = 0; i < attrs.length; ++i) {
                Object o = st.getObject((String)attrs[i]);
                if (o instanceof Attribute.String) continue;
                e.setObject((String)attrs[i], o);
            }
        }
        this.getModel().getRuntime().println("Soil parameter file processed ...", 2);
    }
}

