/*
 * Decompiled with CFR 0.152.
 */
package org.unijena.j2k.inputData;

import jams.JAMS;
import jams.data.Attribute;
import jams.model.JAMSComponent;
import jams.model.JAMSComponentDescription;
import jams.model.JAMSVarDescription;
import org.unijena.j2k.statistics.IDW;

@JAMSComponentDescription(title="RainCorrection_Richter", author="Peter Krause", description="Applies correction according to RICHTER 1985 for measured daily precip sums", version="1.0_0", date="2011-05-30")
public class RainCorrectionRichter
extends JAMSComponent {
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="time")
    public Attribute.Calendar time;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="the precip values", unit="mm")
    public Attribute.DoubleArray precip;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="temperature for the correction function", unit="\u00b0C")
    public Attribute.DoubleArray temperature;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.WRITE, description="corrected precip values", unit="mm")
    public Attribute.DoubleArray rcorr;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="array of temperature station elevations", unit="m")
    public Attribute.DoubleArray tempElevation;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="array of temperature station's x coordinate")
    public Attribute.DoubleArray tempXCoord;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="array of temperature station's y coordinate")
    public Attribute.DoubleArray tempYCoord;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="Regression coefficients for temperature")
    public Attribute.DoubleArray tempRegCoeff;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="array of precip station elevations", unit="m")
    public Attribute.DoubleArray rainElevation;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="array of precip station's x coordinate")
    public Attribute.DoubleArray rainXCoord;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="array of precip station's y coordinate")
    public Attribute.DoubleArray rainYCoord;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="number of temperature station for IDW")
    public Attribute.Integer tempNIDW;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="power for IDW function")
    public Attribute.Double pIDW;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="regression threshold")
    public Attribute.Double regThres;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="snow_trs", upperBound=5.0, lowerBound=-5.0, unit="\u00b0C")
    public Attribute.Double snow_trs;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="snow_trans", upperBound=10.0, lowerBound=0.0, unit="K")
    public Attribute.Double snow_trans;
    IDW idw = new IDW();

    public void run() {
        double[] precip = this.precip.getValue();
        double[] temperature = this.temperature.getValue();
        int n = precip.length;
        double[] rcorr = this.rcorr.getValue();
        if (rcorr == null || rcorr.length != n) {
            rcorr = new double[n];
        }
        double[] rainElev = this.rainElevation.getValue();
        double[] rainX = this.rainXCoord.getValue();
        double[] rainY = this.rainYCoord.getValue();
        double rsq = this.tempRegCoeff.getValue()[2];
        double grad = this.tempRegCoeff.getValue()[1];
        this.idw.init(this.tempXCoord.getValue(), this.tempYCoord.getValue(), this.tempElevation.getValue(), (int)this.pIDW.getValue(), IDW.Projection.ANY);
        for (int r = 0; r < n; ++r) {
            double rainTemp = 0.0;
            rainTemp = rsq > this.regThres.getValue() ? this.idw.getElevationCorrectedIDW(rainX[r], rainY[r], rainElev[r], grad, temperature, this.tempNIDW.getValue()) : this.idw.getIDW(rainX[r], rainY[r], temperature, this.tempNIDW.getValue());
            double pSnow = (this.snow_trs.getValue() + this.snow_trans.getValue() - rainTemp) / (2.0 * this.snow_trans.getValue());
            if (pSnow > 1.0) {
                pSnow = 1.0;
            } else if (pSnow < 0.0) {
                pSnow = 0.0;
            }
            double rain = (1.0 - pSnow) * precip[r];
            double snow = pSnow * precip[r];
            if (snow > 0.0) {
                if (snow <= 0.1) {
                    snow += snow * 0.938;
                } else {
                    double relSnow = 0.5319 * Math.pow(snow, -0.197);
                    snow += snow * relSnow;
                }
            }
            if (rain > 0.0) {
                rain = rain < 0.1 ? (rain += rain * 0.492) : (rain += rain * (0.1349 * Math.pow(rain, -0.494)));
            }
            double wetErr = precip[r] < 0.1 ? 0.0 : (this.time.get(2) >= 4 & this.time.get(2) < 10 ? (precip[r] >= 9.0 ? 0.47 : 0.08 * Math.log(precip[r]) + 0.225) : (precip[r] >= 9.0 ? 0.3 : 0.05 * Math.log(precip[r]) + 0.13));
            rcorr[r] = precip[r] == JAMS.getMissingDataValue() ? JAMS.getMissingDataValue() : rain + snow + wetErr;
        }
        this.rcorr.setValue(rcorr);
    }
}

