/*
 * Decompiled with CFR 0.152.
 */
package org.unijena.j2k.inputData;

import jams.data.Attribute;
import jams.model.JAMSComponent;
import jams.model.JAMSComponentDescription;
import jams.model.JAMSVarDescription;
import org.unijena.j2k.geographicalCalculations.CalcSlopeAspectCorrectionFactor;
import org.unijena.j2k.geographicalCalculations.GKConversion;

@JAMSComponentDescription(title="CalcAdditionalHRUAttribs", author="Peter Krause", description="Calculates additional attributes from existent ones")
public class CalcAdditionalHRUAttribs
extends JAMSComponent {
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="The current hru entity")
    public Attribute.Entity entity;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="attribute x-coordinate")
    public Attribute.Double x;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="attribute y-coordinate")
    public Attribute.Double y;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="attribute slope")
    public Attribute.Double slope;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="attribute aspect")
    public Attribute.Double aspect;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.WRITE, description="attribute latidute")
    public Attribute.Double latitude;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.WRITE, description="attribute longitude")
    public Attribute.Double longitude;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.WRITE, description="attribute slopeAspectCorrection factor")
    public Attribute.Double slAsCf;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="Current time")
    public Attribute.Calendar time;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="temporal resolution [d | h | m]")
    public Attribute.String tempRes;
    int[] monthMean = new int[]{15, 45, 74, 105, 135, 166, 196, 227, 258, 288, 319, 349};

    public void init() {
        double[] latLong = new double[2];
        latLong = GKConversion.GK2LatLon(this.x.getValue(), this.y.getValue());
        this.latitude.setValue(latLong[0]);
        this.longitude.setValue(latLong[1]);
        this.getModel().getRuntime().println("slope:" + this.slope.getValue());
    }

    public void run() throws Attribute.Entity.NoSuchAttributeException {
        int julDay = 0;
        if (this.tempRes == null || this.tempRes.equals((Object)"d") || this.tempRes.equals((Object)"h")) {
            julDay = this.time.get(6);
        } else if (this.tempRes.equals((Object)"m")) {
            int month = this.time.get(2);
            julDay = this.monthMean[month];
        }
        double sloAspCorr = CalcSlopeAspectCorrectionFactor.calc_slopeAspectCorrectionFactor(julDay, this.latitude.getValue(), this.slope.getValue(), this.aspect.getValue());
        this.slAsCf.setValue(sloAspCorr);
    }

    public void cleanup() {
    }
}

