/*
 * Decompiled with CFR 0.152.
 */
package jams.server.entities;

import java.io.Serializable;
import java.util.Date;
import javax.persistence.Basic;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.NamedQueries;
import javax.persistence.NamedQuery;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;
import javax.xml.bind.annotation.XmlRootElement;

@Entity
@Table(name="files")
@XmlRootElement
@NamedQueries(value={@NamedQuery(name="File.findById", query="SELECT u FROM File u WHERE u.id = :id"), @NamedQuery(name="File.findByHash", query="SELECT u FROM File u WHERE u.hash = :hash"), @NamedQuery(name="File.findUnused", query="SELECT f FROM File f LEFT join WorkspaceFileAssociation wfa ON (f.id = wfa.file_id) WHERE wfa.file_id is null")})
public class File
implements Serializable {
    private static final long serialVersionUID = 1L;
    @Id
    @GeneratedValue(strategy=GenerationType.IDENTITY)
    @Basic(optional=false)
    @Column(name="id")
    private Integer id;
    @Basic(optional=false)
    @NotNull
    @Size(min=1, max=50)
    @Column(name="hash")
    private String hash;
    @Temporal(value=TemporalType.DATE)
    @Column(name="creation")
    private Date creation;
    @Basic(optional=false)
    @Column(name="serverLocation")
    private String location;
    @Basic(optional=true)
    @Column(name="fileSize")
    private Long fileSize;
    public static final File NON_FILE = new File(0, "0");

    public File() {
        this.init();
    }

    public File(Integer id) {
        this.id = id;
        this.init();
    }

    public File(Integer id, String hash) {
        this.id = id;
        this.hash = hash;
        this.init();
    }

    private void init() {
        this.setCreationDate(new Date());
    }

    public Integer getId() {
        return this.id;
    }

    public void setId(Integer id) {
        this.id = id;
    }

    public String getHash() {
        return this.hash;
    }

    public void setHash(String hash) {
        this.hash = hash;
    }

    public boolean isHashValid() {
        return !this.hash.isEmpty() && !this.hash.equals("0");
    }

    public Date getCreationDate() {
        return this.creation;
    }

    public void setCreationDate(Date date) {
        this.creation = date;
    }

    public String getLocation() {
        return this.location;
    }

    public void setLocation(String location) {
        this.location = location;
        if (this.getLocation() == null) {
            return;
        }
        java.io.File f = new java.io.File(this.getLocation());
        if (f.exists()) {
            this.fileSize = f.length();
        }
    }

    public long getFileSize() {
        return this.fileSize == null ? 0L : this.fileSize;
    }

    public void setFileSize(long size) {
        this.fileSize = size;
    }

    public int hashCode() {
        int hash = 0;
        return hash += this.id != null ? this.id.hashCode() : 0;
    }

    public boolean equals(Object object) {
        if (!(object instanceof File)) {
            return false;
        }
        File other = (File)object;
        return (this.id != null || other.id == null) && (this.id == null || this.id.equals(other.id));
    }

    public String toString() {
        return "jams.server.entities.Files[ id=" + this.id + " ]";
    }
}

