/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.metadata.iso.identification;

import java.util.Collection;
import java.util.Date;
import org.geotools.metadata.iso.MetadataEntity;
import org.opengis.metadata.citation.ResponsibleParty;
import org.opengis.metadata.identification.Usage;
import org.opengis.util.InternationalString;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UsageImpl
extends MetadataEntity
implements Usage {
    private static final long serialVersionUID = 4059324536168287490L;
    private InternationalString specificUsage;
    private long usageDate = Long.MIN_VALUE;
    private InternationalString userDeterminedLimitations;
    private Collection<ResponsibleParty> userContactInfo;

    public UsageImpl() {
    }

    public UsageImpl(Usage source) {
        super(source);
    }

    public UsageImpl(InternationalString specificUsage, Collection<ResponsibleParty> userContactInfo) {
        this.setUserContactInfo(userContactInfo);
        this.setSpecificUsage(specificUsage);
    }

    @Override
    public InternationalString getSpecificUsage() {
        return this.specificUsage;
    }

    public synchronized void setSpecificUsage(InternationalString newValue) {
        this.checkWritePermission();
        this.specificUsage = newValue;
    }

    @Override
    public synchronized Date getUsageDate() {
        return this.usageDate != Long.MIN_VALUE ? new Date(this.usageDate) : null;
    }

    public synchronized void setUsageDate(Date newValue) {
        this.checkWritePermission();
        this.usageDate = newValue != null ? newValue.getTime() : Long.MIN_VALUE;
    }

    @Override
    public InternationalString getUserDeterminedLimitations() {
        return this.userDeterminedLimitations;
    }

    public synchronized void setUserDeterminedLimitations(InternationalString newValue) {
        this.checkWritePermission();
        this.userDeterminedLimitations = newValue;
    }

    public synchronized Collection<ResponsibleParty> getUserContactInfo() {
        this.userContactInfo = this.nonNullCollection(this.userContactInfo, ResponsibleParty.class);
        return this.userContactInfo;
    }

    public synchronized void setUserContactInfo(Collection<? extends ResponsibleParty> newValues) {
        this.userContactInfo = this.copyCollection(newValues, this.userContactInfo, ResponsibleParty.class);
    }
}

