/*
 * Decompiled with CFR 0.152.
 */
package jams.model;

import jams.model.JAMSFullModelState;
import jams.model.SmallModelState;
import jams.tools.JAMSTools;
import jams.workspace.stores.DataStore;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamClass;
import java.util.HashMap;
import java.util.logging.Level;
import java.util.logging.Logger;

public class JAMSSmallModelState
implements SmallModelState {
    HashMap<String, byte[]> dataStoreStateMap;
    long executionTime;
    transient ClassLoader loader;

    public JAMSSmallModelState(ClassLoader loader) {
        this.loader = loader;
        this.dataStoreStateMap = new HashMap();
    }

    public void recoverDataStoreState(DataStore store) throws IOException {
        Logger.getLogger(JAMSSmallModelState.class.getName()).log(Level.FINE, "recover:{0}", store.getID());
        byte[] data = this.dataStoreStateMap.get(store.getID());
        if (data == null) {
            Logger.getLogger(JAMSSmallModelState.class.getName(), "recover:" + store.getID());
            Logger.getLogger(JAMSSmallModelState.class.getName()).log(Level.SEVERE, "could not recover:{0}", store.getID());
            throw new IOException("could not recover:" + store.getID());
        }
        ByteArrayInputStream inStream = new ByteArrayInputStream(data);
        ClassLoaderObjectInputStream in = new ClassLoaderObjectInputStream(inStream);
        in.setClassLoader(this.loader);
        try {
            JAMSTools.cloneInto(store, in.readObject(), store.getClass());
        }
        catch (ClassNotFoundException cnfe) {
            cnfe.printStackTrace();
        }
    }

    public void saveDataStoreState(DataStore state) {
        ByteArrayOutputStream outStream = new ByteArrayOutputStream();
        try {
            ObjectOutputStream objOut = new ObjectOutputStream(outStream);
            objOut.writeObject(state);
            objOut.flush();
            objOut.close();
            outStream.close();
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
            System.out.println(ioe);
        }
        this.dataStoreStateMap.put(state.getID(), outStream.toByteArray());
    }

    public void setExecutionTime(long time) {
        this.executionTime = time;
    }

    public long getExecutionTime() {
        return this.executionTime;
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        if (in instanceof JAMSFullModelState.ClassLoaderObjectInputStream) {
            this.loader = ((JAMSFullModelState.ClassLoaderObjectInputStream)in).getClassLoader();
        }
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.defaultWriteObject();
    }

    public class ClassLoaderObjectInputStream
    extends ObjectInputStream {
        private ClassLoader classLoader;

        public ClassLoaderObjectInputStream(InputStream in) throws IOException {
            super(in);
            this.classLoader = null;
        }

        public void setClassLoader(ClassLoader loader) {
            this.classLoader = loader;
        }

        public ClassLoader getClassLoader() {
            return this.classLoader;
        }

        @Override
        protected Class<?> resolveClass(ObjectStreamClass desc) throws IOException, ClassNotFoundException {
            try {
                if (this.classLoader == null) {
                    this.classLoader = Thread.currentThread().getContextClassLoader();
                }
                String name = desc.getName();
                return Class.forName(name, false, this.classLoader);
            }
            catch (ClassNotFoundException e) {
                return super.resolveClass(desc);
            }
        }
    }
}

