/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwindx.examples.util;

import gov.nasa.worldwind.event.SelectEvent;
import gov.nasa.worldwind.event.SelectListener;
import gov.nasa.worldwind.geom.Position;
import gov.nasa.worldwind.render.Annotation;
import gov.nasa.worldwind.render.BasicWWTexture;
import gov.nasa.worldwind.render.DrawContext;
import gov.nasa.worldwind.render.WWTexture;
import gov.nasa.worldwind.util.Logging;
import gov.nasa.worldwind.util.OGLStackHandler;
import gov.nasa.worldwindx.examples.util.ImageAnnotation;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import javax.media.opengl.GL2;
import javax.swing.event.EventListenerList;

public class ButtonAnnotation
extends ImageAnnotation
implements SelectListener {
    protected boolean enabled;
    protected boolean pressed;
    protected String actionCommand;
    protected double disabledOpacity;
    protected WWTexture pressedMaskTexture;
    protected EventListenerList listenerList = new EventListenerList();

    public ButtonAnnotation(Object object, Object object2) {
        super(object);
        this.setEnableSmoothing(false);
        this.setUseMipmaps(false);
        this.enabled = true;
        this.disabledOpacity = 0.6;
        this.setPressedMaskSource(object2);
    }

    public ButtonAnnotation(Object object) {
        this(object, null);
    }

    public ButtonAnnotation() {
        this(null);
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean bl) {
        this.enabled = bl;
    }

    public boolean isPressed() {
        return this.pressed;
    }

    public void setPressed(boolean bl) {
        this.pressed = bl;
    }

    public String getActionCommand() {
        return this.actionCommand;
    }

    public void setActionCommand(String string) {
        this.actionCommand = string;
    }

    public double getDisabledOpacity() {
        return this.disabledOpacity;
    }

    public void setDisabledOpacity(double d) {
        if (d < 0.0 || d > 1.0) {
            String string = Logging.getMessage("generic.ArgumentOutOfRange", "opacity < 0 or opacity > 1");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        this.disabledOpacity = d;
    }

    public Object getPressedMaskSource() {
        return this.pressedMaskTexture != null ? this.pressedMaskTexture.getImageSource() : null;
    }

    public void setPressedMaskSource(Object object) {
        this.pressedMaskTexture = null;
        if (object != null) {
            this.pressedMaskTexture = new BasicWWTexture(object, false);
        }
    }

    public WWTexture getPressedMaskTexture() {
        return this.pressedMaskTexture;
    }

    public ActionListener[] getActionListeners() {
        return (ActionListener[])this.listenerList.getListeners(ActionListener.class);
    }

    public void addActionListener(ActionListener actionListener) {
        this.listenerList.add(ActionListener.class, actionListener);
    }

    public void removeActionListener(ActionListener actionListener) {
        this.listenerList.remove(ActionListener.class, actionListener);
    }

    @Override
    protected void setupAnnotationAttributes(Annotation annotation) {
        super.setupAnnotationAttributes(annotation);
        annotation.setPickEnabled(true);
    }

    @Override
    public void selected(SelectEvent selectEvent) {
        if (selectEvent == null) {
            return;
        }
        if (selectEvent.getEventAction() == "gov.nasa.worldwind.SelectEvent.Hover" || selectEvent.getEventAction() == "gov.nasa.worldwind.SelectEvent.Rollover") {
            return;
        }
        if (!this.isEnabled()) {
            return;
        }
        Object object = selectEvent.getTopObject();
        if (object == this) {
            this.setPressed(this.isButtonPressed(selectEvent));
            if (this.isButtonTrigger(selectEvent)) {
                this.onButtonPressed(selectEvent);
            }
        }
    }

    protected boolean isButtonPressed(SelectEvent selectEvent) {
        return selectEvent.getEventAction() == "gov.nasa.worldwind.SelectEvent.LeftPress";
    }

    protected boolean isButtonTrigger(SelectEvent selectEvent) {
        return selectEvent.getEventAction() == "gov.nasa.worldwind.SelectEvent.LeftClick";
    }

    protected void onButtonPressed(SelectEvent selectEvent) {
        MouseEvent mouseEvent = selectEvent.getMouseEvent();
        this.fireActionPerformed(mouseEvent.getID(), mouseEvent.getWhen(), mouseEvent.getModifiers());
    }

    protected void fireActionPerformed(int n, long l, int n2) {
        ActionEvent actionEvent = null;
        Object[] objectArray = this.listenerList.getListenerList();
        for (int i = objectArray.length - 2; i >= 0; i -= 2) {
            if (objectArray[i] != ActionListener.class) continue;
            if (actionEvent == null) {
                actionEvent = new ActionEvent(this, n, this.getActionCommand(), l, n2);
            }
            ((ActionListener)objectArray[i + 1]).actionPerformed(actionEvent);
        }
    }

    @Override
    public void drawContent(DrawContext drawContext, int n, int n2, double d, Position position) {
        if (!this.isEnabled()) {
            d *= this.getDisabledOpacity();
        }
        super.drawContent(drawContext, n, n2, d, position);
        this.drawPressedMask(drawContext, n, n2, d, position);
    }

    protected void drawPressedMask(DrawContext drawContext, int n, int n2, double d, Position position) {
        if (drawContext.isPickingMode()) {
            return;
        }
        if (!this.isPressed()) {
            return;
        }
        this.doDrawPressedMask(drawContext, n, n2, d, position);
    }

    @Override
    protected void applyBackgroundTextureState(DrawContext drawContext, int n, int n2, double d, WWTexture wWTexture) {
        super.applyBackgroundTextureState(drawContext, n, n2, d, wWTexture);
        if (this.getPressedMaskTexture() == wWTexture) {
            GL2 gL2 = drawContext.getGL().getGL2();
            gL2.glEnable(3042);
            gL2.glBlendFunc(0, 768);
            gL2.glColor4f(1.0f, 1.0f, 1.0f, 1.0f);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doDrawPressedMask(DrawContext drawContext, int n, int n2, double d, Position position) {
        WWTexture wWTexture = this.getPressedMaskTexture();
        if (wWTexture == null) {
            return;
        }
        GL2 gL2 = drawContext.getGL().getGL2();
        OGLStackHandler oGLStackHandler = new OGLStackHandler();
        oGLStackHandler.pushAttrib(gL2, 16385);
        try {
            this.doDrawBackgroundTexture(drawContext, n, n2, 1.0, position, wWTexture);
        }
        finally {
            oGLStackHandler.pop(gL2);
        }
    }
}

