/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwindx.examples.symbology;

import gov.nasa.worldwind.Configuration;
import gov.nasa.worldwind.geom.Angle;
import gov.nasa.worldwind.geom.Position;
import gov.nasa.worldwind.layers.RenderableLayer;
import gov.nasa.worldwind.render.Material;
import gov.nasa.worldwind.render.Renderable;
import gov.nasa.worldwind.symbology.BasicTacticalGraphicAttributes;
import gov.nasa.worldwind.symbology.TacticalCircle;
import gov.nasa.worldwind.symbology.TacticalGraphic;
import gov.nasa.worldwind.symbology.TacticalGraphicAttributes;
import gov.nasa.worldwind.symbology.TacticalPoint;
import gov.nasa.worldwind.symbology.TacticalQuad;
import gov.nasa.worldwind.symbology.TacticalRoute;
import gov.nasa.worldwind.symbology.milstd2525.MilStd2525GraphicFactory;
import gov.nasa.worldwind.util.BasicDragger;
import gov.nasa.worldwind.util.WWUtil;
import gov.nasa.worldwindx.examples.ApplicationTemplate;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JSlider;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class TacticalGraphics
extends ApplicationTemplate {
    public static void main(String[] stringArray) {
        Configuration.setValue("gov.nasa.worldwind.avkey.InitialLatitude", 34.9);
        Configuration.setValue("gov.nasa.worldwind.avkey.InitialLongitude", -117.44);
        Configuration.setValue("gov.nasa.worldwind.avkey.InitialAltitude", 155000);
        ApplicationTemplate.start("World Wind Tactical Graphics", AppFrame.class);
    }

    public static class AppFrame
    extends ApplicationTemplate.AppFrame {
        protected RenderableLayer pointLayer = new RenderableLayer();
        protected RenderableLayer lineLayer;
        protected RenderableLayer areaLayer;
        protected TacticalGraphicAttributes sharedAttrs;
        protected TacticalGraphicAttributes sharedPointAttrs;

        public AppFrame() {
            super(true, true, false);
            this.pointLayer.setName("Tactical Graphics (Points)");
            this.lineLayer = new RenderableLayer();
            this.lineLayer.setName("Tactical Graphics (Lines)");
            this.areaLayer = new RenderableLayer();
            this.areaLayer.setName("Tactical Graphics (Areas)");
            this.sharedAttrs = new BasicTacticalGraphicAttributes();
            this.sharedAttrs.setScale(0.25);
            this.sharedPointAttrs = new BasicTacticalGraphicAttributes();
            this.createPointGraphics(this.pointLayer);
            this.createLineGraphics(this.lineLayer);
            this.createAreaGraphics(this.areaLayer);
            ApplicationTemplate.insertBeforePlacenames(this.getWwd(), this.pointLayer);
            ApplicationTemplate.insertBeforePlacenames(this.getWwd(), this.lineLayer);
            ApplicationTemplate.insertBeforePlacenames(this.getWwd(), this.areaLayer);
            this.getLayerPanel().update(this.getWwd());
            this.getWwd().addSelectListener(new BasicDragger(this.getWwd()));
            this.addGraphicControls();
            Dimension dimension = new Dimension(1800, 1000);
            this.setPreferredSize(dimension);
            this.pack();
            WWUtil.alignComponent(null, this, "gov.nasa.worldwind.avkey.Center");
        }

        protected void createPointGraphics(RenderableLayer renderableLayer) {
            MilStd2525GraphicFactory milStd2525GraphicFactory = new MilStd2525GraphicFactory();
            TacticalPoint tacticalPoint = milStd2525GraphicFactory.createPoint("GHMPNZ--------X", Position.fromDegrees(35.2144, -117.8824), null);
            tacticalPoint.setValue("gov.nasa.worldwind.avkey.DisplayName", "Nuclear Event (2.X.3.4.2)");
            tacticalPoint.setText("X691");
            tacticalPoint.setModifier("W", "10095900ZJAN92");
            tacticalPoint.setModifier("C", "15");
            tacticalPoint.setModifier("V", "B83");
            renderableLayer.addRenderable(tacticalPoint);
            tacticalPoint = milStd2525GraphicFactory.createPoint("GHMPOHTH------X", Position.fromDegrees(35.2544, -117.724), null);
            tacticalPoint.setValue("gov.nasa.worldwind.avkey.DisplayName", "High Tower");
            tacticalPoint.setModifier("X", "2562");
            renderableLayer.addRenderable(tacticalPoint);
            this.setAttributes(renderableLayer, this.sharedAttrs, this.sharedPointAttrs);
        }

        protected void createLineGraphics(RenderableLayer renderableLayer) {
            MilStd2525GraphicFactory milStd2525GraphicFactory = new MilStd2525GraphicFactory();
            List<Position> list = Arrays.asList(Position.fromDegrees(34.9349, -117.6303), Position.fromDegrees(34.9843, -117.5885), Position.fromDegrees(34.9961, -117.4891));
            TacticalGraphic tacticalGraphic = milStd2525GraphicFactory.createGraphic("GFGPGLP----AUSX", list, null);
            tacticalGraphic.setValue("gov.nasa.worldwind.avkey.DisplayName", "Phase line: friendly (2.X.2.2.2.2)");
            tacticalGraphic.setText("A");
            renderableLayer.addRenderable(tacticalGraphic);
            list = Arrays.asList(Position.fromDegrees(34.919, -117.5919), Position.fromDegrees(34.9589, -117.5618), Position.fromDegrees(34.9701, -117.4798));
            tacticalGraphic = milStd2525GraphicFactory.createGraphic("GHGPGLP----AUSX", list, null);
            tacticalGraphic.setValue("gov.nasa.worldwind.avkey.DisplayName", "Phase line: hostile (2.X.2.2.2.2)");
            tacticalGraphic.setText("B");
            renderableLayer.addRenderable(tacticalGraphic);
            list = Arrays.asList(Position.fromDegrees(34.891, -117.5726), Position.fromDegrees(34.9367, -117.5354), Position.fromDegrees(34.948, -117.4741));
            tacticalGraphic = milStd2525GraphicFactory.createGraphic("GHGAGLP----AUSX", list, null);
            tacticalGraphic.setValue("gov.nasa.worldwind.avkey.DisplayName", "Phase line: hostile, anticipated (2.X.2.2.2.2)");
            tacticalGraphic.setText("C");
            renderableLayer.addRenderable(tacticalGraphic);
            list = Arrays.asList(Position.fromDegrees(34.8703, -117.5525), Position.fromDegrees(34.9158, -117.5153), Position.fromDegrees(34.9238, -117.46));
            tacticalGraphic = milStd2525GraphicFactory.createGraphic("GFGPGLP----AUSX", list, null);
            tacticalGraphic.setText("D");
            tacticalGraphic.setValue("gov.nasa.worldwind.avkey.DisplayName", "Phase line: custom color and font (2.X.2.2.2.2)");
            BasicTacticalGraphicAttributes basicTacticalGraphicAttributes = new BasicTacticalGraphicAttributes();
            basicTacticalGraphicAttributes.setOutlineMaterial(Material.GRAY);
            basicTacticalGraphicAttributes.setTextModifierFont(Font.decode("Arial-12"));
            tacticalGraphic.setAttributes(basicTacticalGraphicAttributes);
            renderableLayer.addRenderable(tacticalGraphic);
            list = Arrays.asList(Position.fromDegrees(34.5479, -117.8777), Position.fromDegrees(34.5137, -118.0092), Position.fromDegrees(34.5898, -118.0775), Position.fromDegrees(34.536, -118.1833));
            tacticalGraphic = milStd2525GraphicFactory.createGraphic("GHGPGLB----JUSX", list, null);
            tacticalGraphic.setModifier("T", Arrays.asList("40ID", "18ID"));
            tacticalGraphic.setValue("gov.nasa.worldwind.avkey.DisplayName", "Boundary (2.X.2.1.2.1)");
            renderableLayer.addRenderable(tacticalGraphic);
            list = Arrays.asList(Position.fromDegrees(34.6643, -117.7323), Position.fromDegrees(34.6962, -117.7808), Position.fromDegrees(34.6934, -117.8444), Position.fromDegrees(34.6602, -117.857), Position.fromDegrees(34.6844, -117.7303));
            tacticalGraphic = milStd2525GraphicFactory.createGraphic("GFGPOLAGM-----X", list, null);
            tacticalGraphic.setValue("gov.nasa.worldwind.avkey.DisplayName", "Main Attack (2.X.2.5.2.1.4.1)");
            renderableLayer.addRenderable(tacticalGraphic);
            list = Arrays.asList(Position.fromDegrees(34.761, -117.4541), Position.fromDegrees(34.7614, -117.5852), Position.fromDegrees(34.7287, -117.6363), Position.fromDegrees(34.6726, -117.6363), Position.fromDegrees(34.782, -117.47));
            tacticalGraphic = milStd2525GraphicFactory.createGraphic("GFGPOLAR------X", list, null);
            tacticalGraphic.setValue("gov.nasa.worldwind.avkey.DisplayName", "Attack, Rotary Wing (2.X.2.5.2.1.3)");
            renderableLayer.addRenderable(tacticalGraphic);
            list = Arrays.asList(Position.fromDegrees(34.7437, -117.8007), Position.fromDegrees(34.7535, -117.9256), Position.fromDegrees(34.8051, -117.9707), Position.fromDegrees(34.7643, -117.8219));
            tacticalGraphic = milStd2525GraphicFactory.createGraphic("GFGPOLAV------X", list, null);
            tacticalGraphic.setValue("gov.nasa.worldwind.avkey.DisplayName", "Aviation (2.X.2.5.2.1.1)");
            renderableLayer.addRenderable(tacticalGraphic);
            list = Arrays.asList(Position.fromDegrees(34.698, -117.5541), Position.fromDegrees(34.6951, -117.4667), Position.fromDegrees(34.6733, -117.4303), Position.fromDegrees(34.6217, -117.4056), Position.fromDegrees(34.678, -117.53));
            tacticalGraphic = milStd2525GraphicFactory.createGraphic("GFGPOLAGS-----X", list, null);
            tacticalGraphic.setValue("gov.nasa.worldwind.avkey.DisplayName", "Supporting Attack (2.X.2.5.2.1.4.2)");
            renderableLayer.addRenderable(tacticalGraphic);
            list = Arrays.asList(Position.fromDegrees(34.7099, -117.9047), Position.fromDegrees(34.6725, -117.959), Position.fromDegrees(34.6814, -118.0522), Position.fromDegrees(34.7124, -117.9284));
            tacticalGraphic = milStd2525GraphicFactory.createGraphic("GFGPOLAA------X", list, null);
            tacticalGraphic.setValue("gov.nasa.worldwind.avkey.DisplayName", "Airborne (2.X.2.5.2.1.2)");
            tacticalGraphic.setModifier("A", "SFGPUCI--------");
            renderableLayer.addRenderable(tacticalGraphic);
            ArrayList<TacticalPoint> arrayList = new ArrayList<TacticalPoint>();
            TacticalPoint tacticalPoint = milStd2525GraphicFactory.createPoint("GFGPAPP-------X", Position.fromDegrees(34.8802, -117.9773), null);
            tacticalPoint.setText("1");
            arrayList.add(tacticalPoint);
            tacticalPoint = milStd2525GraphicFactory.createPoint("GFGPAPP-------X", Position.fromDegrees(35.0947, -117.9578), null);
            tacticalPoint.setText("2");
            arrayList.add(tacticalPoint);
            tacticalPoint = milStd2525GraphicFactory.createPoint("GFGPAPC-------X", Position.fromDegrees(35.1739, -117.6957), null);
            tacticalPoint.setText("3");
            arrayList.add(tacticalPoint);
            TacticalRoute tacticalRoute = milStd2525GraphicFactory.createRoute("GFGPALM-------X", arrayList, null);
            tacticalRoute.setValue("gov.nasa.worldwind.avkey.DisplayName", "Minimum Risk Route (2.X.2.2.2.2)");
            tacticalRoute.setText("KNIGHT");
            tacticalRoute.setModifier("AM", 4000.0);
            tacticalRoute.setModifier("W", Arrays.asList("270600Z", "271845Z"));
            tacticalRoute.setModifier("X", Arrays.asList("50 FT AGL", "200 FT AGL"));
            renderableLayer.addRenderable(tacticalRoute);
            list = Arrays.asList(Position.fromDegrees(35.0459, -117.3795), Position.fromDegrees(35.0459, -117.5633));
            tacticalGraphic = milStd2525GraphicFactory.createGraphic("GFGPOLKGM-----X", list, null);
            tacticalGraphic.setValue("gov.nasa.worldwind.avkey.DisplayName", "Direction of Main Attack (2.X.2.5.2.2.2.1)");
            renderableLayer.addRenderable(tacticalGraphic);
            list = Arrays.asList(Position.fromDegrees(34.8917, -117.8344), Position.fromDegrees(34.8283, -117.6794));
            tacticalGraphic = milStd2525GraphicFactory.createGraphic("GFFPLTF-------X", list, null);
            tacticalGraphic.setValue("gov.nasa.worldwind.avkey.DisplayName", "Final Protective Fire (2.X.4.2.1.2)");
            tacticalGraphic.setModifier("T", Arrays.asList("AG1201", "2-22 INF MORT"));
            renderableLayer.addRenderable(tacticalGraphic);
            list = Arrays.asList(Position.fromDegrees(34.5556, -117.4123), Position.fromDegrees(34.521, -117.4786), Position.fromDegrees(34.5942, -117.4766));
            tacticalGraphic = milStd2525GraphicFactory.createGraphic("GFGPSLA-------X", list, null);
            tacticalGraphic.setValue("gov.nasa.worldwind.avkey.DisplayName", "Ambush (2.X.2.6.1.1)");
            renderableLayer.addRenderable(tacticalGraphic);
            list = Arrays.asList(Position.fromDegrees(35.2805, -117.5978), Position.fromDegrees(35.2978, -117.3702));
            tacticalGraphic = milStd2525GraphicFactory.createGraphic("GFGPDLF-------X", list, null);
            tacticalGraphic.setValue("gov.nasa.worldwind.avkey.DisplayName", "Forward Edge of Battle Area (2.X.2.4.2.1)");
            renderableLayer.addRenderable(tacticalGraphic);
            list = Arrays.asList(Position.fromDegrees(35.2829, -117.59), Position.fromDegrees(35.299, -117.3727));
            tacticalGraphic = milStd2525GraphicFactory.createGraphic("GFGPGLC-------X", list, null);
            tacticalGraphic.setValue("gov.nasa.worldwind.avkey.DisplayName", "Line of Contact (2.X.2.1.2.3)");
            renderableLayer.addRenderable(tacticalGraphic);
            list = Arrays.asList(Position.fromDegrees(34.4179, -117.4399), Position.fromDegrees(34.4486, -117.6857));
            tacticalGraphic = milStd2525GraphicFactory.createGraphic("GFFPLCF-------X", list, null);
            tacticalGraphic.setModifier("T", Arrays.asList("X CORPS", "ALPHA"));
            tacticalGraphic.setModifier("W", Arrays.asList("202100Z", "270800Z SEP"));
            tacticalGraphic.setValue("gov.nasa.worldwind.avkey.DisplayName", "Fire Support Coordination Line (2.X.4.2.2.1)");
            renderableLayer.addRenderable(tacticalGraphic);
            list = Arrays.asList(Position.fromDegrees(34.7502, -118.198), Position.fromDegrees(34.8542, -118.2565), Position.fromDegrees(34.8515, -118.1129));
            tacticalGraphic = milStd2525GraphicFactory.createGraphic("GFGPDLP-------X", list, null);
            tacticalGraphic.setValue("gov.nasa.worldwind.avkey.DisplayName", "Principle Direction of Fire (2.X.2.4.2.2)");
            tacticalGraphic.setModifier("A", "SFGPEWRH--MTUSG");
            renderableLayer.addRenderable(tacticalGraphic);
            list = Arrays.asList(Position.fromDegrees(34.9738, -118.2632), Position.fromDegrees(34.9306, -118.1597), Position.fromDegrees(35.0092, -118.1717));
            tacticalGraphic = milStd2525GraphicFactory.createGraphic("GFGPGAS-------X", list, null);
            tacticalGraphic.setValue("gov.nasa.worldwind.avkey.DisplayName", "Search Area/Reconnaissance Area (2.X.2.1.3.9)");
            tacticalGraphic.setModifier("A", "SFGPEWRH--MTUSG");
            renderableLayer.addRenderable(tacticalGraphic);
            list = Arrays.asList(Position.fromDegrees(35.3401, -117.6356), Position.fromDegrees(35.3723, -117.529), Position.fromDegrees(35.3776, -117.4182));
            tacticalGraphic = milStd2525GraphicFactory.createGraphic("GFGPGLF-------X", list, null);
            tacticalGraphic.setValue("gov.nasa.worldwind.avkey.DisplayName", "Forward Line of Own Troops (2.X.2.1.2.2)");
            renderableLayer.addRenderable(tacticalGraphic);
            list = Arrays.asList(Position.fromDegrees(35.1143, -118.0609), Position.fromDegrees(35.0765, -118.2397));
            tacticalGraphic = milStd2525GraphicFactory.createGraphic("GHGPOLKA------X", list, null);
            tacticalGraphic.setValue("gov.nasa.worldwind.avkey.DisplayName", "Direction of Attack, Aviation (2.X.2.5.2.2.1)");
            renderableLayer.addRenderable(tacticalGraphic);
            list = Arrays.asList(Position.fromDegrees(35.2678, -118.0194), Position.fromDegrees(35.1504, -118.1822), Position.fromDegrees(35.2402, -118.0716));
            tacticalGraphic = milStd2525GraphicFactory.createGraphic("GFGPOLI-------X", list, null);
            tacticalGraphic.setValue("gov.nasa.worldwind.avkey.DisplayName", "Infiltration Lane (2.X.2.5.2.4)");
            tacticalGraphic.setText("CHARLIE");
            renderableLayer.addRenderable(tacticalGraphic);
            list = Arrays.asList(Position.fromDegrees(34.6377, -118.077), Position.fromDegrees(34.6413, -118.1572), Position.fromDegrees(34.6808, -118.21), Position.fromDegrees(34.6547, -118.0988));
            tacticalGraphic = milStd2525GraphicFactory.createGraphic("GFGPPA--------X", list, null);
            tacticalGraphic.setValue("gov.nasa.worldwind.avkey.DisplayName", "Axis of Advance for Feint (2.X.2.3.2)");
            tacticalGraphic.setText("GREEN");
            renderableLayer.addRenderable(tacticalGraphic);
            list = Arrays.asList(Position.fromDegrees(35.1184, -118.4377), Position.fromDegrees(35.0339, -118.4318), Position.fromDegrees(35.0843, -118.3376));
            tacticalGraphic = milStd2525GraphicFactory.createGraphic("GFGPSLH-------X", list, null);
            tacticalGraphic.setValue("gov.nasa.worldwind.avkey.DisplayName", "Holding Line (2.X.2.6.1.2)");
            tacticalGraphic.setText("ALPHA");
            renderableLayer.addRenderable(tacticalGraphic);
            list = Arrays.asList(Position.fromDegrees(35.0656, -118.0508), Position.fromDegrees(35.0383, -118.2275));
            tacticalGraphic = milStd2525GraphicFactory.createGraphic("GFGPPF--------X", list, null);
            tacticalGraphic.setValue("gov.nasa.worldwind.avkey.DisplayName", "Direction of Attack for Feint (2.X.2.3.3)");
            tacticalGraphic.setText("DAVID");
            renderableLayer.addRenderable(tacticalGraphic);
            this.setAttributes(renderableLayer, this.sharedAttrs, this.sharedPointAttrs);
        }

        protected void createAreaGraphics(RenderableLayer renderableLayer) {
            MilStd2525GraphicFactory milStd2525GraphicFactory = new MilStd2525GraphicFactory();
            List<Position> list = Arrays.asList(Position.fromDegrees(34.913, -117.1897), Position.fromDegrees(34.9789, -117.1368), Position.fromDegrees(34.9706, -116.99), Position.fromDegrees(34.9188, -116.9906));
            TacticalGraphic tacticalGraphic = milStd2525GraphicFactory.createGraphic("GHGPGAA----AUSX", list, null);
            tacticalGraphic.setValue("gov.nasa.worldwind.avkey.DisplayName", "Assembly Area (2.X.2.1.3.2)");
            tacticalGraphic.setText("Atlanta");
            renderableLayer.addRenderable(tacticalGraphic);
            list = Arrays.asList(Position.fromDegrees(34.7985, -117.1938), Position.fromDegrees(34.8358, -117.1282), Position.fromDegrees(34.8456, -117.0773), Position.fromDegrees(34.8159, -116.9723), Position.fromDegrees(34.7836, -117.101), Position.fromDegrees(34.7985, -117.1938));
            tacticalGraphic = milStd2525GraphicFactory.createGraphic("GHGPGAF----AUSX", list, null);
            tacticalGraphic.setValue("gov.nasa.worldwind.avkey.DisplayName", "Fortified Area (2.X.2.1.3.4)");
            renderableLayer.addRenderable(tacticalGraphic);
            list = Arrays.asList(Position.fromDegrees(34.9001, -117.4044), Position.fromDegrees(34.991, -117.3297), Position.fromDegrees(34.9851, -117.2224), Position.fromDegrees(34.9134, -117.267));
            tacticalGraphic = milStd2525GraphicFactory.createGraphic("GFGPGAZ----AUSX", list, null);
            tacticalGraphic.setValue("gov.nasa.worldwind.avkey.DisplayName", "Airfield Zone (2.X.2.1.3.11)");
            renderableLayer.addRenderable(tacticalGraphic);
            list = Arrays.asList(Position.fromDegrees(35.2331, -117.6217), Position.fromDegrees(35.2331, -117.3552), Position.fromDegrees(35.1998, -117.256), Position.fromDegrees(35.0851, -117.3604), Position.fromDegrees(35.0857, -117.6261));
            tacticalGraphic = milStd2525GraphicFactory.createGraphic("GFGPAAR----AUSX", list, null);
            tacticalGraphic.setValue("gov.nasa.worldwind.avkey.DisplayName", "Restricted Operations Zone (2.X.2.2.3.1)");
            tacticalGraphic.setText("(Unit ID)");
            tacticalGraphic.setModifier("W", Arrays.asList("180500Z", "180615Z"));
            tacticalGraphic.setModifier("X", Arrays.asList("2000 FT AGL", "3000 FT AGL"));
            renderableLayer.addRenderable(tacticalGraphic);
            list = Arrays.asList(Position.fromDegrees(34.7849, -117.3661), Position.fromDegrees(34.6715, -117.3738), Position.fromDegrees(34.6374, -117.3208), Position.fromDegrees(34.6549, -117.1448), Position.fromDegrees(34.7506, -117.1436));
            tacticalGraphic = milStd2525GraphicFactory.createGraphic("GFGPAAW----AUSX", list, null);
            tacticalGraphic.setValue("gov.nasa.worldwind.avkey.DisplayName", "Weapons Free Zone (2.X.2.2.3.5)");
            tacticalGraphic.setText("(Unit ID)");
            tacticalGraphic.setModifier("W", Arrays.asList("1000Z", "1300Z"));
            renderableLayer.addRenderable(tacticalGraphic);
            Position position = Position.fromDegrees(35.1108, -117.087);
            TacticalCircle tacticalCircle = milStd2525GraphicFactory.createCircle("GHFPATC-------X", position, 5000.0, null);
            tacticalCircle.setValue("gov.nasa.worldwind.avkey.DisplayName", "Circular Target (2.X.4.3.1.2)");
            tacticalCircle.setText("AG9999");
            renderableLayer.addRenderable(tacticalCircle);
            position = Position.fromDegrees(35.0295, -116.929);
            TacticalQuad tacticalQuad = milStd2525GraphicFactory.createQuad("GHFPATR-------X", Arrays.asList(position), null);
            tacticalQuad.setLength(8000.0);
            tacticalQuad.setWidth(4000.0);
            tacticalQuad.setText("AB0176");
            tacticalQuad.setValue("gov.nasa.worldwind.avkey.DisplayName", "Rectangular Target (2.X.4.3.1.1)");
            renderableLayer.addRenderable(tacticalQuad);
            position = Position.fromDegrees(35.2106, -117.0092);
            tacticalCircle = milStd2525GraphicFactory.createCircle("GFFPACPC------X", position, 5000.0, null);
            tacticalCircle.setValue("gov.nasa.worldwind.avkey.DisplayName", "Position Area for Artillery (2.X.4.3.2.6.2)");
            renderableLayer.addRenderable(tacticalCircle);
            list = Arrays.asList(Position.fromDegrees(35.252, -116.8968), Position.fromDegrees(35.2364, -116.8063));
            tacticalQuad = milStd2525GraphicFactory.createQuad("GFFPACPR------X", list, null);
            tacticalQuad.setWidth(5000.0);
            tacticalQuad.setValue("gov.nasa.worldwind.avkey.DisplayName", "Position Area for Artillery (2.X.4.3.2.6.1)");
            renderableLayer.addRenderable(tacticalQuad);
            position = Position.fromDegrees(34.6813, -116.9724);
            tacticalGraphic = milStd2525GraphicFactory.createGraphic("GFFPAXC-------X", Arrays.asList(position), null);
            tacticalGraphic.setModifier("AM", Arrays.asList(1000.0, 6000.0, 11000.0));
            tacticalGraphic.setModifier("X", Arrays.asList("GL", "GL", "GL"));
            tacticalGraphic.setValue("gov.nasa.worldwind.avkey.DisplayName", "Weapon/Sensor Range Fan (2.X.4.3.4.1)");
            tacticalGraphic.setModifier("A", "SFGPUCFH-------");
            renderableLayer.addRenderable(tacticalGraphic);
            List<Angle> list2 = Arrays.asList(Angle.fromDegrees(290.0), Angle.fromDegrees(30.0), Angle.fromDegrees(290.0), Angle.fromDegrees(30.0), Angle.fromDegrees(315.0), Angle.fromDegrees(30.0), Angle.fromDegrees(315.0), Angle.fromDegrees(35.0));
            position = Position.fromDegrees(34.5798, -116.6591);
            tacticalGraphic = milStd2525GraphicFactory.createGraphic("GFFPAXS-------X", Arrays.asList(position), null);
            tacticalGraphic.setModifier("AM", Arrays.asList(4000.0, 6000.0, 11000.0, 15000.0));
            tacticalGraphic.setModifier("AN", list2);
            tacticalGraphic.setModifier("X", Arrays.asList("GL", "GL", "GL", "GL"));
            tacticalGraphic.setValue("gov.nasa.worldwind.avkey.DisplayName", "Weapon/Sensor Range Fan (2.X.4.3.4.2)");
            tacticalGraphic.setModifier("A", "SFGPUCFTR------");
            renderableLayer.addRenderable(tacticalGraphic);
            list = Arrays.asList(Position.fromDegrees(34.9672, -116.8974), Position.fromDegrees(34.9188, -116.8205));
            tacticalGraphic = milStd2525GraphicFactory.createGraphic("GFFPACRR------X", list, null);
            tacticalGraphic.setModifier("AM", 5000.0);
            tacticalGraphic.setValue("gov.nasa.worldwind.avkey.DisplayName", "Restrictive Fire Area (2.X.4.3.2.5.2)");
            tacticalGraphic.setText("X CORPS");
            tacticalGraphic.setModifier("W", Arrays.asList("051030", "051600Z"));
            renderableLayer.addRenderable(tacticalGraphic);
            position = Position.fromDegrees(34.8208, -116.8284);
            tacticalGraphic = milStd2525GraphicFactory.createCircle("GFFPACSC------X", position, 5000.0, null);
            tacticalGraphic.setValue("gov.nasa.worldwind.avkey.DisplayName", "Fire Support Area (2.X.4.3.2.1.3)");
            tacticalGraphic.setText("GREEN");
            tacticalGraphic.setModifier("W", Arrays.asList("051030", "051600Z"));
            renderableLayer.addRenderable(tacticalGraphic);
            list = Arrays.asList(Position.fromDegrees(35.0592, -117.2903), Position.fromDegrees(35.062, -117.1606));
            tacticalGraphic = milStd2525GraphicFactory.createGraphic("GFFPACER------X", list, null);
            tacticalGraphic.setModifier("AM", 5000.0);
            tacticalGraphic.setValue("gov.nasa.worldwind.avkey.DisplayName", "Sensor Zone");
            tacticalGraphic.setText("Q37");
            tacticalGraphic.setModifier("W", Arrays.asList("051030", "051600Z"));
            renderableLayer.addRenderable(tacticalGraphic);
            list = Arrays.asList(Position.fromDegrees(35.1386, -116.9302), Position.fromDegrees(35.103, -116.9302), Position.fromDegrees(35.0731, -116.9561), Position.fromDegrees(35.062, -116.8345), Position.fromDegrees(35.1422, -116.8193));
            tacticalGraphic = milStd2525GraphicFactory.createGraphic("GFFPAZXI------X", list, null);
            tacticalGraphic.setValue("gov.nasa.worldwind.avkey.DisplayName", "Call for Fire Zone (2.X.4.3.3.2.1)");
            tacticalGraphic.setText("3BDE 4ID");
            tacticalGraphic.setModifier("W", Arrays.asList("051030", "051600Z"));
            renderableLayer.addRenderable(tacticalGraphic);
            list = Arrays.asList(Position.fromDegrees(35.016, -116.6625), Position.fromDegrees(35.0601, -116.6773), Position.fromDegrees(35.0542, -116.7611), Position.fromDegrees(35.0092, -116.779));
            tacticalGraphic = milStd2525GraphicFactory.createGraphic("GFFPATG-------X", list, null);
            tacticalGraphic.setValue("gov.nasa.worldwind.avkey.DisplayName", "Series or Group of Targets (2.X.4.3.1.3)");
            tacticalGraphic.setText("JEFF");
            renderableLayer.addRenderable(tacticalGraphic);
            list = Arrays.asList(Position.fromDegrees(35.126, -116.6625), Position.fromDegrees(35.1701, -116.6773), Position.fromDegrees(35.1642, -116.7611), Position.fromDegrees(35.1192, -116.779));
            tacticalGraphic = milStd2525GraphicFactory.createGraphic("GFGPSAA-------X", list, null);
            tacticalGraphic.setValue("gov.nasa.worldwind.avkey.DisplayName", "Airhead (2.X.2.6.2.2)");
            tacticalGraphic.setText("DELTA");
            renderableLayer.addRenderable(tacticalGraphic);
            list = Arrays.asList(Position.fromDegrees(34.9073, -116.7041), Position.fromDegrees(34.923, -116.6842), Position.fromDegrees(34.8723, -116.6841), Position.fromDegrees(34.887, -116.7783));
            tacticalGraphic = milStd2525GraphicFactory.createGraphic("GFMPNM--------X", list, null);
            tacticalGraphic.setValue("gov.nasa.worldwind.avkey.DisplayName", "Minimum Safe Distance Zones (2.X.3.4.1)");
            renderableLayer.addRenderable(tacticalGraphic);
            position = Position.fromDegrees(35.2132, -117.8042);
            tacticalCircle = milStd2525GraphicFactory.createCircle("GFGPAPU-------X", position, 2000.0, null);
            tacticalCircle.setValue("gov.nasa.worldwind.avkey.DisplayName", "Pull-Up Point (2.X.2.2.1.3)");
            renderableLayer.addRenderable(tacticalCircle);
            list = Arrays.asList(Position.fromDegrees(34.6297, -117.6718), Position.fromDegrees(34.5807, -117.5902), Position.fromDegrees(34.5344, -117.6686));
            tacticalGraphic = milStd2525GraphicFactory.createGraphic("GFGPOAF-------X", list, null);
            tacticalGraphic.setValue("gov.nasa.worldwind.avkey.DisplayName", "Attack by Fire Position (2.X.2.5.3.3)");
            renderableLayer.addRenderable(tacticalGraphic);
            list = Arrays.asList(Position.fromDegrees(34.6159, -117.8571), Position.fromDegrees(34.5775, -117.7887), Position.fromDegrees(34.6308, -117.8477), Position.fromDegrees(34.5837, -117.7725));
            tacticalGraphic = milStd2525GraphicFactory.createGraphic("GFGPOAS-------X", list, null);
            tacticalGraphic.setValue("gov.nasa.worldwind.avkey.DisplayName", "Support by Fire Position (2.X.2.5.3.4)");
            renderableLayer.addRenderable(tacticalGraphic);
            list = Arrays.asList(Position.fromDegrees(34.4916, -117.3427), Position.fromDegrees(34.577, -117.2273), Position.fromDegrees(34.5666, -117.092), Position.fromDegrees(34.4943, -117.0629), Position.fromDegrees(34.457, -117.1613), Position.fromDegrees(34.4508, -117.3106));
            tacticalGraphic = milStd2525GraphicFactory.createGraphic("GFMPNB--------X", list, null);
            tacticalGraphic.setValue("gov.nasa.worldwind.avkey.DisplayName", "Biologically Contaminated Area (2.X.3.4.5)");
            renderableLayer.addRenderable(tacticalGraphic);
            tacticalGraphic = milStd2525GraphicFactory.createPoint("GFMPNEB-------X", Position.fromDegrees(34.5059, -117.202), null);
            tacticalGraphic.setValue("gov.nasa.worldwind.avkey.DisplayName", "Biological Release Event (2.X.3.4.7.1)");
            tacticalGraphic.setShowLocation(false);
            renderableLayer.addRenderable(tacticalGraphic);
            this.setAttributes(renderableLayer, this.sharedAttrs, this.sharedPointAttrs);
            list = Arrays.asList(Position.fromDegrees(34.9684, -116.4864), Position.fromDegrees(34.9776, -116.6114), Position.fromDegrees(35.0271, -116.5614), Position.fromDegrees(35.0309, -116.4132));
            tacticalGraphic = milStd2525GraphicFactory.createGraphic("GHGPDAB----J--X", list, null);
            tacticalGraphic.setText("Blue");
            tacticalGraphic.setValue("gov.nasa.worldwind.avkey.DisplayName", "Battle Position, Prepared but not Occupied (2.X.2.4.3.1.1)");
            renderableLayer.addRenderable(tacticalGraphic);
            list = Arrays.asList(Position.fromDegrees(34.8166, -116.5491), Position.fromDegrees(34.8121, -116.5027), Position.fromDegrees(34.8182, -116.4528), Position.fromDegrees(34.8489, -116.4137), Position.fromDegrees(34.8848, -116.4246), Position.fromDegrees(34.905, -116.4664), Position.fromDegrees(34.908, -116.5246), Position.fromDegrees(34.8893, -116.5828), Position.fromDegrees(34.8495, -116.6091), Position.fromDegrees(34.8211, -116.5782));
            tacticalGraphic = milStd2525GraphicFactory.createGraphic("GHGPSAE-------X", list, null);
            tacticalGraphic.setValue("gov.nasa.worldwind.avkey.DisplayName", "Encirclement (2.X.2.6.2.3)");
            renderableLayer.addRenderable(tacticalGraphic);
            list = Arrays.asList(Position.fromDegrees(34.771, -116.4909), Position.fromDegrees(34.7764, -116.472), Position.fromDegrees(34.779, -116.421), Position.fromDegrees(34.7509, -116.3918), Position.fromDegrees(34.7285, -116.381), Position.fromDegrees(34.7066, -116.3831), Position.fromDegrees(34.6787, -116.4378), Position.fromDegrees(34.685, -116.49), Position.fromDegrees(34.7063, -116.5192), Position.fromDegrees(34.733, -116.517));
            tacticalGraphic = milStd2525GraphicFactory.createGraphic("GFMPNL--------X", list, null);
            tacticalGraphic.setValue("gov.nasa.worldwind.avkey.DisplayName", "Dose Rate Contour Line (2.X.3.4.9)");
            tacticalGraphic.setText("100 cGY");
            renderableLayer.addRenderable(tacticalGraphic);
            list = Arrays.asList(Position.fromDegrees(34.7504, -116.48), Position.fromDegrees(34.7552, -116.4637), Position.fromDegrees(34.7556, -116.4283), Position.fromDegrees(34.7469, -116.4137), Position.fromDegrees(34.7259, -116.4129), Position.fromDegrees(34.7091, -116.4138), Position.fromDegrees(34.7053, -116.428), Position.fromDegrees(34.7073, -116.4634), Position.fromDegrees(34.7149, -116.4891), Position.fromDegrees(34.7314, -116.4908));
            tacticalGraphic = milStd2525GraphicFactory.createGraphic("GFMPNL--------X", list, null);
            tacticalGraphic.setValue("gov.nasa.worldwind.avkey.DisplayName", "Dose Rate Contour Line (2.X.3.4.9)");
            tacticalGraphic.setText("300 cGY");
            renderableLayer.addRenderable(tacticalGraphic);
            list = Arrays.asList(Position.fromDegrees(35.1421, -116.5798), Position.fromDegrees(35.0979, -116.5971), Position.fromDegrees(35.0934, -116.4595), Position.fromDegrees(35.157, -116.4832));
            tacticalGraphic = milStd2525GraphicFactory.createGraphic("GFGPGAG-------X", list, null);
            tacticalGraphic.setValue("gov.nasa.worldwind.avkey.DisplayName", "General Area (2.X.2.1.3.1)");
            tacticalGraphic.setText("CHEM");
            renderableLayer.addRenderable(tacticalGraphic);
            list = Arrays.asList(Position.fromDegrees(35.1612, -116.4304), Position.fromDegrees(35.1358, -116.4955));
            tacticalGraphic = milStd2525GraphicFactory.createGraphic("GFGPGAY-------X", list, null);
            tacticalGraphic.setValue("gov.nasa.worldwind.avkey.DisplayName", "Limited Access Area (2.X.2.1.3.10)");
            tacticalGraphic.setModifier("A", "SFGPUCI--------");
            renderableLayer.addRenderable(tacticalGraphic);
            this.setAttributes(renderableLayer, this.sharedAttrs, this.sharedPointAttrs);
        }

        protected void setAttributes(RenderableLayer renderableLayer, TacticalGraphicAttributes tacticalGraphicAttributes, TacticalGraphicAttributes tacticalGraphicAttributes2) {
            for (Renderable renderable : renderableLayer.getRenderables()) {
                TacticalGraphic tacticalGraphic;
                if (renderable instanceof TacticalPoint) {
                    tacticalGraphic = (TacticalGraphic)renderable;
                    if (tacticalGraphic.getAttributes() != null) continue;
                    tacticalGraphic.setAttributes(tacticalGraphicAttributes2);
                    continue;
                }
                if (!(renderable instanceof TacticalGraphic) || (tacticalGraphic = (TacticalGraphic)renderable).getAttributes() != null) continue;
                tacticalGraphic.setAttributes(tacticalGraphicAttributes);
            }
        }

        protected void addGraphicControls() {
            Box box = Box.createVerticalBox();
            box.setBorder(BorderFactory.createEmptyBorder(20, 20, 20, 20));
            JLabel jLabel = new JLabel("Opacity");
            JSlider jSlider = new JSlider(0, 100, 100);
            jSlider.addChangeListener(new ChangeListener(){

                @Override
                public void stateChanged(ChangeEvent changeEvent) {
                    JSlider jSlider = (JSlider)changeEvent.getSource();
                    double d = (double)jSlider.getValue() / 100.0;
                    AppFrame.this.sharedAttrs.setInteriorOpacity(d);
                    AppFrame.this.sharedAttrs.setOutlineOpacity(d);
                    AppFrame.this.sharedPointAttrs.setInteriorOpacity(d);
                    AppFrame.this.sharedPointAttrs.setOutlineOpacity(d);
                    AppFrame.this.getWwd().redraw();
                }
            });
            box.add(Box.createVerticalStrut(10));
            jLabel.setAlignmentX(0.0f);
            jSlider.setAlignmentX(0.0f);
            box.add(jLabel);
            box.add(jSlider);
            JCheckBox jCheckBox = new JCheckBox("Text Modifiers", true);
            jCheckBox.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    boolean bl = ((JCheckBox)actionEvent.getSource()).isSelected();
                    this.setShowModifiers(AppFrame.this.pointLayer, bl);
                    this.setShowModifiers(AppFrame.this.lineLayer, bl);
                    this.setShowModifiers(AppFrame.this.areaLayer, bl);
                    AppFrame.this.getWwd().redraw();
                }

                protected void setShowModifiers(RenderableLayer renderableLayer, boolean bl) {
                    for (Renderable renderable : renderableLayer.getRenderables()) {
                        if (!(renderable instanceof TacticalGraphic)) continue;
                        ((TacticalGraphic)renderable).setShowTextModifiers(bl);
                    }
                }
            });
            jCheckBox.setAlignmentX(0.0f);
            box.add(Box.createVerticalStrut(10));
            box.add(jCheckBox);
            jCheckBox = new JCheckBox("Graphic Modifiers", true);
            jCheckBox.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    boolean bl = ((JCheckBox)actionEvent.getSource()).isSelected();
                    this.setShowModifiers(AppFrame.this.pointLayer, bl);
                    this.setShowModifiers(AppFrame.this.lineLayer, bl);
                    this.setShowModifiers(AppFrame.this.areaLayer, bl);
                    AppFrame.this.getWwd().redraw();
                }

                protected void setShowModifiers(RenderableLayer renderableLayer, boolean bl) {
                    for (Renderable renderable : renderableLayer.getRenderables()) {
                        if (!(renderable instanceof TacticalGraphic)) continue;
                        ((TacticalGraphic)renderable).setShowGraphicModifiers(bl);
                    }
                }
            });
            jCheckBox.setAlignmentX(0.0f);
            box.add(Box.createVerticalStrut(10));
            box.add(jCheckBox);
            jCheckBox = new JCheckBox("Hostile indicator", true);
            jCheckBox.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    boolean bl = ((JCheckBox)actionEvent.getSource()).isSelected();
                    this.setShowHostile(AppFrame.this.pointLayer, bl);
                    this.setShowHostile(AppFrame.this.lineLayer, bl);
                    this.setShowHostile(AppFrame.this.areaLayer, bl);
                    AppFrame.this.getWwd().redraw();
                }

                protected void setShowHostile(RenderableLayer renderableLayer, boolean bl) {
                    for (Renderable renderable : renderableLayer.getRenderables()) {
                        if (!(renderable instanceof TacticalGraphic)) continue;
                        ((TacticalGraphic)renderable).setShowHostileIndicator(bl);
                    }
                }
            });
            jCheckBox.setAlignmentX(0.0f);
            box.add(Box.createVerticalStrut(10));
            box.add(jCheckBox);
            this.getLayerPanel().add((Component)box, "South");
        }
    }
}

