/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwindx.examples;

import gov.nasa.worldwind.Factory;
import gov.nasa.worldwind.WorldWind;
import gov.nasa.worldwind.WorldWindow;
import gov.nasa.worldwind.avlist.AVList;
import gov.nasa.worldwind.avlist.AVListImpl;
import gov.nasa.worldwind.globes.ElevationModel;
import gov.nasa.worldwind.layers.Layer;
import gov.nasa.worldwind.layers.LayerList;
import gov.nasa.worldwind.ogc.wms.WMSCapabilities;
import gov.nasa.worldwind.ogc.wms.WMSLayerCapabilities;
import gov.nasa.worldwind.ogc.wms.WMSLayerStyle;
import gov.nasa.worldwind.terrain.CompoundElevationModel;
import gov.nasa.worldwind.util.WWUtil;
import gov.nasa.worldwindx.examples.ApplicationTemplate;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JScrollPane;
import javax.swing.border.CompoundBorder;
import javax.swing.border.TitledBorder;

public class WMSLayersPanel
extends JPanel {
    protected final WorldWindow wwd;
    protected final URI serverURI;
    protected final Dimension size;
    protected final Thread loadingThread;
    protected final TreeSet<LayerInfo> layerInfos = new TreeSet<LayerInfo>(new Comparator<LayerInfo>(){

        @Override
        public int compare(LayerInfo layerInfo, LayerInfo layerInfo2) {
            String string = layerInfo.getName();
            String string2 = layerInfo2.getName();
            return string.compareTo(string2);
        }
    });

    public WMSLayersPanel(WorldWindow worldWindow, String string, Dimension dimension) throws URISyntaxException {
        super(new BorderLayout());
        this.serverURI = new URI(string.trim());
        this.wwd = worldWindow;
        this.size = dimension;
        this.setPreferredSize(this.size);
        this.makeProgressPanel();
        this.loadingThread = new Thread(new Runnable(){

            @Override
            public void run() {
                WMSLayersPanel.this.load();
            }
        });
        this.loadingThread.setPriority(1);
        this.loadingThread.start();
    }

    protected void load() {
        WMSCapabilities wMSCapabilities;
        try {
            wMSCapabilities = WMSCapabilities.retrieve(this.serverURI);
            wMSCapabilities.parse(new Object[0]);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return;
        }
        List<WMSLayerCapabilities> list = wMSCapabilities.getNamedLayers();
        if (list == null) {
            return;
        }
        try {
            for (WMSLayerCapabilities wMSLayerCapabilities : list) {
                Set<WMSLayerStyle> set = wMSLayerCapabilities.getStyles();
                if (set == null || set.size() == 0) {
                    LayerInfo layerInfo = this.createLayerInfo(wMSCapabilities, wMSLayerCapabilities, null);
                    this.layerInfos.add(layerInfo);
                    continue;
                }
                for (WMSLayerStyle wMSLayerStyle : set) {
                    LayerInfo layerInfo = this.createLayerInfo(wMSCapabilities, wMSLayerCapabilities, wMSLayerStyle);
                    this.layerInfos.add(layerInfo);
                }
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return;
        }
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                WMSLayersPanel.this.removeAll();
                WMSLayersPanel.this.makeLayerInfosPanel(WMSLayersPanel.this.layerInfos);
            }
        });
    }

    public String getServerDisplayString() {
        return this.serverURI.getHost();
    }

    protected LayerInfo createLayerInfo(WMSCapabilities wMSCapabilities, WMSLayerCapabilities wMSLayerCapabilities, WMSLayerStyle wMSLayerStyle) {
        String string;
        LayerInfo layerInfo = new LayerInfo();
        layerInfo.caps = wMSCapabilities;
        layerInfo.params = new AVListImpl();
        layerInfo.params.setValue("gov.nasa.worldwind.avkey.LayerNames", wMSLayerCapabilities.getName());
        if (wMSLayerStyle != null) {
            layerInfo.params.setValue("gov.nasa.worldwind.avkey.StyleNames", wMSLayerStyle.getName());
        }
        if (!WWUtil.isEmpty(string = wMSLayerCapabilities.getLayerAbstract())) {
            layerInfo.params.setValue("gov.nasa.worldwind.avkey.LayerAbstract", string);
        }
        layerInfo.params.setValue("gov.nasa.worldwind.avkey.DisplayName", WMSLayersPanel.makeTitle(wMSCapabilities, layerInfo));
        return layerInfo;
    }

    protected void makeLayerInfosPanel(Collection<LayerInfo> collection) {
        JPanel jPanel = new JPanel(new GridLayout(0, 1, 0, 4));
        jPanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        for (LayerInfo object2 : collection) {
            this.addLayerInfoPanel(jPanel, this.wwd, object2);
        }
        JScrollPane jScrollPane = new JScrollPane(jPanel);
        jScrollPane.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        jScrollPane.setPreferredSize(this.size);
        JPanel jPanel2 = new JPanel(new GridLayout(0, 1, 0, 10));
        jPanel2.setBorder(new CompoundBorder(BorderFactory.createEmptyBorder(9, 9, 9, 9), new TitledBorder("Layers")));
        jPanel2.add(jScrollPane);
        this.add((Component)jPanel2, "Center");
        this.revalidate();
    }

    protected void addLayerInfoPanel(JPanel jPanel, WorldWindow worldWindow, LayerInfo layerInfo) {
        LayerInfoAction layerInfoAction = new LayerInfoAction(layerInfo, worldWindow);
        if (layerInfo.getAbstract() != null) {
            layerInfoAction.putValue("ShortDescription", layerInfo.getAbstract());
        }
        JCheckBox jCheckBox = new JCheckBox(layerInfoAction);
        jCheckBox.setSelected(false);
        jPanel.add(jCheckBox);
    }

    protected void updateComponent(Object object, boolean bl) {
        if (object instanceof Layer) {
            Layer layer = (Layer)object;
            LayerList layerList = this.wwd.getModel().getLayers();
            layer.setEnabled(bl);
            if (bl) {
                if (!layerList.contains(layer)) {
                    ApplicationTemplate.insertBeforePlacenames(this.wwd, layer);
                    this.firePropertyChange("LayersPanelUpdated", null, layer);
                }
            } else {
                layerList.remove(layer);
                this.firePropertyChange("LayersPanelUpdated", layer, null);
            }
        } else if (object instanceof ElevationModel) {
            ElevationModel elevationModel = (ElevationModel)object;
            CompoundElevationModel compoundElevationModel = (CompoundElevationModel)this.wwd.getModel().getGlobe().getElevationModel();
            if (bl && !compoundElevationModel.getElevationModels().contains(elevationModel)) {
                compoundElevationModel.addElevationModel(elevationModel);
            }
        }
    }

    protected static Object createComponent(WMSCapabilities wMSCapabilities, AVList aVList) {
        AVList aVList2 = aVList.copy();
        aVList2.setValue("gov.nasa.worldwind.avkey.URLConnectTimeout", 30000);
        aVList2.setValue("gov.nasa.worldwind.avkey.URLReadTimeout", 30000);
        aVList2.setValue("gov.nasa.worldwind.avkey.RetrievalStaleRequestLimit", 60000);
        try {
            String string = WMSLayersPanel.getFactoryKeyForCapabilities(wMSCapabilities);
            Factory factory = (Factory)WorldWind.createConfigurationComponent(string);
            return factory.createFromConfigSource(wMSCapabilities, aVList2);
        }
        catch (Exception exception) {
            return null;
        }
    }

    protected static String getFactoryKeyForCapabilities(WMSCapabilities wMSCapabilities) {
        boolean bl = false;
        Set<String> set = wMSCapabilities.getImageFormats();
        for (String string : set) {
            if (!string.contains("application/bil")) continue;
            bl = true;
            break;
        }
        return bl ? "gov.nasa.worldwind.avkey.ElevationModelFactory" : "gov.nasa.worldwind.avkey.LayerFactory";
    }

    protected static String makeTitle(WMSCapabilities wMSCapabilities, LayerInfo layerInfo) {
        String string = layerInfo.params.getStringValue("gov.nasa.worldwind.avkey.LayerNames");
        String string2 = layerInfo.params.getStringValue("gov.nasa.worldwind.avkey.StyleNames");
        String[] stringArray = string.split(",");
        String[] stringArray2 = string2 != null ? string2.split(",") : null;
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < stringArray.length; ++i) {
            String string3;
            WMSLayerStyle wMSLayerStyle;
            String string4;
            WMSLayerCapabilities wMSLayerCapabilities;
            String string5;
            if (stringBuilder.length() > 0) {
                stringBuilder.append(", ");
            }
            stringBuilder.append((string5 = (wMSLayerCapabilities = wMSCapabilities.getLayerByName(string4 = stringArray[i])).getTitle()) != null ? string5 : string4);
            if (stringArray2 == null || stringArray2.length <= i || (wMSLayerStyle = wMSLayerCapabilities.getStyleByName(string3 = stringArray2[i])) == null) continue;
            stringBuilder.append(" : ");
            String string6 = wMSLayerStyle.getTitle();
            stringBuilder.append(string6 != null ? string6 : string3);
        }
        return stringBuilder.toString();
    }

    protected void makeProgressPanel() {
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        jPanel.setPreferredSize(this.size);
        JPanel jPanel2 = new JPanel(new BorderLayout());
        jPanel2.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        JProgressBar jProgressBar = new JProgressBar();
        jProgressBar.setIndeterminate(true);
        jPanel2.add((Component)jProgressBar, "Center");
        JButton jButton = new JButton("Cancel");
        jPanel2.add((Component)jButton, "East");
        jButton.addActionListener(new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (WMSLayersPanel.this.loadingThread.isAlive()) {
                    WMSLayersPanel.this.loadingThread.interrupt();
                }
                Container container = WMSLayersPanel.this.getParent();
                container.remove(WMSLayersPanel.this);
            }
        });
        jPanel.add((Component)jPanel2, "North");
        this.add((Component)jPanel, "Center");
        this.revalidate();
    }

    protected class LayerInfoAction
    extends AbstractAction {
        protected WorldWindow wwd;
        protected LayerInfo layerInfo;
        protected Object component;

        public LayerInfoAction(LayerInfo layerInfo, WorldWindow worldWindow) {
            super(layerInfo.getTitle());
            this.wwd = worldWindow;
            this.layerInfo = layerInfo;
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (((JCheckBox)actionEvent.getSource()).isSelected()) {
                if (this.component == null) {
                    this.component = WMSLayersPanel.createComponent(this.layerInfo.caps, this.layerInfo.params);
                }
                WMSLayersPanel.this.updateComponent(this.component, true);
            } else if (this.component != null) {
                WMSLayersPanel.this.updateComponent(this.component, false);
            }
            this.wwd.redraw();
        }
    }

    protected static class LayerInfo {
        protected WMSCapabilities caps;
        protected AVListImpl params = new AVListImpl();

        protected LayerInfo() {
        }

        protected String getTitle() {
            return this.params.getStringValue("gov.nasa.worldwind.avkey.DisplayName");
        }

        protected String getName() {
            return this.params.getStringValue("gov.nasa.worldwind.avkey.LayerNames");
        }

        protected String getAbstract() {
            return this.params.getStringValue("gov.nasa.worldwind.avkey.LayerAbstract");
        }
    }
}

