/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwindx.examples;

import gov.nasa.worldwind.event.SelectEvent;
import gov.nasa.worldwind.event.SelectListener;
import gov.nasa.worldwind.formats.gpx.GpxReader;
import gov.nasa.worldwind.geom.Position;
import gov.nasa.worldwind.layers.MarkerLayer;
import gov.nasa.worldwind.pick.PickedObject;
import gov.nasa.worldwind.render.Material;
import gov.nasa.worldwind.render.markers.BasicMarker;
import gov.nasa.worldwind.render.markers.BasicMarkerAttributes;
import gov.nasa.worldwind.render.markers.Marker;
import gov.nasa.worldwind.util.WWIO;
import gov.nasa.worldwindx.examples.ApplicationTemplate;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import javax.xml.parsers.ParserConfigurationException;
import org.xml.sax.SAXException;

public class GPSTracks
extends ApplicationTemplate {
    protected static final String TRACK_PATH = "gov/nasa/worldwindx/examples/data/tuolumne.gpx";

    public static void main(String[] stringArray) {
        ApplicationTemplate.start("World Wind Tracks", AppFrame.class);
    }

    protected static class AppFrame
    extends ApplicationTemplate.AppFrame {
        public AppFrame() {
            super(true, true, false);
            MarkerLayer markerLayer = this.buildTracksLayer();
            ApplicationTemplate.insertBeforeCompass(this.getWwd(), markerLayer);
            this.getLayerPanel().update(this.getWwd());
            this.getWwd().addSelectListener(new SelectListener(){

                @Override
                public void selected(SelectEvent selectEvent) {
                    if (selectEvent.getTopObject() != null && selectEvent.getTopPickedObject().getParentLayer() instanceof MarkerLayer) {
                        PickedObject pickedObject = selectEvent.getTopPickedObject();
                        System.out.printf("Track position %s, %s, size = %f\n", pickedObject.getValue("gov.nasa.worldwind.avkey.PickedObject.ID").toString(), pickedObject.getPosition(), (Double)pickedObject.getValue("gov.nasa.worldwind.avkey.PickedObject.Size"));
                    }
                }
            });
        }

        protected MarkerLayer buildTracksLayer() {
            try {
                GpxReader gpxReader = new GpxReader();
                gpxReader.readStream(WWIO.openFileOrResourceStream(GPSTracks.TRACK_PATH, this.getClass()));
                Iterator<Position> iterator = gpxReader.getTrackPositionIterator();
                BasicMarkerAttributes basicMarkerAttributes = new BasicMarkerAttributes(Material.WHITE, "gov.nasa.worldwind.render.markers.Sphere", 1.0);
                ArrayList<Marker> arrayList = new ArrayList<Marker>();
                while (iterator.hasNext()) {
                    arrayList.add(new BasicMarker(iterator.next(), basicMarkerAttributes));
                }
                MarkerLayer markerLayer = new MarkerLayer(arrayList);
                markerLayer.setOverrideMarkerElevation(true);
                markerLayer.setElevation(0.0);
                markerLayer.setEnablePickSizeReturn(true);
                return markerLayer;
            }
            catch (ParserConfigurationException parserConfigurationException) {
                parserConfigurationException.printStackTrace();
            }
            catch (SAXException sAXException) {
                sAXException.printStackTrace();
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
            return null;
        }
    }
}

