/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwindx.examples;

import gov.nasa.worldwind.geom.LatLon;
import gov.nasa.worldwind.geom.Position;
import gov.nasa.worldwind.layers.RenderableLayer;
import gov.nasa.worldwind.render.BasicShapeAttributes;
import gov.nasa.worldwind.render.ExtrudedPolygon;
import gov.nasa.worldwind.render.Material;
import gov.nasa.worldwind.util.BasicDragger;
import gov.nasa.worldwindx.examples.ApplicationTemplate;
import java.util.ArrayList;

public class ExtrudedPolygons
extends ApplicationTemplate {
    public static void main(String[] stringArray) {
        ApplicationTemplate.start("World Wind Extruded Polygons", AppFrame.class);
    }

    public static class AppFrame
    extends ApplicationTemplate.AppFrame {
        public AppFrame() {
            super(true, true, false);
            this.getWwd().addSelectListener(new BasicDragger(this.getWwd()));
            RenderableLayer renderableLayer = new RenderableLayer();
            BasicShapeAttributes basicShapeAttributes = new BasicShapeAttributes();
            basicShapeAttributes.setInteriorMaterial(Material.MAGENTA);
            basicShapeAttributes.setOutlineOpacity(0.5);
            basicShapeAttributes.setInteriorOpacity(0.5);
            basicShapeAttributes.setOutlineMaterial(Material.GREEN);
            basicShapeAttributes.setOutlineWidth(2.0);
            basicShapeAttributes.setDrawOutline(true);
            basicShapeAttributes.setDrawInterior(true);
            basicShapeAttributes.setEnableLighting(true);
            BasicShapeAttributes basicShapeAttributes2 = new BasicShapeAttributes(basicShapeAttributes);
            basicShapeAttributes2.setOutlineMaterial(Material.WHITE);
            basicShapeAttributes2.setOutlineOpacity(1.0);
            BasicShapeAttributes basicShapeAttributes3 = new BasicShapeAttributes(basicShapeAttributes);
            basicShapeAttributes3.setInteriorMaterial(Material.YELLOW);
            basicShapeAttributes3.setInteriorOpacity(0.8);
            basicShapeAttributes3.setDrawInterior(true);
            basicShapeAttributes3.setEnableLighting(true);
            ArrayList<Position> arrayList = new ArrayList<Position>();
            arrayList.add(Position.fromDegrees(28.0, -106.0, 30000.0));
            arrayList.add(Position.fromDegrees(35.0, -104.0, 30000.0));
            arrayList.add(Position.fromDegrees(35.0, -107.0, 90000.0));
            arrayList.add(Position.fromDegrees(28.0, -107.0, 90000.0));
            arrayList.add(Position.fromDegrees(28.0, -106.0, 30000.0));
            ExtrudedPolygon extrudedPolygon = new ExtrudedPolygon(arrayList);
            arrayList.clear();
            arrayList.add(Position.fromDegrees(29.0, -106.4, 40000.0));
            arrayList.add(Position.fromDegrees(30.0, -106.4, 40000.0));
            arrayList.add(Position.fromDegrees(29.0, -106.8, 70000.0));
            arrayList.add(Position.fromDegrees(29.0, -106.4, 40000.0));
            extrudedPolygon.addInnerBoundary(arrayList);
            extrudedPolygon.setAltitudeMode(2);
            extrudedPolygon.setSideAttributes(basicShapeAttributes);
            extrudedPolygon.setSideHighlightAttributes(basicShapeAttributes2);
            extrudedPolygon.setCapAttributes(basicShapeAttributes3);
            renderableLayer.addRenderable(extrudedPolygon);
            ArrayList<LatLon> arrayList2 = new ArrayList<LatLon>();
            arrayList2.add(LatLon.fromDegrees(28.0, -110.0));
            arrayList2.add(LatLon.fromDegrees(35.0, -108.0));
            arrayList2.add(LatLon.fromDegrees(35.0, -111.0));
            arrayList2.add(LatLon.fromDegrees(28.0, -111.0));
            arrayList2.add(LatLon.fromDegrees(28.0, -110.0));
            extrudedPolygon = new ExtrudedPolygon(arrayList2, 60000.0);
            extrudedPolygon.setSideAttributes(basicShapeAttributes);
            extrudedPolygon.setSideHighlightAttributes(basicShapeAttributes2);
            extrudedPolygon.setCapAttributes(basicShapeAttributes3);
            renderableLayer.addRenderable(extrudedPolygon);
            ApplicationTemplate.insertBeforeCompass(this.getWwd(), renderableLayer);
            this.getLayerPanel().update(this.getWwd());
        }
    }
}

