/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwindx.examples;

import gov.nasa.worldwind.geom.Angle;
import gov.nasa.worldwind.geom.LatLon;
import gov.nasa.worldwind.geom.Sector;
import gov.nasa.worldwind.layers.RenderableLayer;
import gov.nasa.worldwind.render.AbstractSurfaceShape;
import gov.nasa.worldwind.render.BasicShapeAttributes;
import gov.nasa.worldwind.render.Material;
import gov.nasa.worldwind.render.SurfaceCircle;
import gov.nasa.worldwind.render.SurfaceEllipse;
import gov.nasa.worldwind.render.SurfacePolygon;
import gov.nasa.worldwind.render.SurfacePolyline;
import gov.nasa.worldwind.render.SurfaceQuad;
import gov.nasa.worldwind.render.SurfaceSector;
import gov.nasa.worldwind.render.SurfaceSquare;
import gov.nasa.worldwind.util.BasicDragger;
import gov.nasa.worldwind.util.WWUtil;
import gov.nasa.worldwindx.examples.ApplicationTemplate;
import java.awt.Color;
import java.util.Arrays;
import java.util.List;

public class DraggingShapes
extends ApplicationTemplate {
    public static void main(String[] stringArray) {
        ApplicationTemplate.start("World Wind Dragging Shapes", AppFrame.class);
    }

    protected static class AppFrame
    extends ApplicationTemplate.AppFrame {
        protected static final String SURFACE_POLYGON_IMAGE_PATH = "gov/nasa/worldwindx/examples/images/georss.png";

        public AppFrame() {
            this.getWwd().addSelectListener(new BasicDragger(this.getWwd()));
            this.makeShapes();
        }

        protected void makeShapes() {
            RenderableLayer renderableLayer = new RenderableLayer();
            renderableLayer.setName("Surface Shapes");
            BasicShapeAttributes basicShapeAttributes = new BasicShapeAttributes();
            basicShapeAttributes.setOutlineMaterial(Material.WHITE);
            basicShapeAttributes.setInteriorOpacity(0.5);
            basicShapeAttributes.setOutlineOpacity(0.8);
            basicShapeAttributes.setOutlineWidth(3.0);
            basicShapeAttributes.setImageSource(SURFACE_POLYGON_IMAGE_PATH);
            basicShapeAttributes.setImageScale(0.5);
            double d = 28.0;
            double d2 = -82.0;
            List<LatLon> list = Arrays.asList(LatLon.fromDegrees(d + 5.0, d2 + 2.5), LatLon.fromDegrees(d + 5.0, d2 - 2.5), LatLon.fromDegrees(d + 2.5, d2 - 5.0), LatLon.fromDegrees(d - 2.5, d2 - 5.0), LatLon.fromDegrees(d - 5.0, d2 - 2.5), LatLon.fromDegrees(d - 5.0, d2 + 2.5), LatLon.fromDegrees(d - 2.5, d2 + 5.0), LatLon.fromDegrees(d + 2.5, d2 + 5.0), LatLon.fromDegrees(d + 5.0, d2 + 2.5));
            AbstractSurfaceShape abstractSurfaceShape = new SurfacePolygon(list);
            abstractSurfaceShape.setAttributes(basicShapeAttributes);
            renderableLayer.addRenderable(abstractSurfaceShape);
            basicShapeAttributes = new BasicShapeAttributes();
            basicShapeAttributes.setInteriorMaterial(Material.RED);
            basicShapeAttributes.setOutlineMaterial(new Material(WWUtil.makeColorBrighter(Color.RED)));
            basicShapeAttributes.setInteriorOpacity(0.5);
            basicShapeAttributes.setOutlineOpacity(0.8);
            basicShapeAttributes.setOutlineWidth(3.0);
            list = Arrays.asList(LatLon.fromDegrees(20.0, -170.0), LatLon.fromDegrees(15.0, 170.0), LatLon.fromDegrees(10.0, -175.0), LatLon.fromDegrees(5.0, 170.0), LatLon.fromDegrees(0.0, -170.0), LatLon.fromDegrees(20.0, -170.0));
            abstractSurfaceShape = new SurfacePolygon(list);
            abstractSurfaceShape.setAttributes(basicShapeAttributes);
            renderableLayer.addRenderable(abstractSurfaceShape);
            basicShapeAttributes = new BasicShapeAttributes();
            basicShapeAttributes.setInteriorMaterial(Material.CYAN);
            basicShapeAttributes.setOutlineMaterial(new Material(WWUtil.makeColorBrighter(Color.CYAN)));
            basicShapeAttributes.setInteriorOpacity(0.5);
            basicShapeAttributes.setOutlineOpacity(0.8);
            basicShapeAttributes.setOutlineWidth(3.0);
            abstractSurfaceShape = new SurfaceEllipse(LatLon.fromDegrees(38.0, -104.0), 150000.0, 100000.0, Angle.fromDegrees(15.0));
            abstractSurfaceShape.setAttributes(basicShapeAttributes);
            renderableLayer.addRenderable(abstractSurfaceShape);
            basicShapeAttributes = new BasicShapeAttributes();
            basicShapeAttributes.setInteriorMaterial(Material.GREEN);
            basicShapeAttributes.setOutlineMaterial(new Material(WWUtil.makeColorBrighter(Color.GREEN)));
            basicShapeAttributes.setInteriorOpacity(0.5);
            basicShapeAttributes.setOutlineOpacity(0.8);
            basicShapeAttributes.setOutlineWidth(3.0);
            abstractSurfaceShape = new SurfaceCircle(LatLon.fromDegrees(36.0, -104.0), 100000.0);
            abstractSurfaceShape.setAttributes(basicShapeAttributes);
            renderableLayer.addRenderable(abstractSurfaceShape);
            abstractSurfaceShape = new SurfaceCircle(LatLon.fromDegrees(90.0, 0.0), 1000000.0);
            abstractSurfaceShape.setAttributes(basicShapeAttributes);
            renderableLayer.addRenderable(abstractSurfaceShape);
            basicShapeAttributes = new BasicShapeAttributes();
            basicShapeAttributes.setInteriorMaterial(Material.ORANGE);
            basicShapeAttributes.setOutlineMaterial(new Material(WWUtil.makeColorBrighter(Color.ORANGE)));
            basicShapeAttributes.setInteriorOpacity(0.5);
            basicShapeAttributes.setOutlineOpacity(0.8);
            basicShapeAttributes.setOutlineWidth(3.0);
            abstractSurfaceShape = new SurfaceQuad(LatLon.fromDegrees(42.0, -104.0), 100000.0, 130000.0, Angle.fromDegrees(20.0));
            abstractSurfaceShape.setAttributes(basicShapeAttributes);
            renderableLayer.addRenderable(abstractSurfaceShape);
            basicShapeAttributes = new BasicShapeAttributes();
            basicShapeAttributes.setInteriorMaterial(Material.MAGENTA);
            basicShapeAttributes.setOutlineMaterial(new Material(WWUtil.makeColorBrighter(Color.MAGENTA)));
            basicShapeAttributes.setInteriorOpacity(0.5);
            basicShapeAttributes.setOutlineOpacity(0.8);
            basicShapeAttributes.setOutlineWidth(3.0);
            abstractSurfaceShape = new SurfaceSquare(LatLon.fromDegrees(45.0, -104.0), 100000.0);
            abstractSurfaceShape.setAttributes(basicShapeAttributes);
            renderableLayer.addRenderable(abstractSurfaceShape);
            basicShapeAttributes = new BasicShapeAttributes();
            basicShapeAttributes.setInteriorMaterial(Material.YELLOW);
            basicShapeAttributes.setOutlineMaterial(new Material(WWUtil.makeColorBrighter(Color.YELLOW)));
            basicShapeAttributes.setInteriorOpacity(0.5);
            basicShapeAttributes.setOutlineOpacity(0.8);
            basicShapeAttributes.setOutlineWidth(3.0);
            abstractSurfaceShape = new SurfaceSector(new Sector(Angle.fromDegrees(41.0), Angle.fromDegrees(41.6), Angle.fromDegrees(-122.5), Angle.fromDegrees(-121.7)));
            abstractSurfaceShape.setAttributes(basicShapeAttributes);
            renderableLayer.addRenderable(abstractSurfaceShape);
            basicShapeAttributes = new BasicShapeAttributes();
            basicShapeAttributes.setInteriorMaterial(Material.CYAN);
            basicShapeAttributes.setOutlineMaterial(new Material(WWUtil.makeColorBrighter(Color.CYAN)));
            basicShapeAttributes.setInteriorOpacity(0.5);
            basicShapeAttributes.setOutlineOpacity(0.8);
            basicShapeAttributes.setOutlineWidth(3.0);
            abstractSurfaceShape = new SurfaceSector(new Sector(Angle.fromDegrees(38.9), Angle.fromDegrees(39.3), Angle.fromDegrees(-120.2), Angle.fromDegrees(-119.9)));
            abstractSurfaceShape.setAttributes(basicShapeAttributes);
            renderableLayer.addRenderable(abstractSurfaceShape);
            basicShapeAttributes = new BasicShapeAttributes();
            basicShapeAttributes.setOutlineMaterial(Material.RED);
            basicShapeAttributes.setOutlineWidth(3.0);
            basicShapeAttributes.setOutlineStippleFactor(2);
            list = Arrays.asList(LatLon.fromDegrees(-10.0, 170.0), LatLon.fromDegrees(-10.0, -170.0));
            abstractSurfaceShape = new SurfacePolyline(list);
            abstractSurfaceShape.setAttributes(basicShapeAttributes);
            ((SurfacePolyline)abstractSurfaceShape).setClosed(false);
            renderableLayer.addRenderable(abstractSurfaceShape);
            ApplicationTemplate.insertBeforeCompass(this.getWwd(), renderableLayer);
            this.getLayerPanel().update(this.getWwd());
        }
    }
}

