/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwindx.applications.worldwindow.features;

import gov.nasa.worldwindx.applications.worldwindow.core.Controller;
import gov.nasa.worldwindx.applications.worldwindow.core.Registry;
import gov.nasa.worldwindx.applications.worldwindow.features.AbstractFeature;
import gov.nasa.worldwindx.applications.worldwindow.features.Feature;
import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;

public class Graticule
extends AbstractFeature {
    private static final String FEATURE_TITLE = "Graticule";
    private static final String ICON_PATH = "gov/nasa/worldwindx/applications/worldwindow/images/lat-long-64x64.png";
    private Feature lastOneOn;

    public Graticule(Registry registry) {
        super(FEATURE_TITLE, "gov.nasa.worldwindx.applications.worldwindow.feature.Graticule", ICON_PATH, registry);
    }

    @Override
    public void initialize(Controller controller) {
        super.initialize(controller);
        this.addToToolBar();
        for (Feature feature : this.getGraticules()) {
            if (feature == null) continue;
            feature.addPropertyChangeListener(new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                    if (propertyChangeEvent.getPropertyName().equals("gov.nasa.worldwindx.applications.worldwindow.OnState") && ((Boolean)propertyChangeEvent.getNewValue()).booleanValue()) {
                        Feature[] featureArray;
                        Graticule.this.lastOneOn = (Feature)propertyChangeEvent.getSource();
                        for (Feature feature : featureArray = Graticule.this.getGraticules()) {
                            if (feature == null || feature == Graticule.this.lastOneOn) continue;
                            feature.turnOn(false);
                        }
                    }
                }
            });
        }
    }

    protected Feature[] getGraticules() {
        Feature feature = (Feature)this.controller.getRegisteredObject("gov.nasa.worldwindx.applications.worldwindow.feature.LatLonGraticule");
        Feature feature2 = (Feature)this.controller.getRegisteredObject("gov.nasa.worldwindx.applications.worldwindow.feature.UTMGraticule");
        return new Feature[]{feature, feature2};
    }

    @Override
    public boolean isOn() {
        Feature[] featureArray;
        if (!this.isEnabled()) {
            return false;
        }
        for (Feature feature : featureArray = this.getGraticules()) {
            if (feature == null || !feature.isOn()) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isTwoState() {
        return true;
    }

    @Override
    public void turnOn(boolean bl) {
        for (Feature feature : this.getGraticules()) {
            if (feature == null) continue;
            feature.turnOn(bl);
        }
    }

    @Override
    public void setEnabled(boolean bl) {
        super.setEnabled(bl);
        for (Feature feature : this.getGraticules()) {
            if (feature == null) continue;
            feature.setEnabled(bl);
        }
    }

    @Override
    protected void doActionPerformed(ActionEvent actionEvent) {
        if (this.isOn()) {
            this.turnOn(false);
        } else if (this.lastOneOn != null) {
            this.lastOneOn.turnOn(true);
        } else {
            Feature feature = (Feature)this.controller.getRegisteredObject("gov.nasa.worldwindx.applications.worldwindow.feature.LatLonGraticule");
            if (feature != null) {
                feature.turnOn(true);
            }
        }
        this.controller.redraw();
    }
}

