/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwindx.applications.worldwindow.features;

import gov.nasa.worldwind.layers.Layer;
import gov.nasa.worldwind.layers.LayerList;
import gov.nasa.worldwindx.applications.worldwindow.core.Controller;
import gov.nasa.worldwindx.applications.worldwindow.core.Registry;
import gov.nasa.worldwindx.applications.worldwindow.core.layermanager.LayerManager;
import gov.nasa.worldwindx.applications.worldwindow.core.layermanager.LayerPath;
import gov.nasa.worldwindx.applications.worldwindow.features.AbstractFeature;
import gov.nasa.worldwindx.applications.worldwindow.features.NetworkActivitySignal;
import gov.nasa.worldwindx.applications.worldwindow.util.LayerTree;
import gov.nasa.worldwindx.applications.worldwindow.util.Util;
import java.lang.reflect.InvocationTargetException;
import java.util.Iterator;
import java.util.logging.Level;
import javax.swing.SwingUtilities;

public abstract class AbstractApplicationFeature
extends AbstractFeature
implements NetworkActivitySignal.NetworkUser {
    protected boolean on;
    protected boolean autoSelectLayers;
    protected LayerList appLayers;
    protected Thread createLayersThread;

    protected abstract String getLayerGroupName();

    protected abstract void doCreateLayers();

    protected AbstractApplicationFeature(String string, String string2, String string3, Registry registry) {
        super(string, string2, string3, registry);
    }

    @Override
    public void initialize(Controller controller) {
        super.initialize(controller);
    }

    @Override
    public boolean hasNetworkActivity() {
        return this.createLayersThread != null && this.createLayersThread.isAlive();
    }

    @Override
    public boolean isOn() {
        return this.on;
    }

    protected void setOn(boolean bl) {
        this.on = bl;
    }

    public boolean isAutoSelectLayers() {
        return this.autoSelectLayers;
    }

    public void setAutoSelectLayers(boolean bl) {
        this.autoSelectLayers = bl;
    }

    public LayerList getAppLayers() {
        return this.appLayers != null ? this.appLayers : new LayerList();
    }

    protected void destroyLayers() {
        this.killPopulateLayerThread();
        if (this.appLayers == null) {
            return;
        }
        for (Layer layer : this.appLayers) {
            this.destroyLayer(layer);
        }
        this.appLayers.clear();
        this.appLayers = null;
    }

    protected void destroyLayer(Layer layer) {
        this.controller.getLayerManager().removeLayer(layer);
        this.appLayers.remove(layer);
        layer.dispose();
    }

    protected void killPopulateLayerThread() {
        if (this.createLayersThread != null && this.createLayersThread.isAlive()) {
            this.createLayersThread.interrupt();
            this.controller.getNetworkActivitySignal().removeNetworkUser(this);
            this.createLayersThread = null;
        }
    }

    protected void handleInterrupt() {
        if (Thread.currentThread().isInterrupted() && this.appLayers != null) {
            Util.getLogger().info("Data retrieval cancelled");
            this.destroyLayers();
        }
    }

    protected void removeLayers() {
        this.controller.getLayerManager().removeLayers(this.appLayers);
    }

    protected void createLayers() {
        if (this.appLayers == null) {
            this.appLayers = new LayerList();
            this.appLayers.setDisplayName(this.getLayerGroupName());
        }
        this.createLayersThread = new Thread(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                try {
                    AbstractApplicationFeature.this.doCreateLayers();
                    AbstractApplicationFeature.this.handleInterrupt();
                }
                catch (Throwable throwable) {
                    AbstractApplicationFeature.this.handleInterrupt();
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            AbstractApplicationFeature.this.controller.getNetworkActivitySignal().removeNetworkUser(AbstractApplicationFeature.this);
                            AbstractApplicationFeature.this.createLayersThread = null;
                        }
                    });
                    throw throwable;
                }
                SwingUtilities.invokeLater(new /* invalid duplicate definition of identical inner class */);
            }
        });
        this.createLayersThread.setPriority(1);
        this.createLayersThread.start();
        this.controller.getNetworkActivitySignal().addNetworkUser(this);
    }

    protected void addLayer(final Layer layer, final LayerPath layerPath) {
        try {
            if (SwingUtilities.isEventDispatchThread()) {
                this.doAddLayer(layer, layerPath);
            } else {
                SwingUtilities.invokeAndWait(new Runnable(){

                    @Override
                    public void run() {
                        AbstractApplicationFeature.this.doAddLayer(layer, layerPath);
                    }
                });
            }
        }
        catch (InterruptedException interruptedException) {
        }
        catch (InvocationTargetException invocationTargetException) {
            Util.getLogger().log(Level.WARNING, "Invocation target exception", invocationTargetException);
        }
    }

    protected void doAddLayer(Layer layer, LayerPath layerPath) {
        LayerManager layerManager = this.controller.getLayerManager();
        Layer layer2 = layerManager.getLayerFromPath(layerPath);
        if (layer2 != null) {
            this.controller.getLayerManager().removeLayer(layerPath);
            this.appLayers.remove(layer2);
        }
        this.appLayers.add(layer);
        layerManager.addLayer(layer, layerPath.lastButOne());
        layerManager.selectLayer(layer, this.isAutoSelectLayers());
        layerManager.expandPath(layerPath.lastButOne());
    }

    protected void addLayers(LayerList layerList) {
        for (Layer layer : layerList) {
            this.addLayer(layer, new LayerPath(layerList.getDisplayName(), layer.getName()));
        }
    }

    protected LayerTree addLayerTree(LayerTree layerTree) {
        LayerPath layerPath = new LayerPath(this.getLayerGroupName(), new String[0]);
        Iterator<LayerPath> iterator = layerTree.getPathIterator(layerPath);
        while (iterator.hasNext()) {
            LayerPath layerPath2 = iterator.next();
            Layer layer = layerTree.getLayer(layerPath2);
            this.addLayer(layer, layerPath2);
        }
        return layerTree;
    }
}

