/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwindx.applications.worldwindow.core;

import gov.nasa.worldwind.render.DrawContext;
import gov.nasa.worldwind.render.ScreenAnnotation;
import java.awt.Color;
import java.awt.Font;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;

public class ToolTipAnnotation
extends ScreenAnnotation {
    private Point tooltipOffset = new Point(5, 5);

    public ToolTipAnnotation(String string) {
        super(string, new Point(0, 0));
        this.initializeAttributes();
    }

    protected void initializeAttributes() {
        this.attributes.setAdjustWidthToText("gov.nasa.worldwind.avkey.SizeFitText");
        this.attributes.setFrameShape("gov.nasa.worldwind.avkey.ShapeRectangle");
        this.attributes.setTextColor(Color.BLACK);
        this.attributes.setBackgroundColor(new Color(1.0f, 1.0f, 1.0f, 0.8f));
        this.attributes.setCornerRadius(5);
        this.attributes.setBorderColor(new Color(0xABABAB));
        this.attributes.setFont(Font.decode("Arial-PLAIN-12"));
        this.attributes.setTextAlign("gov.nasa.worldwind.avkey.Center");
        this.attributes.setInsets(new Insets(5, 5, 5, 5));
    }

    public Point getTooltipOffset() {
        return this.tooltipOffset;
    }

    public void setTooltipOffset(Point point) {
        this.tooltipOffset = point;
    }

    protected int getOffsetX() {
        return this.tooltipOffset != null ? this.tooltipOffset.x : 0;
    }

    protected int getOffsetY() {
        return this.tooltipOffset != null ? this.tooltipOffset.y : 0;
    }

    @Override
    protected void doRenderNow(DrawContext drawContext) {
        if (drawContext.getPickPoint() == null) {
            return;
        }
        this.getAttributes().setDrawOffset(new Point(this.getBounds((DrawContext)drawContext).width / 2 + this.getOffsetX(), this.getOffsetY()));
        this.setScreenPoint(this.adjustDrawPointToViewport(drawContext.getPickPoint(), this.getBounds(drawContext), drawContext.getView().getViewport()));
        super.doRenderNow(drawContext);
    }

    protected Point adjustDrawPointToViewport(Point point, Rectangle rectangle, Rectangle rectangle2) {
        int n = point.x;
        int n2 = (int)rectangle2.getHeight() - point.y - 1;
        if ((double)(n + this.getOffsetX()) + rectangle.getWidth() > rectangle2.getWidth()) {
            n = (int)(rectangle2.getWidth() - rectangle.getWidth()) - 1 - this.getOffsetX();
        } else if (n < 0) {
            n = 0;
        }
        if ((double)(n2 + this.getOffsetY()) + rectangle.getHeight() > rectangle2.getHeight()) {
            n2 = (int)(rectangle2.getHeight() - rectangle.getHeight()) - 1 - this.getOffsetY();
        } else if (n2 < 0) {
            n2 = rectangle.height;
        }
        return new Point(n, n2);
    }
}

