/*
 * Decompiled with CFR 0.152.
 */
package oms3.compiler;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import javax.tools.JavaFileManager;
import javax.tools.JavaFileObject;
import javax.tools.StandardLocation;

public class JavaFileManagerClassLoader
extends ClassLoader {
    JavaFileManager fileManager;

    public JavaFileManagerClassLoader(JavaFileManager fileManager, ClassLoader parent) {
        super(parent);
        if (fileManager == null) {
            throw new NullPointerException("fileManager");
        }
        this.fileManager = fileManager;
    }

    @Override
    protected Class<?> findClass(String name) throws ClassNotFoundException {
        try {
            JavaFileObject classFile = this.fileManager.getJavaFileForInput(StandardLocation.CLASS_OUTPUT, name, JavaFileObject.Kind.CLASS);
            if (classFile != null) {
                byte[] classData = this.readClassData(classFile);
                return this.defineClass(name, classData, 0, classData.length);
            }
            return super.findClass(name);
        }
        catch (IOException e) {
            throw new ClassNotFoundException(name, e);
        }
    }

    private byte[] readClassData(JavaFileObject classFile) throws IOException {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        byte[] buf = new byte[4096];
        InputStream classStream = classFile.openInputStream();
        int n = classStream.read(buf);
        while (n > 0) {
            bos.write(buf, 0, n);
            n = classStream.read(buf);
        }
        classStream.close();
        return bos.toByteArray();
    }
}

