/*
 * Decompiled with CFR 0.152.
 */
package jams.gui.input;

import jams.JAMS;
import jams.gui.HelpDlg;
import jams.gui.tools.GUIHelper;
import jams.meta.HelpComponent;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.Observable;
import java.util.Observer;
import java.util.Vector;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;

public class ListInput
extends JPanel {
    private static ImageIcon UP_ICON = new ImageIcon(new ImageIcon(ClassLoader.getSystemResource("resources/images/arrowup.png")).getImage().getScaledInstance(10, 5, 4));
    private static ImageIcon DOWN_ICON = new ImageIcon(new ImageIcon(ClassLoader.getSystemResource("resources/images/arrowdown.png")).getImage().getScaledInstance(10, 5, 4));
    static final int BUTTON_SIZE = 20;
    private static final Dimension BUTTON_DIMENSION = new Dimension(20, 20);
    private JList listbox;
    private JButton addButton;
    private JButton removeButton;
    private JButton upButton;
    private JButton downButton;
    private JButton editButton;
    private JButton helpButton;
    protected JScrollPane scrollPane;
    protected ListData listData = new ListData();
    protected MouseListener editListener;
    protected HelpComponent help;

    public ListInput() {
        this(true);
    }

    public ListInput(boolean orderButtons) {
        this(orderButtons, true);
    }

    public ListInput(boolean orderButtons, boolean editButtons) {
        this(orderButtons, editButtons, null);
    }

    public ListInput(boolean orderButtons, boolean editButtons, String helpResource) {
        if (helpResource != null) {
            this.help = JAMS.getHelpDocument(helpResource);
        }
        BorderLayout layout = new BorderLayout();
        layout.setHgap(5);
        this.setLayout(layout);
        this.listbox = new JList<Object>(this.listData.getValue());
        this.listbox.setSelectionMode(0);
        this.editListener = new MouseListener(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() > 1) {
                    ListInput.this.editItem();
                }
            }

            @Override
            public void mousePressed(MouseEvent e) {
            }

            @Override
            public void mouseReleased(MouseEvent e) {
            }

            @Override
            public void mouseEntered(MouseEvent e) {
            }

            @Override
            public void mouseExited(MouseEvent e) {
            }
        };
        this.listbox.addMouseListener(this.editListener);
        this.scrollPane = new JScrollPane();
        this.scrollPane.getViewport().add(this.getListbox());
        this.add((Component)this.scrollPane, "Center");
        JPanel buttonPanel = new JPanel();
        buttonPanel.setPreferredSize(new Dimension(20, 20));
        buttonPanel.setLayout(new FlowLayout());
        this.add((Component)buttonPanel, "East");
        this.addButton = new JButton("+");
        this.addButton.setMargin(new Insets(0, 1, 1, 0));
        this.addButton.setPreferredSize(BUTTON_DIMENSION);
        buttonPanel.add(this.addButton);
        this.addButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                ListInput.this.addItem();
            }
        });
        this.removeButton = new JButton("-");
        this.removeButton.setMargin(new Insets(0, 1, 1, 0));
        this.removeButton.setPreferredSize(BUTTON_DIMENSION);
        buttonPanel.add(this.removeButton);
        this.removeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                ListInput.this.removeItem();
            }
        });
        if (editButtons) {
            this.editButton = new JButton("...");
            this.editButton.setMargin(new Insets(0, 1, 1, 0));
            this.editButton.setPreferredSize(BUTTON_DIMENSION);
            this.editButton.setToolTipText(JAMS.i18n("Edit"));
            buttonPanel.add(this.editButton);
            this.editButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ListInput.this.editItem();
                }
            });
        }
        if (orderButtons) {
            this.upButton = new JButton();
            this.upButton.setMargin(new Insets(0, 1, 1, 0));
            this.upButton.setPreferredSize(BUTTON_DIMENSION);
            this.upButton.setToolTipText(JAMS.i18n("Move_up"));
            this.upButton.setIcon(UP_ICON);
            this.upButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ListInput.this.moveUp();
                }
            });
            this.downButton = new JButton();
            this.downButton.setMargin(new Insets(0, 1, 1, 0));
            this.downButton.setPreferredSize(BUTTON_DIMENSION);
            this.downButton.setToolTipText(JAMS.i18n("Move_down"));
            this.downButton.setIcon(DOWN_ICON);
            this.downButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ListInput.this.moveDown();
                }
            });
            buttonPanel.add(this.upButton);
            buttonPanel.add(this.downButton);
        }
        if (this.help != null) {
            this.helpButton = new JButton("?");
            this.helpButton.setMargin(new Insets(0, 1, 1, 0));
            this.helpButton.setPreferredSize(BUTTON_DIMENSION);
            this.helpButton.setToolTipText(JAMS.i18n("Help"));
            this.helpButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    HelpDlg helpDlg = new HelpDlg(null);
                    helpDlg.load(ListInput.this.help);
                    helpDlg.setVisible(true);
                }
            });
            buttonPanel.add(this.helpButton);
        }
    }

    protected void moveUp() {
        int index = this.listbox.getSelectedIndex();
        if (index > 0) {
            Object tmp = this.listData.getElementAt(index - 1);
            this.listData.setElementAt(index - 1, this.listData.getElementAt(index));
            this.listData.setElementAt(index, tmp);
            this.listbox.setSelectedIndex(index - 1);
            this.listbox.updateUI();
        }
    }

    protected void moveDown() {
        int index = this.listbox.getSelectedIndex();
        if (index < this.listData.getValue().size() - 1) {
            Object tmp = this.listData.getElementAt(index + 1);
            this.listData.setElementAt(index + 1, this.listData.getElementAt(index));
            this.listData.setElementAt(index, tmp);
            this.listbox.setSelectedIndex(index + 1);
            this.listbox.updateUI();
        }
    }

    public void addListDataObserver(Observer obs) {
        this.listData.addObserver(obs);
    }

    public void setListData(Vector<Object> listData) {
        this.listData.setValue(listData);
        this.scrollPane.revalidate();
        this.scrollPane.repaint();
    }

    public void revalidateScroll() {
        this.scrollPane.revalidate();
        this.scrollPane.repaint();
    }

    public Vector<Object> getListData() {
        return this.listData.getValue();
    }

    public Object getSelectedString() {
        int selection = this.getListbox().getSelectedIndex();
        if (selection >= 0) {
            return this.listData.getValue().elementAt(selection);
        }
        return null;
    }

    public JList getListbox() {
        return this.listbox;
    }

    @Override
    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        this.getListbox().setEnabled(enabled);
        this.addButton.setEnabled(enabled);
        this.removeButton.setEnabled(enabled);
        if (this.editButton != null) {
            this.editButton.setEnabled(enabled);
        }
        if (this.upButton != null) {
            this.upButton.setEnabled(enabled);
        }
        if (this.downButton != null) {
            this.downButton.setEnabled(enabled);
        }
    }

    protected void addItem() {
        String stringValue = GUIHelper.showInputDlg(this, null, JAMS.i18n("New_value"), null);
        if (stringValue != null && !this.listData.getValue().contains(stringValue)) {
            this.listData.addElement(stringValue);
            this.scrollPane.revalidate();
            this.scrollPane.repaint();
        }
    }

    protected void removeItem() {
        int selection = this.getListbox().getSelectedIndex();
        if (selection >= 0) {
            this.listData.removeElementAt(selection);
            this.scrollPane.revalidate();
            this.scrollPane.repaint();
            if (selection >= this.listData.getValue().size()) {
                selection = this.listData.getValue().size() - 1;
            }
            this.getListbox().setSelectedIndex(selection);
        }
    }

    protected void editItem() {
        int selection = this.getListbox().getSelectedIndex();
        if (selection >= 0) {
            Object value = this.listData.getElementAt(selection);
            value = GUIHelper.showInputDlg(this, null, JAMS.i18n("New_value"), value.toString());
            if (value != null) {
                this.listData.setElementAt(selection, value);
                this.scrollPane.revalidate();
                this.scrollPane.repaint();
            }
        }
    }

    protected class ListData
    extends Observable {
        private Vector<Object> listData = new Vector();

        protected ListData() {
        }

        public void addElement(Object s) {
            this.listData.addElement(s);
            ListInput.this.getListbox().setListData(this.listData);
            ListInput.this.getListbox().setSelectedValue(s, true);
            this.setChanged();
            this.notifyObservers();
        }

        public void removeElementAt(int selection) {
            this.listData.removeElementAt(selection);
            ListInput.this.getListbox().setListData(this.listData);
            this.setChanged();
            this.notifyObservers();
        }

        public Object getElementAt(int selection) {
            return this.listData.get(selection);
        }

        public void setElementAt(int selection, Object s) {
            this.listData.set(selection, s);
        }

        public Vector<Object> getValue() {
            return this.listData;
        }

        public void setValue(Vector<Object> listData) {
            this.listData = listData;
            ListInput.this.getListbox().setListData(listData);
            this.setChanged();
            this.notifyObservers();
        }
    }
}

