/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.referencing.piecewise;

import org.geotools.referencing.piecewise.DomainElement1D;
import org.geotools.referencing.piecewise.PiecewiseUtilities;
import org.geotools.renderer.i18n.Errors;
import org.geotools.util.NumberRange;
import org.geotools.util.SimpleInternationalString;
import org.geotools.util.Utilities;
import org.opengis.util.InternationalString;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultDomainElement1D
implements DomainElement1D {
    private static final long serialVersionUID = -2520449231656622013L;
    private InternationalString name;
    private double inputMinimum;
    private double inputMaximum;
    private NumberRange<? extends Number> range;
    private boolean inputMinimumInf;
    private boolean inputMaximumInf;
    private boolean inputMaximumNaN;
    private boolean inputMinimumNaN;
    private int hashCode = -1;

    @Override
    public int compareTo(DomainElement1D o) {
        if (o instanceof DefaultDomainElement1D) {
            return new Double(this.inputMinimum).compareTo(((DefaultDomainElement1D)o).inputMinimum);
        }
        return new Double(this.inputMinimum).compareTo(o.getRange().getMinimum());
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof DefaultDomainElement1D) {
            return false;
        }
        DefaultDomainElement1D that = (DefaultDomainElement1D)obj;
        if (this.getEquivalenceClass() != that.getEquivalenceClass()) {
            return false;
        }
        if (!Utilities.equals((double)this.inputMinimum, (double)that.inputMinimum)) {
            return false;
        }
        if (!Utilities.equals((double)this.inputMaximum, (double)that.inputMaximum)) {
            return false;
        }
        if (!Utilities.equals((Object)this.name, (Object)that.name)) {
            return false;
        }
        return Utilities.equals(this.range, that.range);
    }

    protected Class<?> getEquivalenceClass() {
        return DefaultDomainElement1D.class;
    }

    @Override
    public boolean contains(Number value) {
        return this.range.contains(value);
    }

    @Override
    public boolean contains(NumberRange<? extends Number> range) {
        return range.contains(range);
    }

    @Override
    public boolean contains(double value) {
        return value <= this.inputMaximum && value >= this.inputMinimum || Double.doubleToRawLongBits(value) == Double.doubleToRawLongBits(this.inputMinimum);
    }

    public DefaultDomainElement1D(CharSequence name, NumberRange<?> inputRange) throws IllegalArgumentException {
        PiecewiseUtilities.ensureNonNull("name", name);
        PiecewiseUtilities.ensureNonNull("range", inputRange);
        this.name = SimpleInternationalString.wrap((CharSequence)name);
        this.range = inputRange;
        Class type = inputRange.getElementClass();
        boolean minInc = inputRange.isMinIncluded();
        boolean maxInc = inputRange.isMaxIncluded();
        double tempMin = inputRange.getMinimum();
        double tempMax = inputRange.getMaximum();
        if (Double.isInfinite(tempMin)) {
            this.inputMinimum = tempMin;
            this.inputMinimumInf = true;
        } else {
            this.inputMinimum = PiecewiseUtilities.doubleValue(type, (Number)((Object)inputRange.getMinValue()), minInc ? 0 : 1);
        }
        if (Double.isInfinite(tempMax)) {
            this.inputMaximum = tempMax;
            this.inputMaximumInf = true;
        } else {
            this.inputMaximum = PiecewiseUtilities.doubleValue(type, (Number)((Object)inputRange.getMaxValue()), maxInc ? 0 : -1);
        }
        this.inputMinimumNaN = Double.isNaN(this.inputMinimum);
        this.inputMaximumNaN = Double.isNaN(this.inputMaximum);
        if (this.inputMinimumNaN && !this.inputMaximumNaN || !this.inputMinimumNaN && this.inputMaximumNaN) {
            throw new IllegalArgumentException(Errors.format(14, inputRange.getMinValue(), inputRange.getMaxValue()));
        }
    }

    public int hashCode() {
        if (this.hashCode >= 0) {
            return this.hashCode;
        }
        this.hashCode = 37;
        this.hashCode = Utilities.hash((Object)this.name, (int)this.hashCode);
        this.hashCode = Utilities.hash(this.range, (int)this.hashCode);
        this.hashCode = Utilities.hash((double)this.inputMaximum, (int)this.hashCode);
        this.hashCode = Utilities.hash((double)this.inputMinimum, (int)this.hashCode);
        return this.hashCode;
    }

    @Override
    public InternationalString getName() {
        return this.name;
    }

    public double getInputMaximum() {
        return this.inputMaximum;
    }

    public boolean isInputMaximumInfinite() {
        return this.inputMaximumInf;
    }

    public boolean isInputMaximumNaN() {
        return this.inputMaximumNaN;
    }

    public double getInputMinimum() {
        return this.inputMinimum;
    }

    public boolean isInputMinimumInfinite() {
        return this.inputMinimumInf;
    }

    @Override
    public NumberRange<? extends Number> getRange() {
        return this.range;
    }

    public boolean isInputMinimumNaN() {
        return this.inputMinimumNaN;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer("Domain description:");
        buffer.append("\n").append("name=").append((CharSequence)this.name);
        buffer.append("\n").append("input range=").append(this.range);
        return buffer.toString();
    }
}

