/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.iosp.bufr;

import java.io.IOException;
import javax.annotation.concurrent.Immutable;
import ucar.nc2.iosp.bufr.BufrNumbers;
import ucar.unidata.io.RandomAccessFile;

@Immutable
public class BufrIndicatorSection {
    private final long startPos;
    private final int bufrLength;
    private final int edition;

    public BufrIndicatorSection(RandomAccessFile raf) throws IOException {
        this.startPos = raf.getFilePointer() - 4L;
        this.bufrLength = BufrNumbers.uint3(raf);
        this.edition = raf.read();
    }

    public final int getBufrLength() {
        return this.bufrLength;
    }

    public final int getBufrEdition() {
        return this.edition;
    }

    public final long getStartPos() {
        return this.startPos;
    }
}

