/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.filter;

import java.util.Map;
import ucar.nc2.filter.Filter;
import ucar.nc2.filter.FilterProvider;

public class Shuffle
extends Filter {
    private int elemSize;
    private static final int DEFAULT_SIZE = 4;

    public Shuffle(Map<String, Object> properties) {
        try {
            this.elemSize = (Integer)properties.get("elementsize");
        }
        catch (Exception ex) {
            this.elemSize = 4;
        }
    }

    @Override
    public byte[] encode(byte[] dataIn) {
        if (dataIn.length % this.elemSize != 0 || this.elemSize <= 1) {
            return dataIn;
        }
        int nElems = dataIn.length / this.elemSize;
        int[] start = new int[this.elemSize];
        for (int k = 0; k < this.elemSize; ++k) {
            start[k] = k * nElems;
        }
        byte[] result = new byte[dataIn.length];
        for (int i = 0; i < nElems; ++i) {
            for (int j = 0; j < this.elemSize; ++j) {
                result[i + start[j]] = dataIn[i * this.elemSize + j];
            }
        }
        return result;
    }

    @Override
    public byte[] decode(byte[] dataIn) {
        if (dataIn.length % this.elemSize != 0 || this.elemSize <= 1) {
            return dataIn;
        }
        int nElems = dataIn.length / this.elemSize;
        int[] start = new int[this.elemSize];
        for (int k = 0; k < this.elemSize; ++k) {
            start[k] = k * nElems;
        }
        byte[] result = new byte[dataIn.length];
        for (int i = 0; i < nElems; ++i) {
            for (int j = 0; j < this.elemSize; ++j) {
                result[i * this.elemSize + j] = dataIn[i + start[j]];
            }
        }
        return result;
    }

    public static class Provider
    implements FilterProvider {
        private static final String name = "shuffle";
        private static final int id = -1;

        @Override
        public String getName() {
            return name;
        }

        @Override
        public int getId() {
            return -1;
        }

        @Override
        public Filter create(Map<String, Object> properties) {
            return new Shuffle(properties);
        }
    }
}

