/*
 * Decompiled with CFR 0.152.
 */
package ucar.mcidas;

import ucar.mcidas.AREAnav;

public class GVARnav
extends AREAnav {
    private boolean isEastPositive = true;
    final double DEG = 57.29577951308232;
    final double RAD = Math.PI / 180;
    final double NOMORB = 42164.365;
    final double AE = 6378.137;
    final double FER = 0.003352656112592056;
    final float AEBE2 = (float)(1.0 / Math.pow(0.9966473438874079, 2.0));
    final float AEBE3 = this.AEBE2 - 1.0f;
    final float AEBE4 = (float)Math.pow(0.9966473438874079, 4.0) - 1.0f;
    private double[] xs = new double[3];
    private double[][] bt = new double[3][3];
    private double q3;
    private double pitch;
    private double roll;
    private double yaw;
    private float pma;
    private float rma;
    private int[] incmax = new int[]{6136, 2805};
    private float[] elvmax = new float[]{0.220896f, 0.22089376f};
    private float[] scnmax = new float[]{0.24544f, 0.2454375f};
    private float[] elvinc = new float[]{8.0E-6f, 1.75E-5f};
    private float[] scninc = new float[]{1.6E-5f, 3.5E-5f};
    private float[] elvln = new float[]{2.8E-5f, 2.8E-4f};
    private float[] scnpx = new float[]{1.6E-5f, 2.8E-4f};
    private float[] nsnom = new float[]{0.220896f, 0.22089376f};
    private float[] ewnom = new float[]{0.24544f, 0.2454375f};
    final int STTYPE = 0;
    final int IDNTFR = 1;
    final int IMCACT = 2;
    final int IYFLIP = 3;
    final int REFLON = 5;
    final int REFDIS = 6;
    final int REFLAT = 7;
    final int REFYAW = 8;
    final int RATROL = 9;
    final int RATPTC = 10;
    final int RATYAW = 11;
    final int ETIME = 12;
    final int EDTIME = 14;
    final int IMCROL = 15;
    final int IMCPTC = 16;
    final int IMCYAW = 17;
    final int LDR1 = 18;
    final int LDR2 = 19;
    final int LDR3 = 20;
    final int LDR4 = 21;
    final int LDR5 = 22;
    final int LDR6 = 23;
    final int LDR7 = 24;
    final int LDR8 = 25;
    final int LDR9 = 26;
    final int LDR10 = 27;
    final int LDR11 = 28;
    final int LDR12 = 29;
    final int LDR13 = 30;
    final int RDDR1 = 31;
    final int RDDR2 = 32;
    final int RDDR3 = 33;
    final int RDDR4 = 34;
    final int RDDR5 = 35;
    final int RDDR6 = 36;
    final int RDDR7 = 37;
    final int RDDR8 = 38;
    final int RDDR9 = 39;
    final int RDDR10 = 40;
    final int RDDR11 = 41;
    final int DGL1 = 42;
    final int DGL2 = 43;
    final int DGL3 = 44;
    final int DGL4 = 45;
    final int DGL5 = 46;
    final int DGL6 = 47;
    final int DGL7 = 48;
    final int DGL8 = 49;
    final int DGL9 = 50;
    final int DOY1 = 51;
    final int DOY2 = 52;
    final int DOY3 = 53;
    final int DOY4 = 54;
    final int DOY5 = 55;
    final int DOY6 = 56;
    final int DOY7 = 57;
    final int DOY8 = 58;
    final int DOY9 = 59;
    final int EXPTIM = 61;
    final int RAAWDS = 62;
    final int PAAWDS = 129;
    final int YAAWDS = 184;
    final int RMAWDS = 257;
    final int PMAWDS = 312;
    final int IMGDAY = 367;
    final int IMGTM = 368;
    final int IMGSND = 369;
    final int IOFNC = 379;
    final int IOFEC = 380;
    final int IOFNI = 381;
    final int IOFEI = 382;
    final int MXCDSZ = 640;
    final int OASIZE = 336;
    final int PCOEFS = 117;
    final int RMACFS = 227;
    final int CUTOF1 = 115;
    final int CUTOF2 = 225;
    final int IMCFLG = 7;
    final int FLPFLG = 15;
    private int iflip;
    private double aec;
    private double ts;
    private double dr;
    private double lam;
    private double dlat;
    private double dyaw;
    private double phi;
    private double aebe2c;
    private double aebe3c;
    private double aebe4c;
    private double ferc;
    private int instr;
    private int itype;
    private double sublat;
    private double sublon;
    private double[] subpoint;
    final int[][] RELLST = new int[][]{{4, 10}, {13, 63}, {65, 94}, {98, 100}, {103, 105}, {108, 110}, {113, 115}, {116, 118}, {120, 149}, {153, 155}, {158, 160}, {163, 165}, {168, 170}, {171, 173}, {175, 204}, {208, 210}, {213, 215}, {218, 220}, {223, 225}, {226, 228}, {230, 259}, {263, 265}, {268, 270}, {273, 275}, {278, 283}, {285, 314}, {318, 320}, {323, 325}, {328, 330}, {333, 335}, {-1, -1}};

    public GVARnav(int[] iparms) throws IllegalArgumentException {
        this(1, iparms);
    }

    public GVARnav(int ifunc, int[] iparms) throws IllegalArgumentException {
        int loop;
        double[][] b = new double[3][3];
        int[] time = new int[2];
        float[] rparms = new float[640];
        this.aec = 6378.137;
        this.ferc = 0.003352656112592056;
        this.aebe2c = this.AEBE2;
        this.aebe3c = this.AEBE3;
        this.aebe4c = this.AEBE4;
        if (ifunc != 1) {
            ifunc = 1;
        }
        if (ifunc != 1) {
            if (iparms[0] == 123) {
                this.itype = 1;
            }
            if (iparms[0] == 234) {
                this.itype = 2;
            }
            return;
        }
        if (iparms[0] != 1196835154) {
            throw new IllegalArgumentException("Invalid navigation type" + iparms[0]);
        }
        this.itype = 1;
        for (loop = 0; loop < 640; ++loop) {
            rparms[loop] = Float.intBitsToFloat(iparms[loop]);
        }
        int count = 0;
        rparms[368] = (float)iparms[368] / 1000.0f;
        while (this.RELLST[count][0] != -1) {
            int offset = 1;
            if (this.RELLST[count][0] > 115) {
                offset = 13;
            }
            if (this.RELLST[count][0] > 225) {
                offset = 31;
            }
            for (loop = this.RELLST[count][0]; loop <= this.RELLST[count][1]; ++loop) {
                rparms[loop + offset] = loop == 13 || loop == 60 || (loop - 7) % 55 == 0 && loop != 7 ? (float)iparms[loop + offset] / 100.0f : (float)iparms[loop + offset] / 1.0E7f;
            }
            ++count;
        }
        this.instr = iparms[369];
        int nadnsc = iparms[379];
        int nadnsi = iparms[381];
        int nadewc = iparms[380];
        int nadewi = iparms[382];
        if (nadnsc != 0 && nadnsi != 0 && nadewc != 0 && nadewi != 0) {
            if (this.instr == 1) {
                this.elvmax[0] = (float)(nadnsc * this.incmax[0] + nadnsi) * this.elvinc[0];
            } else {
                this.elvmax[1] = (float)((9 - nadnsc) * this.incmax[1] - nadnsi) * this.elvinc[1];
            }
            this.scnmax[this.instr - 1] = (float)(nadewc * this.incmax[this.instr - 1] + nadewi) * this.scninc[this.instr - 1];
        }
        int year = 1900 + iparms[367] / 1000;
        int day = iparms[367] - iparms[367] / 1000 * 1000;
        int hour = (int)rparms[368] / 10000;
        int minuts = (int)rparms[368] / 100 - hour * 100;
        double secs = rparms[368] - 100.0f * (float)minuts - 10000.0f * (float)hour;
        int j = day + 1461 * (year + 4799) / 4 - 3 * ((year + 4899) / 100) / 4 - 2465022;
        double imgtim = (double)j * 1440.0 + (double)hour * 60.0 + (double)minuts + secs / 60.0;
        int t0 = 0;
        int t1 = 0;
        int power10 = 1;
        int e0 = iparms[12];
        int e1 = iparms[13];
        for (int i = 0; i < 8; ++i) {
            t0 += (e0 & 0xF) * power10;
            t1 += (e1 & 0xF) * power10;
            e0 >>>= 4;
            e1 >>>= 4;
            power10 *= 10;
        }
        year = t0 / 10000;
        day = (int)((double)(t0 - year * 10000) * 0.1);
        int iaa = t0 - year * 10000;
        int iab = (iaa - day * 10) * 10;
        int nbc = t1 / 10000000;
        int iac = t1 - nbc * 10000000;
        int def = t1 - iac;
        hour = iab + nbc;
        minuts = (int)((double)iac * 1.0E-5);
        double s2 = (double)(t1 - (def + minuts * 100000)) * 0.001;
        j = day + 1461 * (year + 4799) / 4 - 3 * ((year + 4899) / 100) / 4 - 2465022;
        double epoch = (double)j * 1440.0 + (double)hour * 60.0 + (double)minuts + s2 / 60.0;
        boolean imc = true;
        if ((iparms[2] & 0x80) != 0) {
            imc = false;
        }
        this.iflip = 1;
        if ((iparms[3] & 0x8000) != 0) {
            this.iflip = -1;
        }
        this.lam = rparms[5];
        this.dr = rparms[6];
        this.phi = rparms[7];
        double psi = rparms[8];
        this.subpoint = new double[2];
        this.subpoint[0] = (double)rparms[7] / (Math.PI / 180);
        this.subpoint[1] = (double)rparms[5] / (Math.PI / 180);
        this.roll = rparms[9];
        this.pitch = rparms[10];
        this.yaw = rparms[11];
        this.rma = 0.0f;
        this.pma = 0.0f;
        if (imc) {
            this.dr = 0.0;
            this.phi = 0.0;
            psi = 0.0;
            this.ts = imgtim - epoch;
            double w = 0.0043746900000000005 * this.ts;
            double sw = Math.sin(w);
            double cw = Math.cos(w);
            double sw1 = Math.sin(0.927 * w);
            double cw1 = Math.cos(0.927 * w);
            double s2w = Math.sin(2.0 * w);
            double c2w = Math.cos(2.0 * w);
            double sw3 = Math.sin(1.9268 * w);
            double cw3 = Math.cos(1.9268 * w);
            this.lam = this.lam + (double)rparms[18] + ((double)rparms[19] + (double)rparms[20] * w) * w + ((double)rparms[27] * sw1 + (double)rparms[28] * cw1 + (double)rparms[21] * sw + (double)rparms[22] * cw + (double)rparms[23] * s2w + (double)rparms[24] * c2w + (double)rparms[25] * sw3 + (double)rparms[26] * cw3 + w * ((double)rparms[29] * sw + (double)rparms[30] * cw)) * 2.0;
            this.dr = this.dr + (double)rparms[31] + (double)rparms[32] * cw + (double)rparms[33] * sw + (double)rparms[34] * c2w + (double)rparms[35] * s2w + (double)rparms[36] * cw3 + (double)rparms[37] * sw3 + (double)rparms[38] * cw1 + (double)rparms[39] * sw1 + w * ((double)rparms[40] * cw + (double)rparms[41] * sw);
            this.dlat = (double)rparms[42] + (double)rparms[43] * cw + (double)rparms[44] * sw + (double)rparms[45] * c2w + (double)rparms[46] * s2w + w * ((double)rparms[47] * cw + (double)rparms[48] * sw) + (double)rparms[49] * cw1 + (double)rparms[50] * sw1;
            this.phi += this.dlat * (1.0 + this.dlat * this.dlat / 6.0);
            this.dyaw = (double)rparms[51] + (double)rparms[52] * sw + (double)rparms[53] * cw + (double)rparms[54] * s2w + (double)rparms[55] * c2w + w * ((double)rparms[56] * sw + (double)rparms[57] * cw) + (double)rparms[58] * sw1 + (double)rparms[59] * cw1;
            psi += this.dyaw * (1.0 + this.dyaw * this.dyaw / 6.0);
        }
        double slat = Math.sin(this.phi);
        double syaw = Math.sin(psi);
        double sinoi = slat * slat + syaw * syaw;
        double cosoi = Math.sqrt(1.0 - sinoi);
        sinoi = Math.sqrt(sinoi);
        double u = slat == 0.0 && syaw == 0.0 ? 0.0 : Math.atan2(slat, syaw);
        double sinu = Math.sin(u);
        double cosu = Math.cos(u);
        double asc = this.lam - u;
        double sinasc = Math.sin(asc);
        double cosasc = Math.cos(asc);
        this.sublat = Math.atan(this.aebe2c * Math.tan(this.phi));
        this.sublon = asc + Math.atan2(cosoi * sinu, cosu);
        b[0][1] = -sinasc * sinoi;
        b[1][1] = cosasc * sinoi;
        b[2][1] = -cosoi;
        b[0][2] = -cosasc * cosu + sinasc * sinu * cosoi;
        b[1][2] = -sinasc * cosu - cosasc * sinu * cosoi;
        b[2][2] = -slat;
        b[0][0] = -cosasc * sinu - sinasc * cosu * cosoi;
        b[1][0] = -sinasc * sinu + cosasc * cosu * cosoi;
        b[2][0] = cosu * sinoi;
        double r = (42164.365 + this.dr) / this.aec;
        this.xs[0] = -b[0][2] * r;
        this.xs[1] = -b[1][2] * r;
        this.xs[2] = -b[2][2] * r;
        this.q3 = this.xs[0] * this.xs[0] + this.xs[1] * this.xs[1] + this.aebe2c * this.xs[2] * this.xs[2] - 1.0;
        if (imc) {
            double wa = (double)rparms[60] * this.ts;
            double te = this.ts - (double)rparms[61];
            this.roll += this.gatt(62, rparms, iparms, wa, te);
            this.pitch += this.gatt(129, rparms, iparms, wa, te);
            this.yaw += this.gatt(184, rparms, iparms, wa, te);
            this.rma = (float)this.gatt(257, rparms, iparms, wa, te);
            this.pma = (float)this.gatt(312, rparms, iparms, wa, te);
            this.roll += (double)rparms[15];
            this.pitch += (double)rparms[16];
            this.yaw += (double)rparms[17];
        }
        this.inst2e(this.roll, this.pitch, this.yaw, b, this.bt);
    }

    private double gatt(int k, float[] rparms, int[] iparms, double wa, double te) {
        double att = rparms[k + 2];
        if (te >= 0.0) {
            att += (double)rparms[k] * Math.exp(-te / (double)rparms[k + 1]);
        }
        double ir = iparms[k + 3];
        int i = (int)ir;
        for (int loop = 1; loop <= i; ++loop) {
            att += (double)rparms[k + 2 * loop + 2] * Math.cos(wa * (double)loop + (double)rparms[k + 2 * loop + 3]);
        }
        ir = iparms[k += 34];
        int kkk = iparms[k];
        for (int l = 1; l <= kkk; ++l) {
            int ll = k + 5 * l;
            double jr = iparms[ll - 4];
            double mr = iparms[ll - 3];
            att += (double)rparms[ll - 2] * Math.pow(wa - (double)rparms[ll], mr) * Math.cos(jr * wa + (double)rparms[ll - 1]);
        }
        return att;
    }

    private void inst2e(double r, double p, double y, double[][] a, double[][] at) {
        double[][] rpy = new double[3][3];
        rpy[0][0] = 1.0 - 0.5 * (p * p + y * y);
        rpy[0][1] = -y;
        rpy[0][2] = p;
        rpy[1][0] = y + p * r;
        rpy[1][1] = 1.0 - 0.5 * (y * y + r * r);
        rpy[1][2] = -r;
        rpy[2][0] = -p + r * y;
        rpy[2][1] = r + p * y;
        rpy[2][2] = 1.0 - 0.5 * (p * p + r * r);
        for (int i = 0; i < 3; ++i) {
            for (int j = 0; j < 3; ++j) {
                at[i][j] = a[i][0] * rpy[0][j] + a[i][1] * rpy[1][j] + a[i][2] * rpy[2][j];
            }
        }
    }

    @Override
    public double[] getSubpoint() {
        return this.subpoint;
    }

    @Override
    public double[][] toLatLon(double[][] linele) {
        int number = linele[0].length;
        double[] g1 = new double[3];
        double[] g2 = new double[3];
        double[] u = new double[3];
        double[][] latlon = new double[2][number];
        double[][] imglinele = this.areaCoordToImageCoord(linele);
        for (int point = 0; point < number; ++point) {
            double rl = imglinele[1][point];
            double rp = imglinele[0][point];
            if (this.instr == 2) {
                rl = (rl + 9.0) / 10.0;
                rp = (rp + 9.0) / 10.0;
            }
            double alpha0 = this.instr == 1 ? (double)this.elvmax[0] - (rl - 4.5) * (double)this.elvln[0] : (double)this.elvmax[1] - (rl - 2.5) * (double)this.elvln[1];
            double zeta0 = (rp - 1.0) * (double)this.scnpx[this.instr - 1] - (double)this.scnmax[this.instr - 1];
            double ff = this.iflip;
            if (this.instr == 2) {
                ff = -ff;
            }
            double doff = this.scnmax[this.instr - 1] - this.ewnom[this.instr - 1];
            double alpha = alpha0 - alpha0 * zeta0 * doff;
            double zeta = zeta0 + 0.5 * alpha0 * alpha0 * doff;
            double ca = Math.cos(alpha);
            double sa = Math.sin(alpha);
            double cz = Math.cos(zeta);
            double da = alpha - (double)this.pma * sa * (ff / cz + Math.tan(zeta)) - (double)this.rma * (1.0 - ca / cz);
            double dz = zeta + ff * (double)this.rma * sa;
            cz = Math.cos(dz);
            g2[0] = Math.sin(dz);
            g2[1] = -cz * Math.sin(da);
            g2[2] = cz * Math.cos(da);
            g1[0] = this.bt[0][0] * g2[0] + this.bt[0][1] * g2[1] + this.bt[0][2] * g2[2];
            g1[1] = this.bt[1][0] * g2[0] + this.bt[1][1] * g2[1] + this.bt[1][2] * g2[2];
            g1[2] = this.bt[2][0] * g2[0] + this.bt[2][1] * g2[1] + this.bt[2][2] * g2[2];
            double q2 = this.xs[0] * g1[0] + this.xs[1] * g1[1] + this.aebe2c * this.xs[2] * g1[2];
            double q1 = g1[0] * g1[0] + g1[1] * g1[1] + this.aebe2c * g1[2] * g1[2];
            double d = q2 * q2 - q1 * this.q3;
            if (Math.abs(d) < -8.0) {
                d = 0.0;
            }
            if (!(d >= 0.0)) {
                latlon[0][point] = Double.NaN;
                latlon[1][point] = Double.NaN;
                continue;
            }
            d = Math.sqrt(d);
            double h2 = -(q2 + d) / q1;
            u[0] = this.xs[0] + h2 * g1[0];
            u[1] = this.xs[1] + h2 * g1[1];
            u[2] = this.xs[2] + h2 * g1[2];
            double d1 = u[2] / Math.sqrt(u[0] * u[0] + u[1] * u[1] + u[2] * u[2]);
            double rlat = Math.atan(this.aebe2c * d1 / Math.sqrt(1.0 - d1 * d1));
            double rlon = Math.atan2(u[1], u[0]);
            rlat *= 57.29577951308232;
            rlon *= 57.29577951308232;
            if (!this.isEastPositive) {
                rlon = -rlon;
            }
            if (this.itype == 2) continue;
            latlon[0][point] = rlat;
            latlon[1][point] = rlon;
        }
        return latlon;
    }

    @Override
    public float[][] toLatLon(float[][] linele) {
        int number = linele[0].length;
        double[] g1 = new double[3];
        double[] g2 = new double[3];
        double[] u = new double[3];
        float[][] latlon = new float[2][number];
        float[][] imglinele = this.areaCoordToImageCoord(linele);
        for (int point = 0; point < number; ++point) {
            double rl = imglinele[1][point];
            double rp = imglinele[0][point];
            if (this.instr == 2) {
                rl = (rl + 9.0) / 10.0;
                rp = (rp + 9.0) / 10.0;
            }
            double alpha0 = this.instr == 1 ? (double)this.elvmax[0] - (rl - 4.5) * (double)this.elvln[0] : (double)this.elvmax[1] - (rl - 2.5) * (double)this.elvln[1];
            double zeta0 = (rp - 1.0) * (double)this.scnpx[this.instr - 1] - (double)this.scnmax[this.instr - 1];
            double ff = this.iflip;
            if (this.instr == 2) {
                ff = -ff;
            }
            double doff = this.scnmax[this.instr - 1] - this.ewnom[this.instr - 1];
            double alpha = alpha0 - alpha0 * zeta0 * doff;
            double zeta = zeta0 + 0.5 * alpha0 * alpha0 * doff;
            double ca = Math.cos(alpha);
            double sa = Math.sin(alpha);
            double cz = Math.cos(zeta);
            double da = alpha - (double)this.pma * sa * (ff / cz + Math.tan(zeta)) - (double)this.rma * (1.0 - ca / cz);
            double dz = zeta + ff * (double)this.rma * sa;
            cz = Math.cos(dz);
            g2[0] = Math.sin(dz);
            g2[1] = -cz * Math.sin(da);
            g2[2] = cz * Math.cos(da);
            g1[0] = this.bt[0][0] * g2[0] + this.bt[0][1] * g2[1] + this.bt[0][2] * g2[2];
            g1[1] = this.bt[1][0] * g2[0] + this.bt[1][1] * g2[1] + this.bt[1][2] * g2[2];
            g1[2] = this.bt[2][0] * g2[0] + this.bt[2][1] * g2[1] + this.bt[2][2] * g2[2];
            double q2 = this.xs[0] * g1[0] + this.xs[1] * g1[1] + this.aebe2c * this.xs[2] * g1[2];
            double q1 = g1[0] * g1[0] + g1[1] * g1[1] + this.aebe2c * g1[2] * g1[2];
            double d = q2 * q2 - q1 * this.q3;
            if (Math.abs(d) < -8.0) {
                d = 0.0;
            }
            if (!(d >= 0.0)) {
                latlon[0][point] = Float.NaN;
                latlon[1][point] = Float.NaN;
                continue;
            }
            d = Math.sqrt(d);
            double h2 = -(q2 + d) / q1;
            u[0] = this.xs[0] + h2 * g1[0];
            u[1] = this.xs[1] + h2 * g1[1];
            u[2] = this.xs[2] + h2 * g1[2];
            double d1 = u[2] / Math.sqrt(u[0] * u[0] + u[1] * u[1] + u[2] * u[2]);
            double rlat = Math.atan(this.aebe2c * d1 / Math.sqrt(1.0 - d1 * d1));
            double rlon = Math.atan2(u[1], u[0]);
            rlat *= 57.29577951308232;
            rlon *= 57.29577951308232;
            if (!this.isEastPositive) {
                rlon = -rlon;
            }
            if (this.itype == 2) continue;
            latlon[0][point] = (float)rlat;
            latlon[1][point] = (float)rlon;
        }
        return latlon;
    }

    @Override
    public double[][] toLinEle(double[][] latlon) {
        double[] f = new double[3];
        double[] ft = new double[3];
        double[] u = new double[3];
        int number = latlon[0].length;
        double[][] linele = new double[2][number];
        double ff = this.iflip;
        if (this.instr == 2) {
            ff = -ff;
        }
        double doff = this.scnmax[this.instr - 1] - this.ewnom[this.instr - 1];
        for (int point = 0; point < number; ++point) {
            double alpha1;
            double alf;
            if (Math.abs(latlon[0][point]) > 90.0) {
                linele[1][point] = Double.NaN;
                linele[0][point] = Double.NaN;
                continue;
            }
            double rlat = latlon[0][point] * (Math.PI / 180);
            double rlon = latlon[1][point] * (Math.PI / 180);
            if (!this.isEastPositive) {
                rlon = -rlon;
            }
            double sing = Math.sin(rlat);
            double w1 = this.aebe4c * sing * sing;
            double slat = ((0.375 * w1 - 0.5) * w1 + 1.0) * sing / this.aebe2c;
            double w2 = slat * slat;
            w1 = this.aebe3c * w2;
            w1 = (0.375 * w1 - 0.5) * w1 + 1.0;
            u[2] = slat * w1;
            w2 = w1 * Math.sqrt(1.0 - w2);
            u[0] = w2 * Math.cos(rlon);
            u[1] = w2 * Math.sin(rlon);
            f[0] = u[0] - this.xs[0];
            f[1] = u[1] - this.xs[1];
            f[2] = u[2] - this.xs[2];
            w2 = u[0] * f[0] + u[1] * f[1] + u[2] * f[2] * this.aebe2c;
            if (w2 <= 0.0) {
                ft[0] = this.bt[0][0] * f[0] + this.bt[1][0] * f[1] + this.bt[2][0] * f[2];
                ft[1] = this.bt[0][1] * f[0] + this.bt[1][1] * f[1] + this.bt[2][1] * f[2];
                ft[2] = this.bt[0][2] * f[0] + this.bt[1][2] * f[1] + this.bt[2][2] * f[2];
                double gam = Math.atan(ft[0] / Math.sqrt(ft[1] * ft[1] + ft[2] * ft[2]));
                alf = -Math.atan(ft[1] / ft[2]);
                w1 = Math.sin(alf);
                w2 = Math.cos(gam);
                alpha1 = alf + (double)this.rma * (1.0 - Math.cos(alf) / w2) + (double)this.pma * w1 * (doff / w2 + Math.tan(gam));
                alf = alpha1 + alpha1 * (gam -= ff * (double)this.rma * w1) * doff;
            } else {
                linele[1][point] = Double.NaN;
                linele[0][point] = Double.NaN;
                continue;
            }
            double tmplin = ((double)this.elvmax[this.instr - 1] - alf) / (double)this.elvln[this.instr - 1];
            tmplin = this.instr == 1 ? (tmplin += 4.5) : (tmplin += 2.5);
            double tmpele = ((double)this.scnmax[this.instr - 1] + (gam -= 0.5 * alpha1 * alpha1 * doff)) / (double)this.scnpx[this.instr - 1] + 1.0;
            linele[1][point] = tmplin;
            linele[0][point] = tmpele;
            if (this.instr != 2) continue;
            linele[1][point] = linele[1][point] * 10.0 - 9.0;
            linele[0][point] = linele[0][point] * 10.0 - 9.0;
        }
        return this.imageCoordToAreaCoord(linele, linele);
    }

    @Override
    public float[][] toLinEle(float[][] latlon) {
        double[] f = new double[3];
        double[] ft = new double[3];
        double[] u = new double[3];
        int number = latlon[0].length;
        float[][] linele = new float[2][number];
        double ff = this.iflip;
        if (this.instr == 2) {
            ff = -ff;
        }
        double doff = this.scnmax[this.instr - 1] - this.ewnom[this.instr - 1];
        for (int point = 0; point < number; ++point) {
            double alpha1;
            double alf;
            if ((double)Math.abs(latlon[0][point]) > 90.0) {
                linele[1][point] = Float.NaN;
                linele[0][point] = Float.NaN;
                continue;
            }
            double rlat = (double)latlon[0][point] * (Math.PI / 180);
            double rlon = (double)latlon[1][point] * (Math.PI / 180);
            if (!this.isEastPositive) {
                rlon = -rlon;
            }
            double sing = Math.sin(rlat);
            double w1 = this.aebe4c * sing * sing;
            double slat = ((0.375 * w1 - 0.5) * w1 + 1.0) * sing / this.aebe2c;
            double w2 = slat * slat;
            w1 = this.aebe3c * w2;
            w1 = (0.375 * w1 - 0.5) * w1 + 1.0;
            u[2] = slat * w1;
            w2 = w1 * Math.sqrt(1.0 - w2);
            u[0] = w2 * Math.cos(rlon);
            u[1] = w2 * Math.sin(rlon);
            f[0] = u[0] - this.xs[0];
            f[1] = u[1] - this.xs[1];
            f[2] = u[2] - this.xs[2];
            w2 = u[0] * f[0] + u[1] * f[1] + u[2] * f[2] * this.aebe2c;
            if (w2 <= 0.0) {
                ft[0] = this.bt[0][0] * f[0] + this.bt[1][0] * f[1] + this.bt[2][0] * f[2];
                ft[1] = this.bt[0][1] * f[0] + this.bt[1][1] * f[1] + this.bt[2][1] * f[2];
                ft[2] = this.bt[0][2] * f[0] + this.bt[1][2] * f[1] + this.bt[2][2] * f[2];
                double gam = Math.atan(ft[0] / Math.sqrt(ft[1] * ft[1] + ft[2] * ft[2]));
                alf = -Math.atan(ft[1] / ft[2]);
                w1 = Math.sin(alf);
                w2 = Math.cos(gam);
                alpha1 = alf + (double)this.rma * (1.0 - Math.cos(alf) / w2) + (double)this.pma * w1 * (doff / w2 + Math.tan(gam));
                alf = alpha1 + alpha1 * (gam -= ff * (double)this.rma * w1) * doff;
            } else {
                linele[1][point] = Float.NaN;
                linele[0][point] = Float.NaN;
                continue;
            }
            double tmplin = ((double)this.elvmax[this.instr - 1] - alf) / (double)this.elvln[this.instr - 1];
            tmplin = this.instr == 1 ? (tmplin += 4.5) : (tmplin += 2.5);
            double tmpele = ((double)this.scnmax[this.instr - 1] + (gam -= 0.5 * alpha1 * alpha1 * doff)) / (double)this.scnpx[this.instr - 1] + 1.0;
            linele[1][point] = (float)tmplin;
            linele[0][point] = (float)tmpele;
            if (this.instr != 2) continue;
            linele[1][point] = linele[1][point] * 10.0f - 9.0f;
            linele[0][point] = linele[0][point] * 10.0f - 9.0f;
        }
        return this.imageCoordToAreaCoord(linele, linele);
    }
}

