/*
 * Decompiled with CFR 0.152.
 */
package thredds.inventory;

import java.util.Formatter;
import java.util.ServiceLoader;
import javax.annotation.Nullable;
import thredds.inventory.CollectionSpecParser;
import thredds.inventory.CollectionSpecParserAbstract;
import thredds.inventory.CollectionSpecParserProvider;

public class CollectionSpecParsers {
    public static CollectionSpecParserAbstract create(String spec, Formatter errlog) {
        CollectionSpecParserProvider collectionSpecParserProvider = CollectionSpecParsers.getProvider(spec);
        return collectionSpecParserProvider != null ? collectionSpecParserProvider.create(spec, errlog) : new CollectionSpecParser(spec, errlog);
    }

    public static CollectionSpecParserAbstract create(String rootDir, String regEx, Formatter errlog) {
        CollectionSpecParserProvider collectionSpecParserProvider = CollectionSpecParsers.getProvider(rootDir);
        return collectionSpecParserProvider != null ? collectionSpecParserProvider.create(rootDir, regEx, errlog) : new CollectionSpecParser(rootDir, regEx, errlog);
    }

    @Nullable
    private static CollectionSpecParserProvider getProvider(String spec) {
        CollectionSpecParserProvider collectionSpecParserProvider = null;
        for (CollectionSpecParserProvider provider : ServiceLoader.load(CollectionSpecParserProvider.class)) {
            if (!provider.canParse(spec)) continue;
            collectionSpecParserProvider = provider;
            break;
        }
        return collectionSpecParserProvider;
    }
}

