/*
 * Decompiled with CFR 0.152.
 */
package com.sun.faces.application.view;

import com.sun.faces.application.view.ViewScopeContextObject;
import java.util.ArrayList;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.enterprise.context.spi.Contextual;
import javax.enterprise.context.spi.CreationalContext;
import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;
import javax.inject.Named;
import javax.servlet.http.HttpSession;
import javax.servlet.http.HttpSessionEvent;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ViewScopeContextManager {
    private static final Logger LOGGER = Logger.getLogger(ViewScopeContextManager.class.getName());
    private static final String ACTIVE_VIEW_CONTEXTS = "com.sun.faces.application.view.activeViewContexts";
    private static final String ACTIVE_VIEW_MAPS = "com.sun.faces.application.view.activeViewMaps";

    public void clear(FacesContext facesContext) {
        if (LOGGER.isLoggable(Level.FINEST)) {
            LOGGER.log(Level.FINEST, "Clearing @ViewScoped CDI beans for current view map");
        }
        Map<String, Object> viewMap = facesContext.getViewRoot().getViewMap(false);
        Map<Contextual, ViewScopeContextObject> contextMap = this.getContextMap(facesContext, false);
        if (contextMap != null) {
            this.destroyBeans(viewMap, contextMap);
        }
    }

    public void clear(FacesContext facesContext, Map<String, Object> viewMap) {
        Map<Contextual, ViewScopeContextObject> contextMap;
        if (LOGGER.isLoggable(Level.FINEST)) {
            LOGGER.log(Level.FINEST, "Clearing @ViewScoped CDI beans for given view map: {0}");
        }
        if ((contextMap = this.getContextMap(facesContext, false)) != null) {
            this.destroyBeans(viewMap, contextMap);
        }
    }

    public <T> T createBean(FacesContext facesContext, Contextual<T> contextual, CreationalContext<T> creational) {
        Object result;
        if (LOGGER.isLoggable(Level.FINEST)) {
            LOGGER.log(Level.FINEST, "Creating @ViewScoped CDI bean using contextual: {0}", contextual);
        }
        if ((result = contextual.create(creational)) != null) {
            String name = this.getName(result);
            facesContext.getViewRoot().getViewMap(true).put(name, result);
            this.getContextMap(facesContext).put(contextual, new ViewScopeContextObject(contextual, creational, name));
        }
        return (T)result;
    }

    private void destroyBeans(Map<String, Object> viewMap, Map<Contextual, ViewScopeContextObject> contextMap) {
        ArrayList<String> removalNameList = new ArrayList<String>();
        if (contextMap != null) {
            for (Map.Entry<Contextual, ViewScopeContextObject> entry : contextMap.entrySet()) {
                Contextual contextual = entry.getKey();
                ViewScopeContextObject contextObject = entry.getValue();
                CreationalContext creationalContext = contextObject.getCreationalContext();
                contextual.destroy(viewMap.get(contextObject.getName()), creationalContext);
                removalNameList.add(contextObject.getName());
            }
            for (String name : removalNameList) {
                viewMap.remove(name);
            }
        }
    }

    public <T> T getBean(FacesContext facesContext, Contextual<T> contextual) {
        Object result = null;
        Map<Contextual, ViewScopeContextObject> contextMap = this.getContextMap(facesContext);
        if (contextMap != null) {
            ViewScopeContextObject contextObject = contextMap.get(contextual);
            if (LOGGER.isLoggable(Level.FINEST)) {
                LOGGER.log(Level.FINEST, "Getting value for @ViewScoped bean with name: {0}", contextObject.getName());
            }
            if (contextObject != null) {
                result = facesContext.getViewRoot().getViewMap(true).get(contextObject.getName());
            }
        }
        return (T)result;
    }

    private Map<Contextual, ViewScopeContextObject> getContextMap(FacesContext facesContext) {
        return this.getContextMap(facesContext, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<Contextual, ViewScopeContextObject> getContextMap(FacesContext facesContext, boolean create) {
        Map result = null;
        ExternalContext externalContext = facesContext.getExternalContext();
        if (externalContext != null) {
            ConcurrentHashMap concurrentHashMap;
            ConcurrentHashMap sessionMap = externalContext.getSessionMap();
            ConcurrentHashMap activeViewScopeContexts = (ConcurrentHashMap)sessionMap.get(ACTIVE_VIEW_CONTEXTS);
            Map<String, Object> viewMap = facesContext.getViewRoot().getViewMap(false);
            if (activeViewScopeContexts == null && create) {
                concurrentHashMap = sessionMap;
                synchronized (concurrentHashMap) {
                    activeViewScopeContexts = new ConcurrentHashMap();
                    sessionMap.put(ACTIVE_VIEW_CONTEXTS, activeViewScopeContexts);
                }
            }
            if (activeViewScopeContexts != null && create) {
                concurrentHashMap = activeViewScopeContexts;
                synchronized (concurrentHashMap) {
                    if (!activeViewScopeContexts.containsKey(System.identityHashCode(viewMap)) && create) {
                        activeViewScopeContexts.put((String)((Object)Integer.valueOf(System.identityHashCode(viewMap))), new ConcurrentHashMap());
                    }
                }
            }
            if (activeViewScopeContexts != null) {
                result = (Map)activeViewScopeContexts.get(System.identityHashCode(viewMap));
            }
        }
        return result;
    }

    private String getName(Object instance) {
        String name = instance.getClass().getSimpleName().substring(0, 1).toLowerCase() + instance.getClass().getSimpleName().substring(1);
        Named named = instance.getClass().getAnnotation(Named.class);
        if (named != null && named.value() != null && !named.value().trim().equals("")) {
            name = named.value();
        }
        return name;
    }

    public void sessionDestroyed(HttpSessionEvent hse) {
        HttpSession session;
        Map activeViewScopeContexts;
        if (LOGGER.isLoggable(Level.FINEST)) {
            LOGGER.log(Level.FINEST, "Cleaning up session for CDI @ViewScoped beans");
        }
        if ((activeViewScopeContexts = (Map)(session = hse.getSession()).getAttribute(ACTIVE_VIEW_CONTEXTS)) != null) {
            Map activeViewMaps = (Map)session.getAttribute(ACTIVE_VIEW_MAPS);
            if (activeViewMaps != null) {
                for (Map instanceMap : activeViewMaps.values()) {
                    Map contextMap = (Map)activeViewScopeContexts.get(System.identityHashCode(instanceMap));
                    this.destroyBeans(instanceMap, contextMap);
                }
            }
            activeViewScopeContexts.clear();
            session.removeAttribute(ACTIVE_VIEW_CONTEXTS);
        }
    }
}

