/*
 * Decompiled with CFR 0.152.
 */
package org.jgrasstools.gears.utils.geometry;

import com.vividsolutions.jts.geom.GeometryCollection;
import com.vividsolutions.jts.geom.LineString;
import com.vividsolutions.jts.geom.MultiLineString;
import com.vividsolutions.jts.geom.MultiPoint;
import com.vividsolutions.jts.geom.MultiPolygon;
import com.vividsolutions.jts.geom.Point;
import com.vividsolutions.jts.geom.Polygon;

public enum GeometryType {
    POINT(Point.class, MultiPoint.class),
    MULTIPOINT(MultiPoint.class, MultiPoint.class),
    LINE(LineString.class, MultiLineString.class),
    MULTILINE(MultiLineString.class, MultiLineString.class),
    POLYGON(Polygon.class, MultiPolygon.class),
    MULTIPOLYGON(MultiPolygon.class, MultiPolygon.class),
    GEOMETRYCOLLECTION(GeometryCollection.class, GeometryCollection.class),
    UNKNOWN(null, null);

    private Class<?> clazz;
    private Class<?> multiClazz;

    private GeometryType(Class<?> clazz, Class<?> multiClazz) {
        this.clazz = clazz;
        this.multiClazz = multiClazz;
    }

    public Class<?> getClazz() {
        return this.clazz;
    }

    public Class<?> getMultiClazz() {
        return this.multiClazz;
    }

    public static GeometryType forClass(Class<?> clazz) {
        if (POINT.getClazz().isAssignableFrom(clazz)) {
            return POINT;
        }
        if (MULTIPOINT.getClazz().isAssignableFrom(clazz)) {
            return MULTIPOINT;
        }
        if (LINE.getClazz().isAssignableFrom(clazz)) {
            return LINE;
        }
        if (MULTILINE.getClazz().isAssignableFrom(clazz)) {
            return MULTILINE;
        }
        if (POLYGON.getClazz().isAssignableFrom(clazz)) {
            return POLYGON;
        }
        if (MULTIPOLYGON.getClazz().isAssignableFrom(clazz)) {
            return MULTIPOLYGON;
        }
        if (GEOMETRYCOLLECTION.getClazz().isAssignableFrom(clazz)) {
            return GEOMETRYCOLLECTION;
        }
        return null;
    }

    public boolean isMulti() {
        switch (this) {
            case MULTILINE: 
            case MULTIPOINT: 
            case MULTIPOLYGON: {
                return true;
            }
        }
        return false;
    }

    public boolean isCompatibleWith(GeometryType geometryType) {
        switch (geometryType) {
            case LINE: {
                return this == LINE;
            }
            case MULTILINE: {
                return this == LINE || this == MULTILINE;
            }
            case POINT: {
                return this == POINT;
            }
            case MULTIPOINT: {
                return this == POINT || this == MULTIPOINT;
            }
            case POLYGON: {
                return this == POLYGON;
            }
            case MULTIPOLYGON: {
                return this == POLYGON || this == MULTIPOLYGON;
            }
        }
        return false;
    }
}

