/*
 * Decompiled with CFR 0.152.
 */
package org.jgrasstools.gears.utils.clustering;

import org.jgrasstools.gears.utils.clustering.GvmClusterPair;
import org.jgrasstools.gears.utils.clustering.GvmClusters;
import org.jgrasstools.gears.utils.clustering.GvmSpace;

public class GvmCluster<S extends GvmSpace, K> {
    final GvmClusters<S, K> clusters;
    final GvmClusterPair<S, K>[] pairs;
    boolean removed;
    int count;
    double m0;
    final Object m1;
    final Object m2;
    double var;
    K key;

    GvmCluster(GvmClusters<S, K> clusters) {
        this.clusters = clusters;
        this.removed = false;
        this.count = 0;
        this.m0 = 0.0;
        this.m1 = ((GvmSpace)clusters.space).newOrigin();
        this.m2 = ((GvmSpace)clusters.space).newOrigin();
        this.pairs = new GvmClusterPair[clusters.capacity];
        this.update();
    }

    public double getMass() {
        return this.m0;
    }

    public int getCount() {
        return this.count;
    }

    public double getVariance() {
        return this.var;
    }

    public K getKey() {
        return this.key;
    }

    void clear() {
        this.count = 0;
        this.m0 = 0.0;
        ((GvmSpace)this.clusters.space).setToOrigin(this.m1);
        ((GvmSpace)this.clusters.space).setToOrigin(this.m2);
        this.var = 0.0;
        this.key = null;
    }

    void set(double m, Object pt) {
        if (m == 0.0) {
            if (this.count != 0) {
                ((GvmSpace)this.clusters.space).setToOrigin(this.m1);
                ((GvmSpace)this.clusters.space).setToOrigin(this.m2);
            }
        } else {
            ((GvmSpace)this.clusters.space).setToScaled(this.m1, m, pt);
            ((GvmSpace)this.clusters.space).setToScaledSqr(this.m2, m, pt);
        }
        this.count = 1;
        this.m0 = m;
        this.var = 0.0;
    }

    void add(double m, Object pt) {
        if (this.count == 0) {
            this.set(m, pt);
        } else {
            ++this.count;
            if (m != 0.0) {
                this.m0 += m;
                ((GvmSpace)this.clusters.space).addScaled(this.m1, m, pt);
                ((GvmSpace)this.clusters.space).addScaledSqr(this.m2, m, pt);
                this.update();
            }
        }
    }

    void set(GvmCluster<S, K> cluster) {
        if (cluster == this) {
            throw new IllegalArgumentException("cannot set cluster to itself");
        }
        this.m0 = cluster.m0;
        ((GvmSpace)this.clusters.space).setTo(this.m1, cluster.m1);
        ((GvmSpace)this.clusters.space).setTo(this.m2, cluster.m2);
        this.var = cluster.var;
    }

    void add(GvmCluster<S, K> cluster) {
        if (cluster == this) {
            throw new IllegalArgumentException();
        }
        if (cluster.count == 0) {
            return;
        }
        if (this.count == 0) {
            this.set(cluster);
        } else {
            this.count += cluster.count;
            this.m0 += cluster.m0;
            ((GvmSpace)this.clusters.space).add(this.m1, cluster.m1);
            ((GvmSpace)this.clusters.space).add(this.m2, cluster.m2);
            this.update();
        }
    }

    double test(double m, Object pt) {
        return this.m0 == 0.0 && m == 0.0 ? 0.0 : ((GvmSpace)this.clusters.space).variance(this.m0, this.m1, this.m2, m, pt) - this.var;
    }

    double test(GvmCluster<S, K> cluster) {
        return this.m0 == 0.0 && cluster.m0 == 0.0 ? 0.0 : ((GvmSpace)this.clusters.space).variance(this.m0, this.m1, this.m2, cluster.m0, cluster.m1, cluster.m2);
    }

    private void update() {
        this.var = this.m0 == 0.0 ? 0.0 : ((GvmSpace)this.clusters.space).variance(this.m0, this.m1, this.m2);
    }
}

