/*
 * Decompiled with CFR 0.152.
 */
package org.jgrasstools.gears.modules.r.raster4xyz;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Envelope;
import java.awt.image.WritableRaster;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import oms3.annotations.Author;
import oms3.annotations.Description;
import oms3.annotations.Documentation;
import oms3.annotations.Execute;
import oms3.annotations.In;
import oms3.annotations.Keywords;
import oms3.annotations.Label;
import oms3.annotations.License;
import oms3.annotations.Name;
import oms3.annotations.Out;
import oms3.annotations.Status;
import oms3.annotations.UI;
import org.geotools.coverage.grid.GridCoordinates2D;
import org.geotools.coverage.grid.GridCoverage2D;
import org.geotools.coverage.grid.GridGeometry2D;
import org.geotools.geometry.DirectPosition2D;
import org.geotools.referencing.CRS;
import org.jgrasstools.gears.libs.modules.JGTModel;
import org.jgrasstools.gears.utils.RegionMap;
import org.jgrasstools.gears.utils.coverage.CoverageUtilities;
import org.jgrasstools.gears.utils.files.FileUtilities;
import org.opengis.geometry.DirectPosition;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

@Description(value="Convert evenly spaced XYZ triplets to regular raster grid.")
@Documentation(value="")
@Author(name="Andrea Antonello", contact="http://www.hydrologis.com")
@Keywords(value="Raster, Conversion")
@Label(value="Raster Processing")
@Name(value="xyz2raster")
@Status(value=40)
@License(value="General Public License Version 3 (GPLv3)")
public class OmsXyz2Raster
extends JGTModel {
    @Description(value="The file of regularly distributed xyz triplets.")
    @UI(value="infile")
    @In
    public String inFile;
    @Description(value="The resolution to use.")
    @In
    public Double pRes;
    @Description(value="The code defining the target coordinate reference system, composed by authority and code number (ex. EPSG:4328).")
    @UI(value="crs")
    @In
    public String pCode;
    @Description(value="The value separator (if not set, spaces will be used).")
    @In
    public String pSeparator;
    @Description(value="The generated raster.")
    @Out
    public GridCoverage2D outRaster;
    private double res = 0.0;

    @Execute
    public void process() throws Exception {
        this.checkNull(this.inFile, this.pRes, this.pCode);
        CoordinateReferenceSystem crs = CRS.decode((String)this.pCode);
        this.res = this.pRes;
        Envelope env = null;
        this.pm.beginTask("Reading triplets file...", -1);
        List<String> linesList = FileUtilities.readFileToLinesList(this.inFile);
        this.pm.done();
        ArrayList<Coordinate> coordList = new ArrayList<Coordinate>();
        double n = Double.NEGATIVE_INFINITY;
        double s = Double.POSITIVE_INFINITY;
        double e = Double.NEGATIVE_INFINITY;
        double w = Double.POSITIVE_INFINITY;
        if (this.pSeparator == null) {
            this.pSeparator = "\\s+";
        }
        this.pm.beginTask("Extracting data...", linesList.size());
        for (String line : linesList) {
            double y;
            String[] split = line.trim().split(this.pSeparator);
            if (split.length != 3) {
                this.pm.worked(1);
                continue;
            }
            double x = Double.parseDouble(split[0].trim());
            if (x > e) {
                e = x;
            }
            if (x < w) {
                w = x;
            }
            if ((y = Double.parseDouble(split[1].trim())) > n) {
                n = y;
            }
            if (y < s) {
                s = y;
            }
            double z = Double.parseDouble(split[2].trim());
            Coordinate c = new Coordinate(x, y, z);
            coordList.add(c);
            if (env == null) {
                env = new Envelope(c);
            } else {
                env.expandToInclude(c);
            }
            this.pm.worked(1);
        }
        this.pm.done();
        int rows = (int)((n - s) / this.res);
        int cols = (int)((e - w) / this.res);
        GridGeometry2D gridGeometry = CoverageUtilities.gridGeometryFromRegionValues(n, s, e, w, rows, cols, crs);
        WritableRaster writableRaster = CoverageUtilities.createDoubleWritableRaster(cols, rows, null, null, Double.NaN);
        this.pm.beginTask("Create raster...", coordList.size());
        DirectPosition2D world = new DirectPosition2D();
        for (Coordinate coordinate : coordList) {
            world.setLocation(coordinate.x, coordinate.y);
            GridCoordinates2D grid = gridGeometry.worldToGrid((DirectPosition)world);
            writableRaster.setSample(grid.x, grid.y, 0, coordinate.z);
            this.pm.worked(1);
        }
        this.pm.done();
        RegionMap regionMap = CoverageUtilities.gridGeometry2RegionParamsMap(gridGeometry);
        this.outRaster = CoverageUtilities.buildCoverage("fromxyz", writableRaster, (HashMap<String, Double>)regionMap, crs);
    }
}

