/*
 * Decompiled with CFR 0.152.
 */
package org.jgrasstools.gears.modules.r.mapcalc;

import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.jaitools.CollectionFactory;
import org.jaitools.jiffle.runtime.JiffleEvent;
import org.jaitools.jiffle.runtime.JiffleEventListener;
import org.jaitools.jiffle.runtime.JiffleExecutorResult;

public class WaitingListener
implements JiffleEventListener {
    private CountDownLatch latch = null;
    private final List<JiffleExecutorResult> results = CollectionFactory.list();

    public void setNumTasks(int n) {
        if (this.latch != null && this.latch.getCount() > 0L) {
            throw new IllegalStateException("Method called during wait period");
        }
        this.latch = new CountDownLatch(n);
    }

    public boolean await(long timeOut, TimeUnit units) {
        if (this.latch == null) {
            throw new RuntimeException("Called await without setting number of tasks");
        }
        try {
            boolean isZero = this.latch.await(timeOut, units);
            return isZero;
        }
        catch (InterruptedException ex) {
            throw new RuntimeException(ex);
        }
    }

    public void await() {
        if (this.latch == null) {
            throw new RuntimeException("Called await without setting number of tasks");
        }
        try {
            this.latch.await();
        }
        catch (InterruptedException ex) {
            throw new RuntimeException(ex);
        }
    }

    public List<JiffleExecutorResult> getResults() {
        return this.results;
    }

    public void onCompletionEvent(JiffleEvent ev) {
        JiffleExecutorResult result = ev.getResult();
        this.results.add(result);
        this.latch.countDown();
    }

    public void onFailureEvent(JiffleEvent ev) {
        JiffleExecutorResult result = ev.getResult();
        this.results.add(result);
        this.latch.countDown();
    }
}

