/*
 * Decompiled with CFR 0.152.
 */
package org.jgrasstools.gears.modules.r.bobthebuilder;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.MultiPolygon;
import com.vividsolutions.jts.geom.Polygon;
import com.vividsolutions.jts.geom.prep.PreparedGeometry;
import com.vividsolutions.jts.geom.prep.PreparedGeometryFactory;
import java.awt.image.WritableRaster;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.media.jai.iterator.RandomIter;
import javax.media.jai.iterator.RandomIterFactory;
import javax.media.jai.iterator.WritableRandomIter;
import oms3.annotations.Author;
import oms3.annotations.Description;
import oms3.annotations.Documentation;
import oms3.annotations.Execute;
import oms3.annotations.In;
import oms3.annotations.Keywords;
import oms3.annotations.Label;
import oms3.annotations.License;
import oms3.annotations.Name;
import oms3.annotations.Out;
import oms3.annotations.Status;
import org.geotools.coverage.grid.GridCoordinates2D;
import org.geotools.coverage.grid.GridCoverage2D;
import org.geotools.coverage.grid.GridGeometry2D;
import org.geotools.data.simple.SimpleFeatureCollection;
import org.geotools.feature.DefaultFeatureCollection;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.jgrasstools.gears.libs.exceptions.ModelsIllegalargumentException;
import org.jgrasstools.gears.libs.modules.JGTConstants;
import org.jgrasstools.gears.libs.modules.JGTModel;
import org.jgrasstools.gears.modules.r.interpolation2d.core.IDWInterpolator;
import org.jgrasstools.gears.modules.r.scanline.OmsScanLineRasterizer;
import org.jgrasstools.gears.utils.RegionMap;
import org.jgrasstools.gears.utils.coverage.CoverageUtilities;
import org.jgrasstools.gears.utils.coverage.ProfilePoint;
import org.jgrasstools.gears.utils.features.FeatureMate;
import org.jgrasstools.gears.utils.features.FeatureUtilities;
import org.jgrasstools.gears.utils.math.NumericsUtilities;
import org.opengis.geometry.DirectPosition;

@Description(value="Builds rasterized artifacts on a raster.")
@Documentation(value="")
@Author(name="Andrea Antonello", contact="www.hydrologis.com")
@Keywords(value="Build, Raster")
@Label(value="Raster Processing")
@Name(value="bobbuilder")
@Status(value=5)
@License(value="General Public License Version 3 (GPLv3)")
public class OmsBobTheBuilder
extends JGTModel {
    @Description(value="The input raster.")
    @In
    public GridCoverage2D inRaster = null;
    @Description(value="The vector map containing the polygonal area to modify.")
    @In
    public SimpleFeatureCollection inArea = null;
    @Description(value="The vector map containing the points that provide the new elevations.")
    @In
    public SimpleFeatureCollection inElevations = null;
    @Description(value="The maximum radius to use for interpolation.")
    @In
    public double pMaxbuffer = -1.0;
    @Description(value="The field of the elevations map that contain the elevation of the point.")
    @In
    public String fElevation = null;
    @Description(value="Switch that defines if the module should erode in places the actual raster is higher (default is false).")
    @In
    public boolean doErode = false;
    @Description(value="Switch that defines if the module should use only points contained in the polygon for the interpolation (default is false. i.e. use all).")
    @In
    public boolean doUseOnlyInternal = false;
    @Description(value="Switch that defines if the module should add the border of the polygon as elevation point to aid connection between new and old (default is false).")
    @In
    public boolean doPolygonborder = false;
    @Description(value="The modified raster map.")
    @Out
    public GridCoverage2D outRaster = null;

    @Execute
    public void process() throws Exception {
        int r;
        int c;
        this.checkNull(this.inRaster, this.inArea, this.inElevations, this.fElevation);
        RegionMap regionMap = CoverageUtilities.getRegionParamsFromGridCoverage(this.inRaster);
        int cols = regionMap.getCols();
        int rows = regionMap.getRows();
        double west = regionMap.getWest();
        double east = regionMap.getEast();
        double south = regionMap.getSouth();
        double north = regionMap.getNorth();
        ReferencedEnvelope vectorBounds = this.inArea.getBounds();
        if (!(NumericsUtilities.isBetween(vectorBounds.getMaxX(), west, east) && NumericsUtilities.isBetween(vectorBounds.getMinX(), west, east) && NumericsUtilities.isBetween(vectorBounds.getMaxY(), south, north) && NumericsUtilities.isBetween(vectorBounds.getMinY(), south, north))) {
            throw new ModelsIllegalargumentException("The vector map has to be within the raster map boundaries.", this, this.pm);
        }
        List<FeatureMate> polygonMates = FeatureUtilities.featureCollectionToMatesList(this.inArea);
        String polygonMessage = "This operation can be applied only to a single polygon.";
        if (polygonMates.size() != 1) {
            throw new ModelsIllegalargumentException(polygonMessage, this, this.pm);
        }
        FeatureMate polygonMate = polygonMates.get(0);
        Geometry polygon = polygonMate.getGeometry();
        if (polygon instanceof MultiPolygon) {
            polygon = polygon.getGeometryN(0);
        }
        if (!(polygon instanceof Polygon)) {
            throw new ModelsIllegalargumentException(polygonMessage, this, this.pm);
        }
        List<FeatureMate> pointsMates = FeatureUtilities.featureCollectionToMatesList(this.inElevations);
        if (this.doUseOnlyInternal) {
            PreparedGeometry preparedPolygon = PreparedGeometryFactory.prepare((Geometry)polygon);
            ArrayList<FeatureMate> tmpPointsMates = new ArrayList<FeatureMate>();
            for (FeatureMate featureMate : pointsMates) {
                Geometry geometry = featureMate.getGeometry();
                if (!preparedPolygon.covers(geometry)) continue;
                tmpPointsMates.add(featureMate);
            }
            pointsMates = tmpPointsMates;
        }
        if (pointsMates.size() < 4) {
            throw new ModelsIllegalargumentException("You need at least 4 elevation points (the more, the better) to gain a decent interpolation.", this, this.pm);
        }
        ArrayList<Coordinate> controlPointsList = new ArrayList<Coordinate>();
        if (this.doPolygonborder) {
            this.pm.beginTask("Extract polygon border...", -1);
            Coordinate[] polygonCoordinates = polygon.getCoordinates();
            List<ProfilePoint> profile = CoverageUtilities.doProfile(this.inRaster, polygonCoordinates);
            for (ProfilePoint profilePoint : profile) {
                Coordinate position = profilePoint.getPosition();
                double elevation = profilePoint.getElevation();
                Coordinate coord = new Coordinate(position.x, position.y, elevation);
                controlPointsList.add(coord);
            }
            this.pm.done();
        }
        for (FeatureMate pointsMate : pointsMates) {
            Coordinate coordinate = pointsMate.getGeometry().getCoordinate();
            double elev = pointsMate.getAttribute(this.fElevation, Double.class);
            Coordinate coord = new Coordinate(coordinate.x, coordinate.y, elev);
            controlPointsList.add(coord);
        }
        Coordinate[] controlPoints = controlPointsList.toArray(new Coordinate[0]);
        GridGeometry2D gridGeometry = this.inRaster.getGridGeometry();
        RandomIter randomIter = CoverageUtilities.getRandomIterator(this.inRaster);
        WritableRaster outputWR = CoverageUtilities.createDoubleWritableRaster(cols, rows, null, null, Double.NaN);
        WritableRandomIter outputIter = RandomIterFactory.createWritable((WritableRaster)outputWR, null);
        DefaultFeatureCollection newCollection = new DefaultFeatureCollection();
        newCollection.add(polygonMate.getFeature());
        OmsScanLineRasterizer slRasterizer = new OmsScanLineRasterizer();
        slRasterizer.pm = this.pm;
        slRasterizer.inVector = newCollection;
        slRasterizer.pCols = cols;
        slRasterizer.pRows = rows;
        slRasterizer.pNorth = north;
        slRasterizer.pSouth = south;
        slRasterizer.pEast = east;
        slRasterizer.pWest = west;
        slRasterizer.pValue = 1.0;
        slRasterizer.process();
        GridCoverage2D outRasterized = slRasterizer.outRaster;
        if (this.pMaxbuffer < 0.0) {
            this.pMaxbuffer = Math.max(vectorBounds.getWidth(), vectorBounds.getHeight());
        }
        IDWInterpolator interpolator = new IDWInterpolator(this.pMaxbuffer);
        GridCoordinates2D gridCoord = new GridCoordinates2D();
        RandomIter rasterizedIter = CoverageUtilities.getRandomIterator(outRasterized);
        this.pm.beginTask("Interpolating...", cols);
        for (c = 0; c < cols; ++c) {
            for (r = 0; r < rows; ++r) {
                double probValue = rasterizedIter.getSampleDouble(c, r, 0);
                if (JGTConstants.isNovalue(probValue)) continue;
                gridCoord.setLocation(c, r);
                DirectPosition world = gridGeometry.gridToWorld(gridCoord);
                double[] coordinate = world.getCoordinate();
                double interpolated = interpolator.getValue(controlPoints, new Coordinate(coordinate[0], coordinate[1]));
                outputIter.setSample(c, r, 0, interpolated);
            }
            this.pm.worked(1);
        }
        this.pm.done();
        this.pm.beginTask("Merging with original raster...", cols);
        for (c = 0; c < cols; ++c) {
            for (r = 0; r < rows; ++r) {
                double interpolatedValue = outputIter.getSampleDouble(c, r, 0);
                double rasterValue = randomIter.getSampleDouble(c, r, 0);
                if (JGTConstants.isNovalue(interpolatedValue)) {
                    if (JGTConstants.isNovalue(rasterValue)) continue;
                    outputIter.setSample(c, r, 0, rasterValue);
                    continue;
                }
                if (this.doErode) {
                    outputIter.setSample(c, r, 0, interpolatedValue);
                    continue;
                }
                if (!JGTConstants.isNovalue(rasterValue)) {
                    if (rasterValue < interpolatedValue) {
                        outputIter.setSample(c, r, 0, interpolatedValue);
                        continue;
                    }
                    outputIter.setSample(c, r, 0, rasterValue);
                    continue;
                }
                outputIter.setSample(c, r, 0, interpolatedValue);
            }
            this.pm.worked(1);
        }
        this.pm.done();
        this.outRaster = CoverageUtilities.buildCoverage("raster", outputWR, (HashMap<String, Double>)regionMap, this.inRaster.getCoordinateReferenceSystem());
    }
}

