/*
 * Decompiled with CFR 0.152.
 */
package org.jgrasstools.gears.libs.modules;

import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import org.jgrasstools.gears.libs.monitor.IJGTProgressMonitor;

public class ThreadedRunnable<E> {
    private ExecutorService fixedThreadPool;
    private ConcurrentLinkedQueue<E> queue = new ConcurrentLinkedQueue();
    private IJGTProgressMonitor pm;

    public ThreadedRunnable(int numThreads, IJGTProgressMonitor pm) {
        this.pm = pm;
        this.fixedThreadPool = Executors.newFixedThreadPool(numThreads);
    }

    public void executeRunnable(Runnable runner) {
        this.fixedThreadPool.execute(runner);
    }

    public void waitAndClose() {
        try {
            this.fixedThreadPool.shutdown();
            this.fixedThreadPool.awaitTermination(30L, TimeUnit.DAYS);
            this.fixedThreadPool.shutdownNow();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        if (this.pm != null) {
            this.pm.done();
        }
    }

    public void addToQueue(E item) {
        this.queue.add(item);
    }

    public ConcurrentLinkedQueue<E> getQueue() {
        return this.queue;
    }

    public void setWorkLoad(String task, int workLoad) {
        if (this.pm != null) {
            if (task == null) {
                task = "Processing...";
            }
            this.pm.beginTask(task, workLoad);
        }
    }

    public synchronized void worked(int process) {
        if (this.pm != null) {
            this.pm.worked(process);
        }
    }
}

