/*
 * Decompiled with CFR 0.152.
 */
package org.jgrasstools.gears.libs.modules;

import java.util.ArrayList;
import java.util.List;
import javax.media.jai.iterator.RandomIter;
import org.jgrasstools.gears.libs.modules.Direction;
import org.jgrasstools.gears.libs.modules.JGTConstants;
import org.jgrasstools.gears.libs.modules.Node;
import org.jgrasstools.gears.utils.math.NumericsUtilities;

public class FlowNode
extends Node {
    public static final double OUTLET = 10.0;
    public static double NETVALUE = 2.0;
    public final double flow;
    private boolean isMarkedAsOutlet = false;
    private boolean isHeadingOutside = false;
    private boolean wasHeadingOutsideChecked = false;
    private double eFlow;
    private double enFlow;
    private double nFlow;
    private double nwFlow;
    private double wFlow;
    private double wsFlow;
    private double sFlow;
    private double seFlow;
    private List<FlowNode> enteringNodes;

    public FlowNode(RandomIter flowIter, int cols, int rows, int col, int row) {
        super(flowIter, cols, rows, col, row);
        if (!this.isInRaster(col, row)) {
            this.isValid = false;
            this.flow = Double.NaN;
        } else {
            this.flow = this.gridIter.getSampleDouble(col, row, 0);
            this.isValid = !JGTConstants.isNovalue(this.flow);
        }
        if ((int)this.flow == 10) {
            this.isMarkedAsOutlet = true;
        }
        int index = -1;
        for (int c = -1; c <= 1; ++c) {
            for (int r = -1; r <= 1; ++r) {
                ++index;
                if (c == 0 && r == 0) continue;
                int newC = col + c;
                int newR = row + r;
                double tmp = Double.NaN;
                if (!this.isInRaster(newC, newR)) {
                    this.touchesBound = true;
                } else {
                    tmp = this.gridIter.getSampleDouble(newC, newR, 0);
                }
                switch (index) {
                    case 0: {
                        this.nwFlow = tmp;
                        break;
                    }
                    case 1: {
                        this.wFlow = tmp;
                        break;
                    }
                    case 2: {
                        this.wsFlow = tmp;
                        break;
                    }
                    case 3: {
                        this.nFlow = tmp;
                        break;
                    }
                    case 4: {
                        throw new RuntimeException();
                    }
                    case 5: {
                        this.sFlow = tmp;
                        break;
                    }
                    case 6: {
                        this.enFlow = tmp;
                        break;
                    }
                    case 7: {
                        this.eFlow = tmp;
                        break;
                    }
                    case 8: {
                        this.seFlow = tmp;
                        break;
                    }
                    default: {
                        throw new RuntimeException();
                    }
                }
                if (!JGTConstants.isNovalue(tmp)) continue;
                this.touchesBound = true;
            }
        }
    }

    public String toString() {
        return "FlowNode [\n\tcol=" + this.col + ", \n\trow=" + this.row + ", \n\tflow=" + this.flow + ", \n\tisValid=" + this.isValid() + ", \n\ttouchesBounds=" + this.touchesBound + "\n]";
    }

    public boolean isMarkedAsOutlet() {
        return this.isMarkedAsOutlet;
    }

    public boolean isHeadingOutside() {
        if (!this.wasHeadingOutsideChecked) {
            FlowNode goDownstream;
            this.isHeadingOutside = this.touchesBound ? (goDownstream = this.goDownstream()) == null || !goDownstream.isValid() : false;
            this.wasHeadingOutsideChecked = true;
        }
        return this.isHeadingOutside;
    }

    public boolean isSource() {
        if (!this.isValid()) {
            return false;
        }
        List<FlowNode> enteringNodes = this.getEnteringNodes();
        return enteringNodes.size() == 0;
    }

    public double getFlowAt(Direction direction) {
        switch (direction) {
            case E: {
                return this.eFlow;
            }
            case W: {
                return this.wFlow;
            }
            case N: {
                return this.nFlow;
            }
            case S: {
                return this.sFlow;
            }
            case EN: {
                return this.enFlow;
            }
            case NW: {
                return this.nwFlow;
            }
            case WS: {
                return this.wsFlow;
            }
            case SE: {
                return this.seFlow;
            }
        }
        throw new IllegalArgumentException();
    }

    public FlowNode goDownstream() {
        Direction direction;
        if (this.isValid && (direction = Direction.forFlow((int)this.flow)) != null) {
            FlowNode nextNode = new FlowNode(this.gridIter, this.cols, this.rows, this.col + direction.col, this.row + direction.row);
            if (nextNode.isValid) {
                return nextNode;
            }
        }
        return null;
    }

    public List<FlowNode> getEnteringNodes() {
        if (this.enteringNodes == null) {
            Direction[] orderedDirs;
            this.enteringNodes = new ArrayList<FlowNode>();
            block10: for (Direction direction : orderedDirs = Direction.getOrderedDirs()) {
                switch (direction) {
                    case E: {
                        if ((int)this.eFlow != Direction.E.getEnteringFlow()) continue block10;
                        int newCol = this.col + direction.col;
                        int newRow = this.row + direction.row;
                        FlowNode node = new FlowNode(this.gridIter, this.cols, this.rows, newCol, newRow);
                        this.enteringNodes.add(node);
                        continue block10;
                    }
                    case N: {
                        if ((int)this.nFlow != Direction.N.getEnteringFlow()) continue block10;
                        int newCol = this.col + direction.col;
                        int newRow = this.row + direction.row;
                        FlowNode node = new FlowNode(this.gridIter, this.cols, this.rows, newCol, newRow);
                        this.enteringNodes.add(node);
                        continue block10;
                    }
                    case W: {
                        if ((int)this.wFlow != Direction.W.getEnteringFlow()) continue block10;
                        int newCol = this.col + direction.col;
                        int newRow = this.row + direction.row;
                        FlowNode node = new FlowNode(this.gridIter, this.cols, this.rows, newCol, newRow);
                        this.enteringNodes.add(node);
                        continue block10;
                    }
                    case S: {
                        if ((int)this.sFlow != Direction.S.getEnteringFlow()) continue block10;
                        int newCol = this.col + direction.col;
                        int newRow = this.row + direction.row;
                        FlowNode node = new FlowNode(this.gridIter, this.cols, this.rows, newCol, newRow);
                        this.enteringNodes.add(node);
                        continue block10;
                    }
                    case EN: {
                        if ((int)this.enFlow != Direction.EN.getEnteringFlow()) continue block10;
                        int newCol = this.col + direction.col;
                        int newRow = this.row + direction.row;
                        FlowNode node = new FlowNode(this.gridIter, this.cols, this.rows, newCol, newRow);
                        this.enteringNodes.add(node);
                        continue block10;
                    }
                    case NW: {
                        if ((int)this.nwFlow != Direction.NW.getEnteringFlow()) continue block10;
                        int newCol = this.col + direction.col;
                        int newRow = this.row + direction.row;
                        FlowNode node = new FlowNode(this.gridIter, this.cols, this.rows, newCol, newRow);
                        this.enteringNodes.add(node);
                        continue block10;
                    }
                    case WS: {
                        if ((int)this.wsFlow != Direction.WS.getEnteringFlow()) continue block10;
                        int newCol = this.col + direction.col;
                        int newRow = this.row + direction.row;
                        FlowNode node = new FlowNode(this.gridIter, this.cols, this.rows, newCol, newRow);
                        this.enteringNodes.add(node);
                        continue block10;
                    }
                    case SE: {
                        if ((int)this.seFlow != Direction.SE.getEnteringFlow()) continue block10;
                        int newCol = this.col + direction.col;
                        int newRow = this.row + direction.row;
                        FlowNode node = new FlowNode(this.gridIter, this.cols, this.rows, newCol, newRow);
                        this.enteringNodes.add(node);
                        continue block10;
                    }
                    default: {
                        throw new IllegalArgumentException();
                    }
                }
            }
        }
        return this.enteringNodes;
    }

    public FlowNode getUpstreamTcaBased(RandomIter tcaIter, RandomIter hacklengthIter) {
        Direction[] orderedDirs = Direction.getOrderedDirs();
        double maxTca = Double.NEGATIVE_INFINITY;
        double maxHacklength = Double.NEGATIVE_INFINITY;
        int maxCol = 0;
        int maxRow = 0;
        boolean gotOne = false;
        for (Direction direction : orderedDirs) {
            double flowValue;
            int newCol = 0;
            int newRow = 0;
            switch (direction) {
                case E: {
                    if ((int)this.eFlow != Direction.E.getEnteringFlow()) break;
                    newCol = this.col + direction.col;
                    newRow = this.row + direction.row;
                    gotOne = true;
                    break;
                }
                case N: {
                    if ((int)this.nFlow != Direction.N.getEnteringFlow()) break;
                    newCol = this.col + direction.col;
                    newRow = this.row + direction.row;
                    gotOne = true;
                    break;
                }
                case W: {
                    if ((int)this.wFlow != Direction.W.getEnteringFlow()) break;
                    newCol = this.col + direction.col;
                    newRow = this.row + direction.row;
                    gotOne = true;
                    break;
                }
                case S: {
                    if ((int)this.sFlow != Direction.S.getEnteringFlow()) break;
                    newCol = this.col + direction.col;
                    newRow = this.row + direction.row;
                    gotOne = true;
                    break;
                }
                case EN: {
                    if ((int)this.enFlow != Direction.EN.getEnteringFlow()) break;
                    newCol = this.col + direction.col;
                    newRow = this.row + direction.row;
                    gotOne = true;
                    break;
                }
                case NW: {
                    if ((int)this.nwFlow != Direction.NW.getEnteringFlow()) break;
                    newCol = this.col + direction.col;
                    newRow = this.row + direction.row;
                    gotOne = true;
                    break;
                }
                case WS: {
                    if ((int)this.wsFlow != Direction.WS.getEnteringFlow()) break;
                    newCol = this.col + direction.col;
                    newRow = this.row + direction.row;
                    gotOne = true;
                    break;
                }
                case SE: {
                    if ((int)this.seFlow != Direction.SE.getEnteringFlow()) break;
                    newCol = this.col + direction.col;
                    newRow = this.row + direction.row;
                    gotOne = true;
                    break;
                }
                default: {
                    throw new IllegalArgumentException();
                }
            }
            if (!this.isInRaster(newCol, newRow) || JGTConstants.isNovalue(flowValue = this.gridIter.getSampleDouble(newCol, newRow, 0))) continue;
            double tcaValue = tcaIter.getSampleDouble(newCol, newRow, 0);
            double hacklengthValue = 0.0;
            if (hacklengthIter != null) {
                hacklengthValue = tcaIter.getSampleDouble(newCol, newRow, 0);
            }
            if (NumericsUtilities.dEq(tcaValue, maxTca) && hacklengthIter != null) {
                if (!(hacklengthValue > maxHacklength)) continue;
                maxTca = tcaValue;
                maxCol = newCol;
                maxRow = newRow;
                maxHacklength = hacklengthValue;
                continue;
            }
            if (!(tcaValue > maxTca)) continue;
            maxTca = tcaValue;
            maxCol = newCol;
            maxRow = newRow;
            maxHacklength = hacklengthValue;
        }
        if (!gotOne) {
            return null;
        }
        FlowNode node = new FlowNode(this.gridIter, this.cols, this.rows, maxCol, maxRow);
        return node;
    }

    private boolean isInRaster(int col, int row) {
        return col >= 0 && col < this.cols && row >= 0 && row < this.rows;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.col;
        long temp = Double.doubleToLongBits(this.flow);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        result = 31 * result + this.row;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        FlowNode other = (FlowNode)obj;
        if (this.col != other.col || this.row != other.row) {
            return false;
        }
        return Double.doubleToLongBits(this.flow) == Double.doubleToLongBits(other.flow);
    }
}

